﻿local videodefined = require"videodecet.defined"
local mathfunction = require "mathfunction"
local apolloengine = require "apollocore"
local videodecet = require "videodecet"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local renderqueue = require "apolloutility.renderqueue"
local editorscenemanager = require "editorscene.editorscenemanager"
local apollonode = require "apolloutility.apollonode"
local defined = require "apolloutility.defiend"
local likeapp = require "likeapp"
local soundplayer = require "soundplayer"
local apolloDefine = require "apolloutility.defiend"

local detectmagic = {}

--detectmagic.InsertLocation = renderqueue.CAMERA_LAYER_ZERO + 10;  --renderqueue中的插入点

function detectmagic:Initialize(layer,resourceType)
  self.startScenePath = nil;
  self.transitionScenePath = nil;
  self.endScenePath = nil;
  self.musicPath = nil;
  self.music = nil;
  self.startSceneObjects = nil;
  self.transitionSceneObjects = nil;
  self.endSceneObjects = nil;
  self.loadingTime = 0;
  self.transitionTime = 0.0;
  self.detectDelayTime = 0.0;
  self.detectFlag = false;
  self.loadflag = false;
  self.transitionFlag = false;
  self.endFlag = false;
  self.startFetchFlag = false;  --通知客户端去取图的标记（延迟用）
  self.startTransition = false;
  self.useSDKComic = false;   --是否使用服务端的漫画
  self.detectType = videodefined.triggerType.NULL;
  self.detectValue = 0.0; --如果是延迟触发，则这里会接受延迟时间值
  self.detectDelayAcc = 0.0; --延迟触发延迟时间累计
  self.isLoadingTimeEnd = false;  --load是否结束
  self.isHasImage = false;  --服务端是否返回了漫画结果
  self.startScene = nil;  --第一阶段场景对象
  self.transitionScene = nil;
  self.endScene = nil;
  self.beginTimer = false;
  self.startSceneIndex = 0;
  self.transitionSceneIndex = 0;
  self.endSceneIndex = 0;
  self.layer = layer;
  self.resourceType = resourceType;
  
  self.aaa = 0.0;
end

function detectmagic:LoadConfig(path)
  LOG("detectmagic:LoadConfig");
  local rootconfig = venusjson.LaodJsonFile(path);
  if rootconfig.DetectMagic then
    local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
    local rootdir = pathDir.."/";
    self.startScenePath = rootdir .. rootconfig.DetectMagic.StartScene;
    self.transitionScenePath = rootdir .. rootconfig.DetectMagic.TrasitionScene;
    self.endScenePath = rootdir .. rootconfig.DetectMagic.EndScene;
    self.musicPath = rootdir .. rootconfig.DetectMagic.Music;
    self.music = soundplayer();
    self.music:LoadSound(self.musicPath);
    if rootconfig.DetectMagic.DetectType ~= nil then
      if rootconfig.DetectMagic.DetectType == "Delay" then
        self.detectType = rootconfig.DetectMagic.DetectType;
        self.detectValue = rootconfig.DetectMagic.DetectDelay or 5.0; --如果是延迟触发则默认5秒
        self.DetectDelayDuration = 0.0; --延时触发的不需要再延时  
      else
        self.detectType = videodefined.triggerType[rootconfig.DetectMagic.DetectType];
        self.DetectDelayDuration = rootconfig.DetectMagic.DetectDelay or 5.0;  --其他手势触发的可以配置延时（比如眨眼触发中避免截到闭眼的图片)
        videodecet:ActiveActions({self.detectType});
      end
    else
      ERROR("No detect type is specified!");
    end
    
    
    self.LoadingDuration = rootconfig.DetectMagic.LoadingDuration or 3; --默认为3秒的Loading时间
    self.TrasitionDuration = rootconfig.DetectMagic.TrasitionDuration or 0.3; --转场动画默认0.3秒

    
    --默认加载start场景
    self.startSceneObjects = editorscenemanager:LoadScene(self.startScenePath);
    self:InitAnimation(self.startSceneObjects);
    self.transitionSceneObjects = editorscenemanager:LoadScene(self.transitionScenePath);
    self:InitAnimation(self.transitionSceneObjects);
    self.endSceneObjects = editorscenemanager:LoadScene(self.endScenePath);
    self:InitAnimation(self.endSceneObjects);
    
    --将从CAMERA_LAYER_ZERO到+10的相机Ative
    --for i = 1, 10 do
    --  renderqueue:Activate(renderqueue.CAMERA_LAYER_ZERO + i);
    --end
    
    
    
    local projPath= string.match(self.startScenePath, "(.+)/[^/]*%.%w+$");
    projPath = projPath.."/";
    venuscore.IFileSystem:SetResourcePath(projPath);
    self.startScene,self.startSceneIndex = editorscenemanager:InitScene(self.startSceneObjects,self.layer,self.startSceneIndex);
    
    --self:PreloadComicEffect(); --预加载引擎的漫画
    self.music:PlaySound(0);
    self.begintime = venuscore.ITimerSystem:GetTimevalue();

    self.loadflag = true
  end
  return true;
end

--目前editscene中去掉了Aimation/FramePlayer的自动Play
--为了不修改漫画贴纸素材，这里临时加Play
function detectmagic:InitAnimation(nodeList)
  for i = 1, #nodeList do
    local frameanicom = nodeList[i]:GetComponent(apolloengine.Node.CT_FRAME_PLAYER)
    if frameanicom then
      frameanicom:Play();
    end
        
    local animationcom = nodeList[i]:GetComponent(apolloengine.Node.CT_ANIMATION)
    if animationcom then
      local animations = animationcom:GetAnimations();
      for k,v in pairs(animations) do
        animationcom:Play(k); 
        animationcom:Loop(k,true);
      end
    end
  end

end


function detectmagic:Timespan()
  local now = venuscore.ITimerSystem:GetTimevalue();
  local def = now - self.begintime;
  self.begintime = now;
  return def;
end

-- 对于倒计时类型的漫画贴纸 需要后台返回前台的时候重置时间,因为摄像头刚打开会捕捉到黑色的图片
function detectmagic:ResetTimeline()
  self.begintime = venuscore.ITimerSystem:GetTimevalue();
  self.detectDelayAcc = 0.0;
  return true
end

function detectmagic:PreloadComicEffect()
  local mainCamera = renderqueue:GetCamera(renderqueue.CAMERA_LAYER_LAST);
  if mainCamera then
    self.comic = mainCamera:CreatePostEffect();
    self.comic:CreateResource("comm:script/apolloengine/posteffect/comic.lua");  
    self.comic:Disable();
  end
end


function detectmagic:OnRecordStart()
end

function detectmagic:CheckIsDetected(span)

  local detected = false;
  if self.detectType == "Delay" then
    if self.detectDelayAcc > self.detectValue then
      detected = true;
    else
      local timeSpan = self:Timespan();
      self.detectDelayAcc = self.detectDelayAcc + timeSpan;
    end
  else
    detected, _ = videodecet:isAction(self.detectType);
  end
  return detected;
end


function detectmagic:Update(def)
  local detected = self:CheckIsDetected(def);
  --windows测试
  --[[
  self.aaa = self.aaa + def;
  if self.aaa > 1 then
    detected = true;
  end
  
  
  
  if self.aaa > 30 then
    self:ResetStickerEffect();
  end
  ]]--
  
  
  --检测触发标识
  --没有loading场景，loading场景就是第一阶段的场景
  if detected and not self.detectFlag then
    LOG("release start")
    --editorscenemanager:StopUpdate(); --触发停止更新
    --self.detectDelay = self.detectDelay + def;
    self.detectFlag = true;
      --if _PLATFORM_ANDROID or _PLATFORM_IOS then
      --  likeapp.AI:StartTransition(self.LoadingDuration * 1000);  --通知SDK去取漫画滤镜图片
      --end
  end
  
  --延迟触发，避免取到闭眼的图片
  if self.detectFlag and not self.startFetchFlag then
    self.detectDelayTime = self.detectDelayTime + def;
    if self.detectDelayTime > self.DetectDelayDuration then 
      if _PLATFORM_ANDROID or _PLATFORM_IOS then
        self.inputTex = self.startScene:GetInputTexture();
        local texID = self.inputTex:GetResourceID();
        likeapp.AI:StartTransition(self.LoadingDuration * 1000,texID);  --通知SDK去取漫画滤镜图片
        self.startFetchFlag = true;
      else
        self.inputTex = videodecet:GetVideoTexture();
      end
    else
      return;
    end
  end
  
  --loading场景计时，满足条件加载转场素材
  if self.detectFlag then
    local isTimeEnd = false;  --标识Loading是否应该结束了
    local isHasImage = false; --标识SDK是否返回了漫画结果
    if _PLATFORM_ANDROID or _PLATFORM_IOS then
      isTimeEnd, isHasImage = likeapp.AI:EnterFreezeFrame(); --从SDK处轮询是否需要进去Freezing漫画效果
      
    else
      self.loadingTime = self.loadingTime + def;
      if self.loadingTime > self.LoadingDuration then
        isTimeEnd = true;
        isHasImage = false;
      end
    end
    
    if isTimeEnd then
      self.startTransition = true;
      self.useSDKComic = isHasImage;   --是否使用服务端的漫画
    end
    
    --如果取到了漫画结果
    if self.startTransition then
      if not self.transitionFlag then
        --editorscenemanager:StartUpdate();
        editorscenemanager:DisableCurrentScene();
        local projPath= string.match(self.transitionScenePath, "(.+)/[^/]*%.%w+$");
        projPath = projPath.."/";
        venuscore.IFileSystem:SetResourcePath(projPath);
        self.transitionScene, self.transitionSceneIndex = editorscenemanager:InitScene(self.transitionSceneObjects,self.layer,self.transitionSceneIndex);
        self.transitionFlag = true;
      else
        self.transitionTime = self.transitionTime + def;
      end
      --转场时间满足，加载漫画效果
      if self.transitionTime > self.TrasitionDuration then
        if not self.endFlag then
          editorscenemanager:DisableCurrentScene();
          local projPath= string.match(self.endScenePath, "(.+)/[^/]*%.%w+$");
          projPath = projPath.."/";
          venuscore.IFileSystem:SetResourcePath(projPath);
          self.endScene, self.endSceneIndex = editorscenemanager:InitScene(self.endSceneObjects,
            self.layer, self.endSceneIndex);
          local firstNode = self.endScene:GetFirstNode();
          if firstNode then
            firstNode:SetShow(false);
          end
          
          local sdkComicR = nil;
          --如果SDK没有返回漫画的结果，我们向主相机上挂一个comic滤镜
          if self.useSDKComic == false and self.commicCamera == nil then
            LOG("use engine commic");
            self.commicCamera = apollonode.CameraNode();--新建摄像机
            self.commicCamera:SetName("ComicCamera")
            --self.commicCamera:SetLayerMaskNothing();
            --self.commicCamera:AddLayerMask("NoneSDKComic");
            self.commicCamera.camera:SetSequenceCulling(true);
            self.commicCamera:CreateRealCameraProjection(0.01, 20);--设置摄像机
            self.commicCamera:LookAt(mathfunction.vector3(0,0,0), mathfunction.vector3(0,0,-1),
              mathfunction.vector3(0,1,0));
            self.commicCamera:Recalculate();--手动更新矩阵
            self.commicCamera:SetClearColor(mathfunction.Color(1.0,0.0,0.0,1.0));
            self.commicCamera:Activate();--激活主摄像机
            self.commicCamera:SetSequence(-100000);
  
            self.commicRT = apolloengine.RenderTargetEntity();
            self.commicRT:PushMetadata(--设置FBO格式
              apolloengine.RenderTargetMetadata(
                apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
                apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
                apolloengine.Framework:GetViewport(),
                apolloengine.Framework:GetResolution()));--分辨率
            self.commicTex = self.commicRT:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
            self.commicTex:PushMetadata(--创建纹理
              apolloengine.TextureRenderMetadata(
                apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
                apolloengine.Framework:GetResolution()));
            self.commicRT:CreateResource();
            self.commicCamera:AttachRenderTarget(self.commicRT);
            
            self.comic = self.commicCamera:CreatePostEffect();
            self.comic:CreateResource("comm:script/apolloengine/posteffect/comic.lua");  
            self.comic:Enable();
            
            self.comicQuad = apollonode.QuadNode();
            self.comicQuad:SetSequence(-100000);
            self.comicQuad:CreateResource(defined.flip_material_path,false,false);
            self.comicQuad:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, self.inputTex);
            
            sdkComicR = self.commicTex;
          else
            LOG("use sdk commic");
            sdkComicR = videodecet:GetVideoTexture();
          end
          
            --self.comic:Enable(); --开启引擎自己的漫画
          --else
            --需要接SDK传来的漫画结果画到最顶层            
            local firstCamera = self.endScene:GetFirstCamera();
            self.sdkComicQuad = apollonode.QuadNode();
            self.sdkComicQuad:CreateResource(defined.blit_overlay_material_path,false,false);
            local sequnce = firstCamera:GetSequence();
            local layerMask = firstCamera.LayerMask;
            self.sdkComicQuad:SetLayer(layerMask);
            self.sdkComicQuad:SetResourceType(self.resourceType);
            
            --self.sdkComicQuad:SetSequence(sequnce);
            self.sdkComicQuad:SetName("SDK_COMIC_BLIT "..tostring(sequnce));
            self.sdkComicQuad:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, sdkComicR);
          --end
          self.endFlag = true;
        end
      end
    end
  end
end

--重置场景回到第一阶段
function detectmagic:ResetStickerEffect()

  if not self.loadflag then
    return ;
  end
  self.inputTex = nil;
  self.loadingTime = 0;
  self.transitionTime = 0;
  self.detectDelayTime = 0.0;
  self.detectFlag = false;
  --self.loadflag = false;
  self.transitionFlag = false;
  self.endFlag = false;
  self.startFetchFlag = false;  --通知客户端去取图的标记（延迟用）
  self.startTransition = false;
  self.useSDKComic = false;   --是否使用服务端的漫画
  
  self.sdkComicQuad:Destroy();
  self.sdkComicQuad = nil;
  
  
  self.music:StopSound();
  self.detectDelayAcc = 0.0; --延迟触发延迟时间累计
  editorscenemanager:DisableCurrentScene();
    --删除可能存在的漫画后处理
  if self.commicCamera then
    self.comic:Disable();
    self.commicCamera:DeletePostEffect(self.comic);
    
    self.commicCamera:Destroy();
    self.commicCamera = nil;
    
    self.comic = nil;
    
    self.comicQuad:Destroy();
    self.comicQuad = nil;
    
    self.commicRT = nil;
    self.commicTex = nil;
  end
  
  local projPath= string.match(self.startScenePath, "(.+)/[^/]*%.%w+$");
  projPath = projPath.."/";
  venuscore.IFileSystem:SetResourcePath(projPath);
  self.startScene,self.startSceneIndex = editorscenemanager:InitScene(self.startSceneObjects,self.layer,self.startSceneIndex);
  self.music:PlaySound(0);
  self.begintime = venuscore.ITimerSystem:GetTimevalue();
  collectgarbage();
  return true;
end

function detectmagic:_Clear()
end


function detectmagic:ReleaseResource()
  
  
  if self.loadflag == true then
    local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
    if self.transitionSceneIndex == 0 then
      for i = 1, #self.transitionSceneObjects do
        scene:DeleteNode(self.transitionSceneObjects[i]:GetNativeNode());
      end
    end
    if self.endSceneIndex == 0 then
      for i = 1, #self.endSceneObjects do
        scene:DeleteNode(self.endSceneObjects[i]:GetNativeNode());
      end
    end
  end
  
  
  self.inputTex = nil;
  self.loadflag = false;
  --editorscenemanager:ReleaseResource();
  self.startScenePath = nil;
  self.transitionScenePath = nil;
  self.endScenePath = nil;
  self.musicPath = nil;
  self.music = nil;
  self.startSceneObjects = nil;
  self.transitionSceneObjects = nil;
  self.endSceneObjects = nil;
  self.loadingTime = 0;
  self.transitionTime = 0.0;
  self.detectDelayTime = 0.0;
  self.detectFlag = false;
  self.transitionFlag = false;
  self.endFlag = false;
  self.startFetchFlag = false;  --通知客户端去取图的标记（延迟用）
  self.startTransition = false;
  self.useSDKComic = false;   --是否使用服务端的漫画
  self.detectType = videodefined.triggerType.NULL;
  self.startScene = nil;  --第一阶段场景对象
  self.transitionScene = nil;
  self.endScene = nil;
  self.detectValue = 0.0; --如果是延迟触发，则这里会接受延迟时间值
  self.detectDelayAcc = 0.0; --延迟触发延迟时间累计
  self.startSceneIndex = 0;
  self.transitionSceneIndex = 0;
  self.endSceneIndex = 0;
  
  --for i = 1, 10 do
  --    renderqueue:Deactivate(renderqueue.CAMERA_LAYER_ZERO + i);
  --end
  
  if self.sdkComicQuad then
    self.sdkComicQuad:Destroy();
    self.sdkComicQuad = nil;
  end
  

  
  if self.commicCamera then
    self.comic:Disable();
    self.commicCamera:DeletePostEffect(self.comic);
    self.commicCamera:Destroy();
    self.commicCamera = nil;
    self.comic = nil;
    self.comicQuad:Destroy();
    self.comicQuad = nil;
    self.commicRT = nil;
    self.commicTex = nil;
  end
end

return detectmagic;
