local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local renderqueue = require "apolloutility.renderqueue"

utility = {}

function utility.CreateRenderTarget(size, enabledepth, activate)      
  local rt = apolloengine.RenderTargetEntity();
  rt:PushMetadata(apolloengine.RenderTargetMetadata(apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
                                                    apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
                                                    mathfunction.vector4(0, 0, size:x(), size:y()),
                                                    size)
                  );

  if enabledepth == true then
    rt:MakeBufferAttachment(apolloengine.RenderTargetEntity.TA_DEPTH_STENCIL);
  end
  local tex = rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
  tex:PushMetadata(apolloengine.TextureBufferMetadata(size,
                                                      apolloengine.TextureEntity.TT_TEXTURE2D,
                                                      apolloengine.TextureEntity.TU_READ,
                                                      apolloengine.TextureEntity.PF_R8G8B8A8,
                                                      1, false,
                                                      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
                                                      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
                                                      apolloengine.TextureEntity.TF_LINEAR,
                                                      apolloengine.TextureEntity.TF_LINEAR));
                  
  
  rt:CreateResource();
  
  local camera = apollonode.CameraNode();  
  camera:AttachRenderTarget(rt);
  
  if activate then
    camera:Activate();
  end
  
  return camera, tex;
end

function utility.UpdateVertexStream(rendernode, vtxstream, attribute, newpoints)
  local offset = vtxstream:GetAttributeIndex(attribute);
  for i = 1, newpoints:Size() do
    vtxstream:ChangeVertexDataWithAttributeFast(
                                  offset,
                                  i,
                                  newpoints:Get(i));
  end

  vtxstream:SetReflushInterval(1, newpoints:Size());
  rendernode.render:ChangeVertexBuffer(vtxstream);
end

return utility;
