--local mlbvt = require "machinelearningservice"
local mlbvt = require "masquerade"
local mldefined = require "videodecet.defined"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local mlModel = {}

function mlModel:Initialize(w, h)
  self.height = h
  self.bvtInited = false
  self.EMPTY_KEYPOINTS_ARRAY = mathfunction.vector2array();
  self.faceModel = mlbvt.BvtLoader();
  self.bvtInited = true
  return true;
end

function mlModel:Run(ts)
  if self.bvtInited ~= true  then
    return false
  end

  self.faceModel:Detect(ts);
  self.landmarks = self.faceModel:GetMuglifeFaceData();
  self.hair_mask = self.faceModel:GetMuglifeMaskTexture();

  return true
end


function mlModel:GetInitStatus()
  return true;
end


function mlModel:Clear()
  self.irisModel = nil;
  self.faceModel = nil;
  self.hairSeg = nil;
end


return mlModel