--require "venusdebug"
local asynctexture = require "apolloutility.asynctexture.asynctexture"
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local defined = require "facecute.defined"
local videodecet = require "videodecet"
local rectnode = require "facecute.facesticker2d.rectnode"
local sticker2drect = require "facecute.facesticker2d.sticker2drect"
local facedefined = require "facecute.facechange.facedefined"
local sticker2ddefine = require "facecute.facesticker2d.sticker2ddefine"
local b3 = require "behavior3"
local vc = require "venuscore"
local cjutil = require "cjson.util"
local cjson = require "cjson"
local cutebehavior = require "facecute.behavior.cutebehavior"
local behdefined = require "facecute.behavior.behdefined"
local videodecet = require "videodecet"
local bitop = require "bit"
local visConstTexture = nil;
local cnnseg = require "videodecet.cnnseg"


--stickerrect类型
local sticker2drect3New = sticker2drect:extend();

local _ftexupdata = asynctexture.Update;
local _fsetparameter = sticker2drect3New.SetParameter;



--由此开始是商汤3.0外部调用接口

function sticker2drect3New:new(mainCamera)
    sticker2drect3New.super.new(self, mainCamera);
    self.texturereader:AutoSkip()
end

function sticker2drect3New:GetMaterialPath(blendModeIndex)

    local materialPath;
    if self.texturesplit then
        materialPath = sticker2ddefine.materialPathSplit[blendModeIndex];
    else
        materialPath = sticker2ddefine.materialPath3[blendModeIndex];
    end
    return materialPath;

end

function sticker2drect3New:GetRenderOrder()

    local offset = self.renderoffset;
    local zPos = self.zPos + offset;

    return zPos;
end

function sticker2drect3New:SetRenderOrder(config)
    local zPos = config["zPosition"];
    self.zPos = zPos;

    if self.positonType == sticker2ddefine.positionType.ForeGround then
        self.renderoffset = -2000;
    elseif self.positonType == sticker2ddefine.positionType.Background then
        self.renderoffset = -3000;
    else
        self.renderoffset = -2000;
    end

    if (zPos ~= nil) then

        local offset = self.renderoffset;

        local bindboxV = mathfunction.Aabbox3d(
                mathfunction.vector3(-1, -1, offset + zPos - 1),
                mathfunction.vector3(1, 1, offset + zPos));
        self:SetBindBox(bindboxV);
        self:SetCull(false);
    end
end

local function ModelLengthToWorldLength(le)
    local val = 58 * le / 206.5 / 1000.0;
    return val;
end

function sticker2drect3New:ParseConfig(config, para, compress_root)
    --解析配置表，读取数据，设置初始状态
    self.bParse = false;
    if (config == nil or para == nil) then
        return false;
    end

    if (config["width"] == nil or config["height"] == nil or config["position"] == nil) then
        return false;
    end
    if (config["position"]["positionX"] == nil or config["position"]["positionX"][1] == nil or
            config["position"]["positionX"][1]["x"] == nil or config["position"]["positionX"][1]["y"] == nil or
            config["position"]["positionX"][1]["index"] == nil) then
        return false;
    end

    if (config["positionType"] == nil or config["positionRelationType"] == nil) then
        return false;
    end

    if (para[1] == nil or para[2] == nil) then
        return false;
    end

    self.renderoffset = -2000;

    if config.original_image_size then
        --压缩纹理读取原始尺寸
        self.texSize = config.original_image_size;
        self.texSize = mathfunction.vector2(self.texSize[1], self.texSize[2]);
    end

    self.positonType = config["positionType"];
    self.positionRelationType = config["positionRelationType"];
    if self.positonType == 0 then
        self.positionRelationType = 0;
    end
    self.blendMode = config["blendMode"];
    local width = config["width"];
    local height = config["height"];
    local len = table.getn(config["position"]["positionX"]);
    local posOffset = self:GetRectPosOffset(config);
    local scale = self:GetScale(config);
    local targetFPS = config["targetFPS"]

    --处理过的配置表的读取
    local imagePath = para[1] .. "/" .. para[2] .. "/";
    local imageName = nil;
    local digit, digitstr, imageExt = self:GetDigit(imagePath, para[2], compress_root);
    if (digit == 0) then
        ERROR("sticker 2d: file count failed or ext not matched");
        return false;
    end

    if compress_root then
        self.texturesplit = compress_root.compress_split;
        imageName = para[2] .. "_%0" .. digit .. "d";
    else
        self.texturesplit = false
        imageName = para[2] .. "_%0" .. digit .. "d";
    end

    if self.texturesplit then
        self.settexturefunc = sticker2drect.SetDoubleTexture;
    else
        self.settexturefunc = sticker2drect.SetSingleTexture;
    end

    if targetFPS == nil then
        targetFPS = 30
    end

    local confi = { {}, {}, 1, imagePath, imageName, targetFPS, false, 0 };
    confi[1] = {
        -posOffset[1], posOffset[2], width - posOffset[1], posOffset[2],
        -posOffset[1], -(height - posOffset[2]), width - posOffset[1], -(height - posOffset[2])
    };
    local lenConfi = table.getn(confi[1]);
    self.scale = scale;
    for i = 1, lenConfi do
        confi[1][i] = confi[1][i] * scale * sticker2ddefine.stickerScaleMod;
    end
    local pos, posRefAvg, depth = self:GetRectPosDepRef(config);
    confi[2][1] = -pos[1];
    confi[2][2] = pos[2];
    confi[2][3] = depth;
    self:SetLocalPosition(mathfunction.vector3(
            ModelLengthToWorldLength(confi[2][1]),
            ModelLengthToWorldLength(confi[2][2]),
            confi[2][3]));
    local rectPos = confi[1];

    self.updatefunction = sticker2drect3New.UpdateParamCallBack;

    if self:IsHandPosture(self.positonType) then
        self.rectPosOrg = {};
        for i = 1, #confi[1] do
            self.rectPosOrg[i] = confi[1][i];
        end
    end
    self:SetRenderInitalData(width, height, posOffset, posRefAvg, scale, rectPos);
    --init texturereader
    local res = self:InitTextureReader(confi, compress_root, imageExt);
    --set render order
    self:SetRenderOrder(config);

    self.bParse = true;
    self.curFrame = 0;
    self.stateType = behdefined.stateType.NULL;
    self.version = para[3];

    self:SetBgConstAlphaTexture();
    self:SetVisConstAlphaTexture();

    self:RegisterSegNeedFunc();
    self:SetParameter(apolloengine.ShaderEntity.UNIFORM_POSOFFSET, mathfunction.vector2(0, 0));

    self.animLoop = 0;
    self.animTime = -1.0;

    return res;
end


function sticker2drect3New:GetActionRect(action)

    local len = table.getn(action);
    if len == 0 then
        return nil;
    end

    local as = self.texSize:y() / self.texSize:x();
    for i = 1, len do
        local id = action[i]:GetActionID();
        local rect = action[i]:GetRect();
        local center = action[i]:GetCenter();

        local rectw = math.abs(rect[3] - rect[1]);
        local recth = math.abs(rect[2] - rect[4]);
        --local rectw =recth* facedefined.handSize[2]/ facedefined.handSize[1]
        local vec2 = apolloengine.Framework:GetResolution();
        local centerx = (rect[1] + rect[3]) / 2.0;
        local centery = (rect[4] + rect[2]) / 2.0;
        local lrw = rectw / facedefined.handSize[1];
        local lrh = recth / facedefined.handSize[2];
        local handrect = {};
        if id == sticker2ddefine.positionTypeHand.FingerHeart then
            local lr = math.min(lrw, lrh);
            for i = 1, (#self.rectPosOrg) / 2 do
                --handrect[2*i-1]=self.rectPosOrg[2*i-1]*lr+centerx;
                --handrect[2*i]=self.rectPosOrg[2*i]*lr/(vec2:y()/vec2:x())+centery+rectw/2.0/(vec2:y()/vec2:x());
                handrect[2 * i - 1] = self.rectPosOrg[2 * i - 1] * lr + center[1];
                handrect[2 * i] = self.rectPosOrg[2 * i] * lr / (vec2:y() / vec2:x()) + center[2];
            end
            --[[elseif(self.triggerType==sticker2ddefine.positionTypeHand.Palm) then
                local lr = math.min(lrw,lrh);
                for i=1,(#self.rectPosOrg)/2 do
                    handrect[2*i-1]=self.rectPosOrg[2*i-1]*lr+centerx;
                    handrect[2*i]=self.rectPosOrg[2*i]*lr/(vec2:y()/vec2:x())+centery;
                end]]
        elseif id == sticker2ddefine.positionTypeHand.Love then
            local lr = math.max(lrw, lrh);
            for i = 1, (#self.rectPosOrg) / 2 do
                --handrect[2*i-1]=self.rectPosOrg[2*i-1]*lr+centerx+rectw/5.0;
                handrect[2 * i - 1] = self.rectPosOrg[2 * i - 1] * lr + center[1]
                --handrect[2*i]=self.rectPosOrg[2*i]*lr/(vec2:y()/vec2:x())+centery+recth/2.1;
                handrect[2 * i] = self.rectPosOrg[2 * i] * lr / (vec2:y() / vec2:x()) + center[2];
            end
        elseif id == sticker2ddefine.positionTypeHand.IndexFinger then
            local lr = lrw;
            for i = 1, (#self.rectPosOrg) / 2 do
                --handrect[2*i-1]=self.rectPosOrg[2*i-1]*lr+centerx+rectw/5.0;
                handrect[2 * i - 1] = self.rectPosOrg[2 * i - 1] * lr + center[1]
                --handrect[2*i]=self.rectPosOrg[2*i]*lr/(vec2:y()/vec2:x())+centery+recth/2.1;
                handrect[2 * i] = self.rectPosOrg[2 * i] * lr / (vec2:y() / vec2:x()) + center[2];
            end
        elseif id == sticker2ddefine.positionTypeHand.Holdup then
            local lr = lrw;
            for i = 1, (#self.rectPosOrg) / 2 do
                --handrect[2*i-1]=self.rectPosOrg[2*i-1]*lr+centerx;
                --handrect[2*i]=self.rectPosOrg[2*i]*lr/(vec2:y()/vec2:x())+centery+recth/12.0/(vec2:y()/vec2:x());
                handrect[2 * i - 1] = self.rectPosOrg[2 * i - 1] * lr + center[1];
                handrect[2 * i] = self.rectPosOrg[2 * i] * lr / (vec2:y() / vec2:x()) + center[2];
            end
        else
            local lr = math.min(lrw, lrh);
            for i = 1, (#self.rectPosOrg) / 2 do
                --handrect[2*i-1]=self.rectPosOrg[2*i-1]*lr+centerx;
                --handrect[2*i]=self.rectPosOrg[2*i]*lr/(vec2:y()/vec2:x())+centery;
                handrect[2 * i - 1] = self.rectPosOrg[2 * i - 1] * lr + center[1];
                handrect[2 * i] = self.rectPosOrg[2 * i] * lr / (vec2:y() / vec2:x()) + center[2];
            end
        end
        return handrect;
    end
    return nil;
end

function sticker2drect3New:SetShow(show)
    self:SetVisible(show)
end

----------

function sticker2drect3New:SetRootNode(rootNode)
    rootNode:AttachNode(self)
end

function sticker2drect3New:Finished()
    return not self:IsAnimPlaying()
end

function sticker2drect3New:SeekToFirst()
    self.texturereader:SetAccTime(0)
end

function sticker2drect3New:SeekToMiddle()
    local totalTime = self.texturereader:GetTotalTime()
    self.texturereader:SetAccTime(totalTime * 0.5)
end

function sticker2drect3New:SeekToLast()
    local totalTime = self.texturereader:GetTotalTime()
    if totalTime > 0.0001 then
        self.texturereader:SetAccTime(totalTime - 0.0001)
    else
        self.texturereader:SetAccTime(0)
    end
end

function sticker2drect3New:Show(args)
    self:SetVisible(true)
end

function sticker2drect3New:Hide(args)
    self:SetVisible(false)

    self:AnimUpdate(0);
    self:UpdateParam(0, self.face, self.position, self.rotation, self.action);
    self.animLoop = 0;
    self.animTime = -1;
end

function sticker2drect3New:Start(args)
    if self:IsAnimPlaying() then
        return ;
    end
    self.animLoop = args.loop;
    self.animTime = 0.0;
    self:AnimUpdate(0);
    self:UpdateParam(0, self.face, self.position, self.rotation, self.action);
end

function sticker2drect3New:Stop(args)

end

function sticker2drect3New:Update(timespan, face, position, rotation, action)
    if (self.bParse == false) then
        return
    end
    self.timespan = timespan;
    self.face = face;
    self.position = position;
    self.rotation = rotation;
    self.action = action;
    self.actionRecord = {}

    self:AnimUpdate(timespan);
    self:updatefunction(self);
end

function sticker2drect3New:SetFade(enable)
    self:SetParameter(apolloengine.ShaderEntity.UNIFORM_FADE, mathfunction.vector1(enable));
end

--------

function sticker2drect3New:IsAnimPlaying()
    return self.animTime >= 0
end

function sticker2drect3New:AnimUpdate(timespan)
    if self.animTime == -1.0 then
        return
    end
    if self.animTime == 0.0 then
        self.texturereader:ResetLoopCount();
    end

    self.animTime = self.animTime + timespan;

    local pic = self.settexturefunc(self, timespan);
    --全部loop完成
    if self.animLoop ~= 0 and self.texturereader:GetLoopCount() >= self.animLoop then
        self.animTime = -1;
    end

end

function sticker2drect3New:UpdateParam(timespan, face, position, rotation, action, pic)
    if (self:IsNeedBackGroundSplit()) then
        local cnnsegTex = cnnseg:GetSegTexture();
        cnnsegTex = cnnsegTex and cnnsegTex or self.bgConstAlphaTex;
        _fsetparameter(self, apolloengine.ShaderEntity.TEXTURE_DIFFUSE_BGALPHA, cnnsegTex);
    else
        _fsetparameter(self, apolloengine.ShaderEntity.TEXTURE_DIFFUSE_BGALPHA, self.bgConstAlphaTex);
    end

    self:processViewChange();
    local callbacks = self.proCallbacks;
    if self:IsHandPosture(self.positonType) and action ~= nil then
        for actionIndex, actionElem in ipairs(action) do
            if actionElem.actionid == self.positonType then
                table.insert(self.actionRecord, actionElem)
            end
        end
        local callback = callbacks[sticker2ddefine.positionType.Hand];
        if callback ~= nil then
            callback(self, timespan, face, position, rotation, nil, pic)
        end
    else
        local callback = callbacks[self.positonType];
        if callback ~= nil then
            callback(self, timespan, face, position, rotation, nil, pic);
        end
    end
end

function sticker2drect3New:UpdateParamCallBack()
    local timespan, face, position, rotation, action;
    timespan = self.timespan;
    face = self.face;
    position = self.position;
    rotation = self.rotation;
    action = self.action;
    self:UpdateParam(timespan, face, position, rotation, action);
end

return sticker2drect3New;