local asynctexture = require "apolloutility.asynctexture.asynctexture"
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local defined = require "facecute.defined"
local videodecet = require "videodecet"
local rectnode = require "facecute.facesticker2d.rectnode"
local facedefined = require "facecute.facechange.facedefined"
local sticker2ddefine = require "facecute.facesticker2d.sticker2ddefine"
local b3 = require "behavior3"
local vc = require "venuscore"
local cjutil = require "cjson.util"
local cjson = require "cjson"
local cutebehavior = require "facecute.behavior.cutebehavior"
local behdefined = require "facecute.behavior.behdefined"
local videodecet = require "videodecet"
local bitop = require "bit"
local visConstTexture = nil;
local faceseg = require "videodecet.faceseg"
local videodefined = require "videodecet.defined"
local faceSegType = videodefined.faceSegType
--stickerrect类型
local sticker2drect = rectnode:extend();
local cnnseg= require "videodecet.cnnseg"
function sticker2drect:new(maincamera)
  self.maincamera = maincamera;
  sticker2drect.super.new(self); 
  sticker2drect.super.SetShow(self, false); 
  self:SetName("sticker2drect");
  self.texturereader=asynctexture();
  --self.texturereader:UsingPremultiplyAlphaMode();
  --self.texturereader=texturereader();
  self.mIndex = 0;
  self.seqCount = 1;
  local depth={};
  for i=1,106 do
    depth[i] = 0.05;
  end
  for i=1,6 do
    depth[i]=-0.05;
  end
    for i=7,16 do
    depth[i]=-0.05+(i-7+1)/100;
  end
  for i=26,32 do
    depth[i]=-0.05;
  end
  for i=17,25 do
    depth[i]=0.05-1*(i-17+1)/90.0;
  end
  
  for i=33,37 do
    depth[i]= 0.058;
  end
  for i=64,67 do
    depth[i]= 0.058;
  end
  for i=38,42 do
    depth[i]= 0.058;
  end
  for i=68,71 do
    depth[i]= 0.058;
  end
  depth[0]=-0.05;
  self.depth ={};
  for i=1,106 do
   self.depth[i]=depth[i-1]; 
  end
  self.depth[46] = 0.0633;
  self.depth[45] = 0.05665;
  self.depth[47] = 0.0633;
  self.depth[59] =0.05;
  self.depth[53] =0.02;
  self.depth[62] =0.02;
  self.depth[75] =0.03;
  self.depth[78] =0.03;
  self.depth[107] = 0;
  self.depth[108] = 0;
  
  for i=1,7 do
      self.depth[108+i] = 0;
  end

  apolloengine.ShaderEntity.UNIFORM_MATMVP =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_MATMVP");
    
  apolloengine.ShaderEntity.UNIFORM_CUSTOMER_DEPTH =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_CUSTOMER_DEPTH");
    
  apolloengine.ShaderEntity.TEXTURE_DIFFUSE_RGB =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_DIFFUSE_RGB");
  apolloengine.ShaderEntity.TEXTURE_DIFFUSE_ALPHA =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_DIFFUSE_ALPHA");
    
    
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE_BGALPHA =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_DIFFUSE_BGALPHA");
    
    --  apolloengine.ShaderEntity.ATTRIBUTE_SCREENBGPOS =
    --apolloengine.IMaterialSystem:NewParameterSlot(
    --  apolloengine.ShaderEntity.ATTRIBUTE,
    --  "ATTRIBUTE_SCREENBGPOS");
    
      apolloengine.ShaderEntity.UNIFORM_POSOFFSET =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_POSOFFSET");

      apolloengine.ShaderEntity.UNIFORM_FADE =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_FADE");
    
    self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE1,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
    2);
    
      
  self.bParse = false;
  self.mvp= nil;
  self.rotation = nil;
  self.rectPos =nil; 
  self.curLoop=0;
  self.curInfLoop = 0;
  self.triggerTimeSpan=0;
  self.curTime = 0;
  self.initMark = 0;
  self.curLoop = self.initMark ;
  self.events={};
  self.stateType = behdefined.stateType.NULL;
  self.actions={};
  self.loopCount = -1;
  self.targetType = behdefined.targetType.Sticker2D;
  
  local callbacks = {};
  callbacks[sticker2ddefine.positionType.ForeGround]=self.processForeGround;
  callbacks[sticker2ddefine.positionType.Background] = self.processBackGround;
  callbacks[sticker2ddefine.positionType.PosSizeDepthRotation]=self.processPosSizeDepRotate;
  callbacks[sticker2ddefine.positionType.PosSizeRotation] = self.processPosSizeRotate;
  callbacks[sticker2ddefine.positionType.PosSize] = self.processPosSize;
  callbacks[sticker2ddefine.positionType.Hand] = self.processHand;
  self.proCallbacks = callbacks;
end

function sticker2drect:AddEvent(event)
  table.insert(self.events,event);
end

function sticker2drect:ResetEvent()
  self.events = {};
end

--这个函数是上层在进入的时候根据人头的数量来调用的
--如果是出发类型，就不修改是否显示了，出发类型的显示与否交给节点自己
function sticker2drect:SetShow(isshow)
  if ((self.triggerType==nil or 0 == self.triggerType) and (self.triggerDelay==nil or self.triggerDelay==0))
  then
    sticker2drect.super.SetShow(self,isshow);
    self:SetConstTextureForDIFFUSE(isshow);
    if(isshow==false)
    then
      self:ReStart();
    end
  else
     if(isshow==false)
     then
       --if(self:IsOnFace())
       --then
         sticker2drect.super.SetShow(self,false);
         self:SetConstTextureForDIFFUSE(false);
         self:ReStart();
       --end
     end
  end
end

function sticker2drect:ReStart()
   self.mvp=nil;
   self.rectPos =nil; 
   self.triggerTimeSpan=0;
   self.curLoop=0;
   self.curInfLoop = 0;
   self.texturereader:ReStart();
   self.curTime = 0;
   self.initMark = -10000;
   self.stateType = behdefined.stateType.NULL;
   self.lastActionId = -1;
   self.stateChange = false;
   self.curFrame = 0;   
   self.disAction = nil;
   self.lastAction = nil;
   self.action = nil;
   self.actionRecord = nil;
end



local function ModelLengthToWorldLength(le)
  local val = 58*le/206.5/1000.0;
  return val;
end
function sticker2drect:ParseConfig(config,para, compress_root)
  --解析配置表，读取数据，设置初始状态  
  self.bParse =false;
  if(config==nil or para==nil)
  then
      return false;
  end

  --local width = 74;
  -- local height = 48;
  --local posOffset={36,20};
  --local posIndex = 46;  
  --local confi={{},{},20,"docs:facecute/tex/blacknew/nose/","nose_%05d.png",30,false,0};
  
  --local width = 484;
  --local height =161;
  --local posOffset={234.85,50.13};
  --local posIndex = 46;  
  --local confi={{},{},10,"docs:facecute/tex/blacknew/whisker/","whisker_%05d.png",30,false,0};
  
 -- local width = 570;
 -- local height =228;
 -- local posOffset={296.52,90.25};
 -- local posIndex = 46; 
 
 if(config["width"]==nil or config["height"]==nil or config["position"]==nil)
  then
      return false;
  end
 if(config["position"]["positionX"]==nil or  config["position"]["positionX"][1]==nil or
  config["position"]["positionX"][1]["x"]==nil or config["position"]["positionX"][1]["y"]==nil or config["position"]["positionX"][1]["index"]==nil)
  then 
    return false;
  end
  
  if(config["positionType"]==nil or config["positionRelationType"]==nil )
  then
    return false;
  end
  
  if(para[1]==nil or para[2]==nil)
  then
    return false;
  end
  --if(  para[4]==nil)
  --then
   -- return false;
  --end
  --self.sticker2drectpri = para[4];
  
  if config.original_image_size then--压缩纹理读取原始尺寸
    self.texSize = config.original_image_size;
    self.texSize = mathfunction.vector2(self.texSize[1], self.texSize[2]);
  end

  self.positonType =  config["positionType"];
  self.positionRelationType = config["positionRelationType"];
  if self.positonType == 0 then 
    self.positionRelationType = 0
  end
  self.blendMode =   config["blendMode"];
  local width  =    config["width"];
  local height =    config["height"];
  local len = table.getn(config["position"]["positionX"]);
  local posOffset = self:GetRectPosOffset(config);
  local scale = self:GetScale(config);
  
  --处理过的配置表的读取
  local imagePath = para[1].."/"..para[2].."/";
  local imageName = nil;
  local digit, digitstr, imageExt = self:GetDigit(imagePath,para[2],compress_root);
  if(digit==0)
  then 
    ERROR("sticker 2d: file count failed");
    return false;
  end
  
  if compress_root then
    self.texturesplit = compress_root.compress_split;
    imageName = para[2].."_%0"..digit.."d";
  else
    self.texturesplit = false
    imageName = para[2].."_%0"..digit.."d"; 
  end  

  if self.texturesplit then
    self.settexturefunc = sticker2drect.SetDoubleTexture;
  else
    self.settexturefunc = sticker2drect.SetSingleTexture;
  end  
  
  
  local confi={{},{},1,imagePath,imageName,30,false,0};
  --confi[1]={-posOffset[1],posOffset[2],posOffset[1],posOffset[2],-(width-posOffset[1]),-(height-posOffset[2]),width-posOffset[1],-(height-posOffset[2])};
  confi[1]={-posOffset[1],posOffset[2],width-posOffset[1],posOffset[2],-posOffset[1],-(height-posOffset[2]),width-posOffset[1],-(height-posOffset[2])};
  local lenConfi = table.getn(confi[1]);
  self.scale = scale;
  for i=1,lenConfi do
    confi[1][i] = confi[1][i]*scale*sticker2ddefine.stickerScaleMod;
  end
  local pos,posRefAvg,depth =self:GetRectPosDepRef(config);
  confi[2][1]=-pos[1];
  confi[2][2]=pos[2];
  confi[2][3]= depth;
  self:SetLocalPosition(mathfunction.vector3(ModelLengthToWorldLength(confi[2][1]),ModelLengthToWorldLength(confi[2][2]),confi[2][3]));
  local rectPos = confi[1];
  
  self:SetTrigger(config);
  
  if(self:IsHandPosture( self.positonType) and  self.positonType==self.triggerType )
  then
    self.rectPosOrg={};
    for i=1,#confi[1] do
      self.rectPosOrg[i]=confi[1][i];
    end
  end
  self:SetRenderInitalData(width,height,posOffset,posRefAvg,scale,rectPos);
  --init texturereader
  local res = self:InitTextureReader(confi, compress_root, imageExt);
  --set render order
  self:SetRenderOrder(config);

  self.bParse =true;
  self.curFrame = 0;
  self.stateType = behdefined.stateType.NULL;
  self.version = para[3];
  
  self:SetBgConstAlphaTexture();
  self:SetVisConstAlphaTexture();
 
  self:RegisterSegNeedFunc();
  self:SetParameter(apolloengine.ShaderEntity.UNIFORM_POSOFFSET, mathfunction.vector2(0,0));
 
  return res;
end

function sticker2drect:SetVisConstAlphaTexture()
    if(visConstTexture)
    then
      self.visConstTexture = visConstTexture;
      return;
    end
    self.ts = apolloengine.TextureStream();
    self.ts:SetStreamType(
    	mathfunction.vector2(4,1),
    	apolloengine.TextureEntity.PF_R8G8B8A8);
    for u=1, 4 do
      self.ts:SetPixel(u, 1, mathfunction.vector4(0,0,0,0));
    end    

  visConstTexture= apolloengine.TextureEntity();

  visConstTexture:PushMetadata(
  apolloengine.TextureBufferMetadata(
      apolloengine.TextureEntity.TU_WRITE,
      1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
       self.ts));
 visConstTexture:CreateResource();
 self.visConstTexture = visConstTexture;
end

function sticker2drect:SetBgConstAlphaTexture()
    self.ts = apolloengine.TextureStream();
    self.ts:SetStreamType(
    	mathfunction.vector2(32,1),
    	apolloengine.TextureEntity.PF_L8);
    for u=1, 32 do
      self.ts:SetPixel(u, 1, mathfunction.vector1(0));
    end    

  self.bgConstAlphaTex= apolloengine.TextureEntity();
  self.bgConstAlphaTex:PushMetadata(
  apolloengine.TextureBufferMetadata(
      apolloengine.TextureEntity.TU_WRITE,
      1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
       self.ts));
  self.bgConstAlphaTex:CreateResource();
  
end

function sticker2drect:SetPosOffset()
  
  if((not  self.bmodTrans))
  then
     return;
  end
  if(self.positonType==sticker2ddefine.positionType.PosSizeDepthRotation)
  then
    local vp = self.maincamera:GetViewProj();
    local m = self:GetWorldTransform();
    self.mvp = m*vp;
    local screencen = mathfunction.vector4(0,0,0,1) * m * vp;
    local screencenvec2 = mathfunction.vector2(
      screencen:x() / screencen:w(),
      screencen:y() / screencen:w());
    local face = self.face;
    local Keypoints = face:GetKeypointArray();
    local points = Keypoints[sticker2ddefine.nosePtIndex+1];
    if(points[1]==nil or points[2]==nil or math.abs(points[1])>sticker2ddefine.nilfacejudge or math.abs(points[2])>sticker2ddefine.nilfacejudge)
    then
      return;
    end
    local xoffset = points[1]-screencenvec2:x();
    local yoffset = points[2]-screencenvec2:y();
    self:SetParameter(apolloengine.ShaderEntity.UNIFORM_POSOFFSET, mathfunction.vector2(xoffset,yoffset));
  end


end

function sticker2drect:GetDigit(imagePath, imageName, compress_root)
    local begid = 0;
    local strfix = "";
    local strPath;
    local digit = 0;
    local digitstr = ""
    local ext = ""
    if compress_root and compress_root.compress_split then
        strfix = compress_root.compress_rgb_fix or "";
    end
    for i = 1, 10 do
        digitstr = digitstr .. begid;
        local subname = digitstr .. strfix;
        local isExist = false
        if compress_root then
            ext = compress_root.compress_ext
            strPath = imagePath .. imageName .. "_" .. subname .. ext;
            isExist = vc.IFileSystem:isFileExist(strPath);
        end
        if not isExist then
            ext = ".png"
            strPath = imagePath .. imageName .. "_" .. subname .. ext
            isExist = vc.IFileSystem:isFileExist(strPath);
        end
        if not isExist then
            ext = ".jpg"
            strPath = imagePath .. imageName .. "_" .. subname .. ext
            isExist = vc.IFileSystem:isFileExist(strPath);
        end
        if (isExist) then
            digit = i;
            break ;
        end
    end
  
  return digit, digitstr, ext;
end




function sticker2drect:SetTrigger(config)
  self.triggerType = config["triggerType"];
  self.triggerLoop = config["triggerLoop"];
  self.triggerDelay = config["triggerDelay"];
  self.triggerStop = config["triggerStop"];
  if 0 == self.triggerType and (self.triggerDelay==nil or self.triggerDelay==0)   then
    self.updatefunction = sticker2drect.Render;
  else
    self.updatefunction = sticker2drect.BehaviorUpdate;
  end  
end

function sticker2drect:IsNeedBackGroundSplit()
  
    if(self.positonType==sticker2ddefine.positionType.Background)
    then
      return true;
    end
    return false;
end

function sticker2drect:RegisterSegNeedFunc()
    if(self.positonType==sticker2ddefine.positionType.Background)
    then
      --cnnseg:RegisterCnnSegJudgeFunc(self,self.NeedBackGroundSplit);
      faceseg:RegisterSegJudgeFunc(faceSegType.CNNSEG_FULL,self,self.NeedBackGroundSplit);
    end
end

function sticker2drect:NeedBackGroundSplit()
  
  if(self.stateType == behdefined.stateType.Playing)
  then
    return true;
  end
  
  local actions = videodecet:GetActions();--返回当前识别出来的动作
  local actionLen =#actions;
  for i=1,actionLen do
    local action=actions[i];
    local len = 0;
    if(action~=nil)
    then
      len =table.getn(action);
    end
    for j=1,len do
       local actionId = action[j]:GetActionID();
       if(actionId==self.triggerType)
       then
         return true;
        end
    end
  end
  return false;

end


function sticker2drect:GetRectPosDepRef(config)
  local pos={};
  local posRefAvg={0,0};
  local depth =0 ;
  local len = table.getn(config["position"]["positionX"]);
  if(len==1)
  then
    if(config["position"]["positionX"][1]["index"]==sticker2ddefine.nosePtIndex)
    then
      self.bmodTrans = true;
    end
  elseif(len==2)
    then
    if(config["position"]["positionX"][1]["index"]==sticker2ddefine.nosePtIndex and (config["position"]["positionX"][1]["index"]==config["position"]["positionX"][2]["index"]))
    then
      self.bmodTrans = true;
    end
  end
  for i=1,len do
    local index = config["position"]["positionX"][i]["index"]+1;
    posRefAvg[1]=posRefAvg[1]+facedefined.faceTexPointsExt[index*2-1]+facedefined.faceTexPointsOffset[1];
    posRefAvg[2]=posRefAvg[2]+facedefined.faceTexPointsExt[index*2]+facedefined.faceTexPointsOffset[2];
    depth = depth+self.depth[index];
  end
  posRefAvg[1]= posRefAvg[1]/len;
  posRefAvg[2]= posRefAvg[2]/len;
  depth =depth/len;
  pos[1]=facedefined.faceCenter[1]+sticker2ddefine.faceCenterOffset[1]-(posRefAvg[1]);
  pos[2]=facedefined.faceCenter[2]+sticker2ddefine.faceCenterOffset[2]-(posRefAvg[2]);
  return pos,posRefAvg,depth;
end
function sticker2drect:GetRectPosOffset(config)
  local len = table.getn(config["position"]["positionX"]);
  local posx =0;
  local posy = 0;
  for i=1, len do
    posx =  posx+    config["position"]["positionX"][i]["x"];
    posy =  posy+    config["position"]["positionX"][i]["y"];
  end
  local posOffset=  {posx/len,posy/len};
  return posOffset;
end

function sticker2drect:InitTextureReader(confi, compress_root, imageExt)
  self.frameCount = confi[3];
  self.imagepath= confi[4];
  if compress_root then
    if compress_root.compress_split then
      self.rgbTextureName = confi[5]..compress_root.compress_rgb_fix..compress_root.compress_ext;
      self.alphaTextureName = confi[5]..compress_root.compress_alpha_fix..compress_root.compress_ext;
    else
      self.rgbTextureName = confi[5]..compress_root.compress_ext;
      self.alphaTextureName = nil;
    end
  elseif imageExt ~= nil then
    self.rgbTextureName = confi[5]..imageExt;
    self.alphaTextureName = nil;
  end  
  self.fps = confi[6];
  self.isloop = confi[7];
  self.beginid = confi[8];
  local res;
  if self.texturesplit then
    res = self.texturereader:SequentialLoad(self.fps, true, self.beginid, self.imagepath..self.rgbTextureName, self.imagepath..self.alphaTextureName);
  else
    res = self.texturereader:SequentialLoad(self.fps, true, self.beginid, self.imagepath..self.rgbTextureName);
  end    
  self.texturereader:TryKeepTexture();
  self.texturereader:Preloading();
  if nil == self.texSize then
    self.texSize = self.texturereader:GetSize();
  end  
  return res;
end

function sticker2drect:GetScale(config)
  if(config["scale"]["scaleX"]["pointA"]==nil or config["scale"]["scaleX"]["pointB"]==nil) 
  then
    return 1;
  end
  
  local scaleXPtA = {config["scale"]["scaleX"]["pointA"][1]["index"]+1,config["scale"]["scaleX"]["pointA"][1]["x"],config["scale"]["scaleX"]["pointA"][1]["y"]};
  local scaleXPtB = {config["scale"]["scaleX"]["pointB"][1]["index"]+1,config["scale"]["scaleX"]["pointB"][1]["x"],config["scale"]["scaleX"]["pointB"][1]["y"]};
  local scaleOrgLength = math.pow(facedefined.faceTexPointsExt[scaleXPtB[1]*2-1]-facedefined.faceTexPointsExt[scaleXPtA[1]*2-1],2)
                        +math.pow(facedefined.faceTexPointsExt[scaleXPtB[1]*2]-facedefined.faceTexPointsExt[scaleXPtA[1]*2],2);
  local scaleCurLength = math.pow(scaleXPtB[2]-scaleXPtA[2],2)+math.pow(scaleXPtB[3]-scaleXPtA[3],2);
  --local scale = math.abs(facedefined.faceTexPointsExt[scaleXPtB[1]*2-1]-facedefined.faceTexPointsExt[scaleXPtA[1]*2-1])/math.abs(scaleXPtB[2]-scaleXPtA[2]);
  local scale = 1;
  if(scaleCurLength~=0)
  then
    scale = math.pow(scaleOrgLength/scaleCurLength,0.5);
  end
  return scale;
end


function sticker2drect:SetRenderInitalData(width,height,posOffset,posRefAvg,scale,rectPos)
    for i=1,8 do
      rectPos[i]=ModelLengthToWorldLength(rectPos[i]);
    end

  
    if self.positonType == sticker2ddefine.positionType.ForeGround and 
        self.positionRelationType == sticker2ddefine.positionRelationType.DontMoveWithPosition then 
      --local vec2 = apolloengine.Framework:GetResolution();
      --local as= vec2:y()/vec2:x()/(facedefined.cavasSize[2]/facedefined.cavasSize[1]);
      local canvasSize = facedefined.cavasSize;
      --(xp, yp) the position of clip, normalized by canvasSize
      --posOffset is relative to clip center
      local xp = (posRefAvg[1]-posOffset[1]*scale+width/2*scale)/(canvasSize[1]);
      local yp = (posRefAvg[2]-posOffset[2]*scale+height/2*scale)/(canvasSize[2]);
      --transform to [-1,+1] coordinate, y axis upside-down
      xp = 2*xp-1;
      yp = 1-2*yp;
      --(dx, dy) clip size normalized by canvasSize
      local dx = width * scale / (canvasSize[1]);
      local dy = height * scale / (canvasSize[2]);

      --(dx, dy) should be div by 2, for [x-w/2,y+h/2,x+w/2,y-h/2] form the rect boundaries
      --but then it should be multiply by 2 for coordinate transform
      --so (dx, dy) keeps to be (dx, dy)
      local forePos={xp-dx,yp+dy,xp+dx,yp+dy,xp-dx,yp-dy,xp+dx,yp-dy};
      --self.resvec2 = vec2;

      rectPos = forePos;

      --TODO:
      --when rectPos is set to {-1,1,1,1,-1,-1,1,-1}, and MVP matrix set to id matrix,
      --there are small gaps between clip and screen on both left and right side,
      --which should be a bug, but root cause not found.
      --here only fill the small gap on left edge, 
      --because right edge often has larger x value in practise.
      --just a workaround
      rectPos[1] = rectPos[1] - 0.008;
      rectPos[5] = rectPos[5] - 0.008;
    end  
    
    if( self.positonType==sticker2ddefine.positionType.Background)
    then
      
      
      local vec2 = apolloengine.Framework:GetResolution();
      local yr = vec2:y()/height;
      local xr = vec2:x()/width;
      local as = yr/xr;
      self.resvec2 = vec2;
      self.mbwidth = width;
      self.mbheight = height;
   
      if(as<1.0)
      then
         rectPos={-1,1,1,1,-1,-1/as+1-1/as,1,-1/as+1-1/as};
      else
          rectPos={-1*as,1,1*as,1,-1*as,-1,1*as,-1}; 
      end
    
    end
    self.rectPosInit = rectPos;

  local blendModeIndex = 1;
  if(self.blendMode~=nil)
  then
     blendModeIndex = self.blendMode+1;
  end

  ---local materialPath;
  --if self.texturesplit then
   -- materialPath = sticker2ddefine.materialPathSplit[blendModeIndex];
  --else
    --materialPath = sticker2ddefine.materialPath[blendModeIndex];
  --end  
  local materialPath = self:GetMaterialPath(blendModeIndex);

  self:CreateResource(rectPos,materialPath);
  
  if self.positonType == sticker2ddefine.positionType.Background then
    self:SetParameter(apolloengine.ShaderEntity.UNIFORM_CUSTOMER_DEPTH, mathfunction.vector1(0.999));
  else
    self:SetParameter(apolloengine.ShaderEntity.UNIFORM_CUSTOMER_DEPTH, mathfunction.vector1(0.0));
  end

  --set initial mvp matrix
  local identiyMatrix = mathfunction.Matrix44();
  self:SetParameter(apolloengine.ShaderEntity.UNIFORM_MATMVP, identiyMatrix);
  self:SetParameter(apolloengine.ShaderEntity.UNIFORM_FADE, mathfunction.vector1(1));

end

function sticker2drect:GetMaterialPath(blendModeIndex)
  
  local materialPath;
  if self.texturesplit then
    materialPath = sticker2ddefine.materialPathSplit[blendModeIndex];
  else
    materialPath = sticker2ddefine.materialPath[blendModeIndex];
  end  
  return materialPath;
  
end

function sticker2drect:SetRenderOrder(config)
  local zPos = config["zPosition"];
  self.zPos = zPos;
  if(zPos~=nil)
  then
     --local center = mathfunction.vector3(0, 0,-zPos);
     --local bindboxV = mathfunction.Aabbox3d(
      -- center - mathfunction.vector3(1,1,1),
      -- center + mathfunction.vector3(1,1,1));
     --local bindboxV = mathfunction.Aabbox3d(mathfunction.vector3(-1,1,0-zPos*10-1000),
     --mathfunction.vector3(1,-1,1-zPos*10-1000));
    local offset;
    if self.positonType == sticker2ddefine.positionType.ForeGround then
       offset = -2000;
    elseif self.positonType == sticker2ddefine.positionType.Background then
      offset = -3000;
    else
      offset = -2000;
    end
    
    local bindboxV = mathfunction.Aabbox3d(mathfunction.vector3(-1,-1, offset + zPos -1),
    mathfunction.vector3(1,1,offset + zPos));
   
     self:SetBindBox(bindboxV);
     self:SetCull(false);
  end
end


function sticker2drect:IsOnFace()
  if((self.positonType==sticker2ddefine.positionType.ForeGround  and self.positionRelationType==sticker2ddefine.positionRelationType.DontMoveWithPosition) 
      or self.positonType==sticker2ddefine.positionType.Background) 
  then
    return false;
  end
  
  return true;
end


function sticker2drect:processViewChange()    
    if(self.positonType==sticker2ddefine.positionType.Background) 
    then
       local vec2 = apolloengine.Framework:GetResolution();
       if(self.resvec2:y()~=vec2:y() or self.resvec2:x()~=vec2:x())
       then
          local vec2 = apolloengine.Framework:GetResolution();
          local yr = vec2:y()/self.mbheight;
          local xr = vec2:x()/self.mbwidth;
          local as = yr/xr;
          self.resvec2 = vec2;
          local vec4 = mathfunction.vector4();
          local rectPos=nil;
          if(as<1.0)
          then
             rectPos={-1,1,1,1,-1,-1/as+1-1/as,1,-1/as+1-1/as};
          else
              rectPos={-1*as,1,1*as,1,-1*as,-1,1*as,-1}; 
          end
          for j=1,#rectPos/2 do
              vec4:Set(rectPos[2*j-1],rectPos[2*j],0,1);
              self.vertexstream:ChangeVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, j, vec4);  
          end  
          self.render:ChangeVertexBuffer(self.vertexstream);
       end
    end
end

function sticker2drect:processHand(timespan,face,position,rotation,rectpos,pic)
  local hPos = self:GetActionRect(self.actionRecord);
  if hPos ~= nil then
    self:SetVisible(true);
    self:processHandPri(timespan,face,position, rotation,hPos,pic);
  else
    --self.stateType=sticker2ddefine.stateType.NULL;
    self:SetVisible(false);
    self:ReStart();
  end
end

function sticker2drect:processHandPri(timespan,face,position, rotation,rectPos,pic)
  local identiyMatrix = mathfunction.Matrix44();
  self:SetParameter(apolloengine.ShaderEntity.UNIFORM_MATMVP, identiyMatrix);
  local pos;
  if(self.positionRelationType==sticker2ddefine.positionRelationType.MoveWithPosition) 
  then
      pos = rectPos;
   end   
      if(self.positionRelationType==sticker2ddefine.positionRelationType.DontMoveWithPosition) 
  then
    
      local loopCount = self:GetLoopCount();
      if(loopCount>self.loopCount)
      then
          self.rectpos =nil; 
          self.loopCount=loopCount;
      end
      if(self.rectpos==nil) 
      then
           self.rectpos ={};
           local len = table.getn(rectPos)/2;
           for i=1,len do
                self.rectpos[2*i-1] = rectPos[2*i-1];
                self.rectpos[2*i] = rectPos[2*i];
           end
      end
      pos = self.rectpos;
  end  
  local vec4 = mathfunction.vector4();
  local len = table.getn(pos)/2;
  for j=1,len do
      vec4:Set(pos[2*j-1],pos[2*j],0,1);
      self.vertexstream:ChangeVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, j, vec4);  
  end  
  self.render:ChangeVertexBuffer(self.vertexstream);
end

function sticker2drect:processForeGround(timespan,face,position, rotation,rectPos,pic)
    if(self.positionRelationType==sticker2ddefine.positionRelationType.MoveWithPosition)
    then
      if(rotation~=nil)
      then
        local quat = mathfunction.Quaternion(rotation:x(),rotation:y(),rotation:z(),rotation:w());
        quat:InverseSelf();
        self:SetLocalRotation(quat);
      end
      --local vp = self.maincamera:GetView();
      --local m = self:GetWorldTransform();  
      --local viewcen = mathfunction.vector4(0,0,0,1) * m * vp;
      if(position~=nil)
      then
        self.near = self.maincamera:GetNear();
        local zoom = math.abs(position:z())/self.near/3.5;
        self:SetLocalScale(mathfunction.vector3(zoom,zoom,zoom));
      end
      local vpm = self.maincamera:GetViewProj();
      local mm = self:GetWorldTransform();
      self:SetParameter(apolloengine.ShaderEntity.UNIFORM_MATMVP, mm*vpm); 
    elseif(self.positionRelationType==sticker2ddefine.positionRelationType.DontMoveWithPosition) 
    then
      local identiyMatrix = mathfunction.Matrix44();
      self:SetParameter(apolloengine.ShaderEntity.UNIFORM_MATMVP, identiyMatrix);
     end
end

function sticker2drect:processBackGround(timespan,face,position, rotation,rectPos,pic)
    local identiyMatrix = mathfunction.Matrix44();
    self:SetParameter(apolloengine.ShaderEntity.UNIFORM_MATMVP, identiyMatrix);
end

function sticker2drect:processPosSizeDepRotate(timespan,face,position, rotation,rectPos,pic)
  local vpm = self.maincamera:GetViewProj();
  local mm = self:GetWorldTransform();
  --[[local matrixpri = self.sticker2drectpri.matrix;
  if(matrixpri[sticker2ddefine.positionType.PosSizeDepthRotation]==nil)
  then
     local vpm = self.maincamera:GetViewProj();
     local mm = self:GetWorldTransform();
    matrixpri[sticker2ddefine.positionType.PosSizeDepthRotation] = mm*vpm;
  end]]
  if(self.positionRelationType==sticker2ddefine.positionRelationType.DontMoveWithPosition)
  then
    if(pic==0) 
    then
      self.mvp=nil;
    end
    if(self.mvp==nil)
    then
      local vp = self.maincamera:GetViewProj();
      local m = self:GetWorldTransform();
      self.mvp = m*vp;
      --self.mvp =   matrixpri[sticker2ddefine.positionType.PosSizeDepthRotation];
    end
    self:SetParameter(apolloengine.ShaderEntity.UNIFORM_MATMVP,  self.mvp); 
  else
     self:SetPosOffset();
     self:SetParameter(apolloengine.ShaderEntity.UNIFORM_MATMVP, mm*vpm); 
    --self:SetParameter(apolloengine.ShaderEntity.UNIFORM_MATMVP, matrixpri[sticker2ddefine.positionType.PosSizeDepthRotation]);
  end
end

function sticker2drect:processPosSizeRotate(timespan,face,position, rotation,rectPos,pic)
  local euler = face:GetRotation();
  local quat;
  
  
  quat = mathfunction.Quaternion(rotation:x(),rotation:y(),rotation:z(),rotation:w());
  quat:InverseSelf();
  local eulerQuat = mathfunction.Quaternion();
  eulerQuat:YawPitchRoll(0,0,euler[2]/180*3.1415926);
  self:SetLocalRotation(quat*eulerQuat);
  local vpm = self.maincamera:GetViewProj();
  local mm = self:GetWorldTransform();
  if(self.positionRelationType==sticker2ddefine.positionRelationType.DontMoveWithPosition)
  then
    if(pic==0) 
    then
      self.mvp=nil;
    end
    
    if(self.mvp==nil)
    then
      local vp = self.maincamera:GetViewProj();
      local m = self:GetWorldTransform();
      self.mvp = m*vp;
    end
    self:SetParameter(apolloengine.ShaderEntity.UNIFORM_MATMVP,  self.mvp); 
  else
    self:SetParameter(apolloengine.ShaderEntity.UNIFORM_MATMVP, mm*vpm); 
  end
end

function sticker2drect:GetModTranMatrix()
  
   local matrix = mathfunction.Matrix44();
   if(true or (not  self.bmodTrans) )
   then
     return matrix;
   end
   
    if(self.positonType==sticker2ddefine.positionType.PosSizeDepthRotation)
    then
      local vp = self.maincamera:GetViewProj();
      local m = self:GetWorldTransform();
      self.mvp = m*vp;
      local screencen = mathfunction.vector4(0,0,0,1) * m * vp;
      local screencenvec2 = mathfunction.vector2(
        screencen:x() / screencen:w(),
        screencen:y() / screencen:w());
      local face = self.face;
      local Keypoints = face:GetKeypointArray();
      local points = Keypoints[47];
      local xoffset = points[1]-screencenvec2:x();
      local yoffset = points[2]-screencenvec2:y();
      matrix:SetTransform(mathfunction.vector3(xoffset*screencen:w(),yoffset*screencen:w(),0));
    end
    return matrix;
end


function sticker2drect:processPosSize(timespan,face,position, rotation,rectPos,pic)
  local quat;
  quat = mathfunction.Quaternion(rotation:x(),rotation:y(),rotation:z(),rotation:w());
  quat:InverseSelf();
  self:SetLocalRotation(quat);
  local vpm = self.maincamera:GetViewProj();
  local mm = self:GetWorldTransform();
  if(self.positionRelationType==sticker2ddefine.positionRelationType.DontMoveWithPosition)
  then
    if(pic==0) 
    then
      self.mvp=nil;
    end
    
    if(self.mvp==nil)
    then
      local vp = self.maincamera:GetViewProj();
      local m = self:GetWorldTransform();
      self.mvp = m*vp;
    end
    self:SetParameter(apolloengine.ShaderEntity.UNIFORM_MATMVP,  self.mvp); 
  else
    self:SetParameter(apolloengine.ShaderEntity.UNIFORM_MATMVP, mm*vpm); 
  end
end

function sticker2drect:porcessTriggerTypeLoopInf(timespan,trig,pic)
    --无限循环的情况
  if(self.triggerLoop==0 and self.triggerType==trig)
  then
    self.curInfLoop = 1;
    return true;
  end
  if(self.curInfLoop==1) 
  then
    return true;
  end
end

function  sticker2drect:porcessTriggerTypeLoopSev(timespan,trig,pic)
  --有限循环的情况
   if(self.triggerType==trig and self.curLoop==0) --
   then
       self.curLoop = self.triggerLoop;
       self.texturereader:ResetLoopCount();
   end
  
  if( self.curLoop >0)
  then
     self.curLoop = self.triggerLoop-self.texturereader:GetLoopCount();
     return true;
   end
   
   if(self.curLoop <=0)
   then
     self.curLoop = 0;
     return false;
   end
   
end

function sticker2drect:processTriggerType(timespan,trigp,pic)
  local trig = trigp;
  if(trig==nil)
  then
     return true;
   end
   
  if(self.triggerType==nil or self.triggerLoop==nil or  self.triggerDelay==nil or  self.triggerStop==nil or self.triggerType==sticker2ddefine.triggerType.NULL)
  then
    return true ;-- has no trigger
  end
  --停用tigger的情况
  if( self.triggerStop)
  then
    return false;
  end
  --trigger Delay情况
  if(self.triggerDelay>0)
  then
    if(self.triggerType==trig and  self.triggerTimeSpan==0)--set trigger
    then
      -- self.triggerTimeSpan = timespan;
       self.delayTrigger = trig;

    end
    
    if((self.triggerTimeSpan+timespan)>self.triggerDelay)--trigger start
    then
       trig = self.delayTrigger;
       self:ReStart();
    else
        self.triggerTimeSpan=self.triggerTimeSpan+timespan;
        if((self.triggerLoop>0 and self.curLoop==0) or (self.triggerLoop==0  and self.curInfLoop==0))
        then
          return false;
        end
    end
  end 
  
  if(self.triggerLoop==0)
  then
    return self:porcessTriggerTypeLoopInf(timespan,trig,pic);
  elseif(self.triggerLoop>0)
  then
    return self:porcessTriggerTypeLoopSev(timespan,trig,pic);
  end
end

function sticker2drect:GetActionRect(action)

    local len = table.getn(action);
    if len == 0 then
        return nil;
    end
    
    local as = self.texSize:y() / self.texSize:x();
    for i = 1, len do
        local id = action[i]:GetActionID();
        if self.triggerType == id then
            local rect = action[i]:GetRect();
            local  center = action[i]:GetCenter();
         
            local rectw = math.abs(rect[3]-rect[1]);
            local recth = math.abs(rect[2]-rect[4]);
            --local rectw =recth* facedefined.handSize[2]/ facedefined.handSize[1]
            local vec2 = apolloengine.Framework:GetResolution();
            local centerx = (rect[1]+rect[3])/2.0;
            local centery = (rect[4]+rect[2])/2.0;
            local lrw =rectw/facedefined.handSize[1];
            local lrh = recth/facedefined.handSize[2];
            local handrect={};
            if(self.triggerType==sticker2ddefine.positionTypeHand.FingerHeart) then
                local lr = math.min(lrw,lrh);
                for i = 1, (#self.rectPosOrg) / 2 do
                    --handrect[2*i-1]=self.rectPosOrg[2*i-1]*lr+centerx;
                    --handrect[2*i]=self.rectPosOrg[2*i]*lr/(vec2:y()/vec2:x())+centery+rectw/2.0/(vec2:y()/vec2:x());
                    handrect[2*i-1]=self.rectPosOrg[2*i-1]*lr+center[1];
                    handrect[2*i]=self.rectPosOrg[2*i]*lr/(vec2:y()/vec2:x())+center[2];
                end
            --[[elseif(self.triggerType==sticker2ddefine.positionTypeHand.Palm) then
                local lr = math.min(lrw,lrh);
                for i=1,(#self.rectPosOrg)/2 do
                    handrect[2*i-1]=self.rectPosOrg[2*i-1]*lr+centerx;
                    handrect[2*i]=self.rectPosOrg[2*i]*lr/(vec2:y()/vec2:x())+centery;
                end]]
            elseif(self.triggerType==sticker2ddefine.positionTypeHand.Love) then
                local lr =math.max(lrw,lrh);
                for i=1,(#self.rectPosOrg)/2 do
                    --handrect[2*i-1]=self.rectPosOrg[2*i-1]*lr+centerx+rectw/5.0;
                    handrect[2*i-1]=self.rectPosOrg[2*i-1]*lr+center[1]
                    --handrect[2*i]=self.rectPosOrg[2*i]*lr/(vec2:y()/vec2:x())+centery+recth/2.1;
                    handrect[2*i]=self.rectPosOrg[2*i]*lr/(vec2:y()/vec2:x())+center[2];
                end
            elseif(self.triggerType==sticker2ddefine.positionTypeHand.IndexFinger) then
                local lr = lrw;
                for i=1,(#self.rectPosOrg)/2 do
                    --handrect[2*i-1]=self.rectPosOrg[2*i-1]*lr+centerx+rectw/5.0;
                    handrect[2*i-1]=self.rectPosOrg[2*i-1]*lr+center[1]
                    --handrect[2*i]=self.rectPosOrg[2*i]*lr/(vec2:y()/vec2:x())+centery+recth/2.1;
                    handrect[2*i]=self.rectPosOrg[2*i]*lr/(vec2:y()/vec2:x())+center[2];
                end
            elseif(self.triggerType==sticker2ddefine.positionTypeHand.Holdup) then
                local lr = lrw;
                for i=1,(#self.rectPosOrg)/2 do
                    --handrect[2*i-1]=self.rectPosOrg[2*i-1]*lr+centerx;
                    --handrect[2*i]=self.rectPosOrg[2*i]*lr/(vec2:y()/vec2:x())+centery+recth/12.0/(vec2:y()/vec2:x());
                    handrect[2*i-1]=self.rectPosOrg[2*i-1]*lr+center[1];
                    handrect[2*i]=self.rectPosOrg[2*i]*lr/(vec2:y()/vec2:x())+center[2];
                end
            else
                local lr =math.min(lrw,lrh);
                for i=1,(#self.rectPosOrg)/2 do
                    --handrect[2*i-1]=self.rectPosOrg[2*i-1]*lr+centerx;
                    --handrect[2*i]=self.rectPosOrg[2*i]*lr/(vec2:y()/vec2:x())+centery;
                    handrect[2*i-1]=self.rectPosOrg[2*i-1]*lr+center[1];
                    handrect[2*i]=self.rectPosOrg[2*i]*lr/(vec2:y()/vec2:x())+center[2];
                end
            end
            return handrect;
        end
    end
    return nil;
end

function sticker2drect:GetLoopCount()
  return self.texturereader:GetLoopCount()
end

function sticker2drect:ResetLoopCount()
    self.texturereader:ResetLoopCount();
    self.loopCount = -1;
end


function sticker2drect:GetLoopFrameCount()
  return self.curFrame;
end

function sticker2drect:ResetLoopFrameCount()
  self.curFrame = 0;
end

function sticker2drect:IsHandPosture(postype)  
  for name, type in pairs(sticker2ddefine.positionTypeHand) do
    if(type==postype) then
      return true;
    end
  end
  return false
end

local _ftexupdata = asynctexture.Update;
local _fsetparameter = sticker2drect.SetParameter;



function sticker2drect:SetSingleTexture(timespan)
  local pic;
  self.rgbtexture, pic = _ftexupdata(self.texturereader, timespan);

  if self.rgbtexture then
    _fsetparameter(self, apolloengine.ShaderEntity.TEXTURE_DIFFUSE, self.rgbtexture);     
  end  
  return pic;
end

function sticker2drect:SetDoubleTexture(timespan)
  local pic;
  self.rgbtexture, pic, self.alphatexture = _ftexupdata(self.texturereader, timespan);
  if self.rgbtexture and self.alphatexture then
    _fsetparameter(self, apolloengine.ShaderEntity.TEXTURE_DIFFUSE_RGB, self.rgbtexture); 
    _fsetparameter(self, apolloengine.ShaderEntity.TEXTURE_DIFFUSE_ALPHA, self.alphatexture);   
  end  
  return pic;
end



function sticker2drect:RenderPriv(timespan,face,position,rotation,action)
  --self.rgbtexture,pic = self.texturereader:GetTexture(self.imagepath, self.rgbTextureName,timespan, self.fps, self.isloop,self.beginid);
  local pic = self.settexturefunc(self, timespan);
  if(   self:IsNeedBackGroundSplit() --[[and videodecet.cnnsegtexture~=nil]])
  then
    --LOG("RenderPriv cnnsegtexture")
      --local cnnsegTex = cnnseg:GetSegTexture();
      local cnnsegTex = faceseg:GetSegTexture(faceSegType.CNNSEG_FULL);
      cnnsegTex = cnnsegTex and cnnsegTex or self.bgConstAlphaTex;
      --_fsetparameter(self, apolloengine.ShaderEntity.TEXTURE_DIFFUSE_BGALPHA, videodecet.cnnsegtexture); 
      _fsetparameter(self, apolloengine.ShaderEntity.TEXTURE_DIFFUSE_BGALPHA, cnnsegTex); 
       --_fsetparameter(self, apolloengine.ShaderEntity.TEXTURE_DIFFUSE_BGALPHA, self.bgConstAlphaTex); 
  else
     --_fsetparameter(self, apolloengine.ShaderEntity.TEXTURE_DIFFUSE_BGALPHA, videodecet.cnnsegtexture); 
      _fsetparameter(self, apolloengine.ShaderEntity.TEXTURE_DIFFUSE_BGALPHA, self.bgConstAlphaTex); 
  end
  
   self:processViewChange();
   local callbacks=self.proCallbacks;
   if(self:IsHandPosture( self.positonType) and  self.positonType==self.triggerType  ) 
   then
     --self:processHand(timespan,face,position, rotation,rectpos,pic)
      callbacks[sticker2ddefine.positionType.Hand](self,timespan,face,position, rotation,nil,pic);
      --[[ local hPos = self:GetActionRect(self.actionRecord);
       if(hPos~=nil)
       then
          self:SetVisible(true);
          self:processHand(timespan,face,position, rotation,hPos,pic);
       else
          --self.stateType=sticker2ddefine.stateType.NULL;
          self:SetVisible(false);
          self:ReStart();
       end]]
   else
     local callback = callbacks[self.positonType];
     if(callback~=nil)
     then
       callback(self,timespan,face,position, rotation,nil,pic);
     end
   end
  --[[ elseif(self.positonType==sticker2ddefine.positionType.ForeGround)
   then
       self:processForeGround(timespan,face,position, rotation,rectpos,pic);
   elseif(self.positonType==sticker2ddefine.positionType.Background)
   then 
       self:processBackGround(timespan,face,position, rotation,rectpos,pic);
   elseif(self.positonType==sticker2ddefine.positionType.PosSizeDepthRotation)
   then 
       self:processPosSizeDepRotate(timespan,face,position, rotation,rectpos,pic);
   elseif(self.positonType==sticker2ddefine.positionType.PosSizeRotation)
   then 
       self:processPosSizeRotate(timespan,face,position, rotation,rectpos,pic);
   elseif(self.positonType==sticker2ddefine.positionType.PosSize)
   then   
       self:processPosSize(timespan,face,position, rotation,rectpos,pic);
   else
   end]]
end


function sticker2drect:Render()
    local timespan,face,position,rotation,action;
    timespan =  self.timespan;
    face  = self.face;
    position =  self.position;
    rotation =  self.rotation;
    action   = self.action;
   -- self.rgbtexture,pic = self.texturereader:Update(timespan);
    self:RenderPriv(timespan,face,position,rotation,action);
end

function sticker2drect:GetRenderOrder()
  
  
  local zPos = self.zPos ;
  if(zPos~=nil)
  then
    local offset;
    if self.positonType == sticker2ddefine.positionType.ForgeGround then
       offset = -2000;
    elseif self.positonType == sticker2ddefine.positionType.Background then
      offset = -3000;
    else
      offset = -2000;
    end
     return self.zPos+offset ;
   end
    
  return -2000+self.addIndex;
    
end

function sticker2drect:SetConstTextureForDIFFUSE(vis)
  if(not vis)
  then
      if self.texturesplit then
        _fsetparameter(self, apolloengine.ShaderEntity.TEXTURE_DIFFUSE_RGB, self.visConstAlphaTex); 
        _fsetparameter(self, apolloengine.ShaderEntity.TEXTURE_DIFFUSE_ALPHA, self.visConstAlphaTex);   
      else
         _fsetparameter(self, apolloengine.ShaderEntity.TEXTURE_DIFFUSE, self.visConstAlphaTex);  
      end
      --self.texturereader:SetAccTime(0);
      --self.texturereader:Preloading();
  end
end

function sticker2drect:SetVisible(vis)

    sticker2drect.super.SetShow(self,vis);
    self:SetConstTextureForDIFFUSE(vis);
    
end

function sticker2drect:PauseInFirstFrame()
    --self.texturereader:ReStart();
    self:SetVisible(true);
    self.texturereader:SetAccTime(0);
    local timespan,face,position,rotation,action;
    --timespan =  self.timespan;
    timespan = 0;
    face  = self.face;
    position =  self.position;
    rotation =  self.rotation ;
    action   = self.action;
    self:RenderPriv(0,face,position,rotation,action);
    self.state =  behdefined.stateType.PausedInFirst;
end

function sticker2drect:Play()
    self:SetVisible(true);
    self:RenderPriv(self.timespan,self.face,self.position,self.rotation,self.action);
    self.state =  behdefined.stateType.Playing;
end

function sticker2drect:Pause()
    self:SetVisible(true);
    local timespan,face,position,rotation,action;
    timespan = 0;
    face  = self.face;
    position =  self.position;
    rotation =  self.rotation;
    action   = self.action;
    self:RenderPriv(0,face,position,rotation,action);
    self.state =  behdefined.stateType.Paused;
end

function sticker2drect:PauseInLastFrame()
    self:SetVisible(true);
    local timespan,face,position,rotation,action;
    --timespan =  self.timespan;
    local totalTime = self:GetTotalTime();
    self.texturereader:SetAccTime(totalTime-0.00000001);
    timespan = 0;
    face  = self.face;
    position =  self.position;
    rotation =  self.rotation;
    action   = self.action;
    self:RenderPriv(0,face,position,rotation,action);
    self.state =  behdefined.stateType.PausedInLast;
end

function sticker2drect:Hide()
   sticker2drect.super.SetShow(self,false);
   self.state =  sticker2ddefine.stateType.Invisible; 
end

function sticker2drect:UpdateTargetstate(state,statePara)
  if(self.state==state)
  then
    return
  end
  self.state = state;
  --local statePara={self.delay,self.fadingFrame,self.lastingFrame,self.loop};
  self.triggerLoop = statePara[4];
  self.triggerDelay = statePara[1];
  self.triggerLoopFrame = statePara[3];
end

function sticker2drect:Update(timespan,face,position,rotation,action)
   if(self.bParse==false)
   then
     return;
   end
   self.curFrame = self.curFrame+1;
   self.events= self.events;
   self.timespan = timespan;
   self.face = face;
   self.position = position;
   self.rotation = rotation;
   self.action = action;
   self.actionRecord = action;
   --cutebehavior:tick(self);
   self.updatefunction(self);
end

function sticker2drect:BehaviorUpdate()
  cutebehavior:tick(self);
end

function sticker2drect:NeedSwap()
  return false;
end


return sticker2drect;