require "venusdebug"
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local defined = require "facecute.defined"
local videodecet = require "videodecet"
local facedefined = require "facecute.facechange.facedefined"
local trianglenode = require "facecute.facechange.trianglenode"
local renderqueue = require "apolloutility.renderqueue"
local b3 = require "behavior3"
local vc = require "venuscore"
local cjutil = require "cjson.util"
local cjson = require "cjson"
local cutebehavior = require "facecute.behavior.cutebehavior"
local asynctexture = require "apolloutility.asynctexture.asynctexture"
local behdefined = require "facecute.behavior.behdefined"
--facecover类型
local facecover = trianglenode:extend();
function facecover:new(maincamera)
  self.maincamera = maincamera;
  facecover.super.new(self);  
  self.typeId = 0;
  self.bParse = false;
  facecover.super.SetShow(self, false);
  
    apolloengine.ShaderEntity.TEXTURE_BACKG =
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_BACKG");
    
      apolloengine.ShaderEntity.UNIFORM_ALPHACOF =
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_ALPHACOF");
    
      apolloengine.ShaderEntity.UNIFORM_FACETEXPARA =
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_FACETEXPARA");
    
    apolloengine.ShaderEntity.TEXTURE_BACKG_ALPHA =
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_BACKG_ALPHA");
    apolloengine.ShaderEntity.TEXTURE_BACKG_RGB =
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_BACKG_RGB");
    
    apolloengine.ShaderEntity.TEXTURE_LUT =
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "TEXTURE_LUT");
  
  self.curTime = 0;
  self.initMark = 0;
  self.curLoop = self.initMark ;
  self.curFrame = 0;
  self.events ={};
  self.version = 1.1;
  self.texturereader=asynctexture();
  self.stateType = behdefined.stateType.NULL;
  self.curfadingFrame = 0;
  self.fadingFrame = 0;
  self.targetType = behdefined.targetType.Facechange;
end

function facecover:SetShow(isshow)  
  if (self.triggerType==nil or 0 == self.triggerType)
  then
    facecover.super.SetShow(self,isshow);
    if(isshow==false)
    then
      self:ReStart();
    end
  else
     if(isshow==false)
     then
       --if(self:IsOnFace())
       --then
         facecover.super.SetShow(self,false);
         self:ReStart();
       --end
     end
  end
end

function facecover:GetDigit(imagePath, imageName, compress_root)
    local begid = 0;
    local strfix = "";
    local strPath;
    local digit = 0;
    local digitstr = ""
    local ext = ""
    if compress_root then
        strfix = compress_root.compress_rgb_fix;
        if strfix == nil then
            strfix = ""
        end
    end
    for i = 1, 10 do
        digitstr = digitstr .. begid;
        local subname = digitstr .. strfix;
        local isExist = false
        if compress_root then
            ext = compress_root.compress_ext;
            strPath = imagePath .. imageName .. "_" .. subname .. ext
            isExist = vc.IFileSystem:isFileExist(strPath)
        end
        if not isExist then
            ext = ".png"
            strPath = imagePath .. imageName .. "_" .. subname .. ext
            isExist = vc.IFileSystem:isFileExist(strPath);
        end
        if not isExist then
            ext = ".jpg"
            strPath = imagePath .. imageName .. "_" .. subname .. ext
            isExist = vc.IFileSystem:isFileExist(strPath);
        end
        if (isExist) then
            digit = i;
            break ;
        end
    end

    return digit, digitstr, ext;
end

function facecover:ReStart()
  self.curTime = 0;
  self.initMark = 0;
  self.curLoop = self.initMark ;
  self.curFrame = 0;
  self.stateType = behdefined.stateType.NULL;
  self.curfadingFrame = 0;
  
  self.disAction = nil;
  self.lastAction = nil;
  self.action = nil;
end

local function ModelLengthToWorldLength(le)
  local val = 58*le/206.5/1000.0;
  return val;
end



function facecover:ParseConfig(config, para, compress_root)
  
  --解析配置表，读取数据，设置初始状态  
  self.bParse = false;
  if(config==nil or para==nil)
  then
    return false;
  end

    
  local configImagePath = config["imagePath"];   
  local configPosition  = config["position"];
  local configlipTablePath = config["lipTablePath"];
  --local resPathDir = config["resPathDir"];
  local resPathDir = para[1];
  if(configImagePath==nil or configPosition==nil or resPathDir==nil)
  then
    return false;
  end
  
  local imageScale = config["imageScale"];
  self.imageScale = 1.0;
  if(imageScale~=nil)
  then
    self.imageScale = imageScale;
  end
  
  --处理转换过的json
  if compress_root then
    self.texturesplit = compress_root.compress_split
    self.textureext = compress_root.compress_ext;
  else
    self.texturesplit = false;
    self.textureext = ".png"
  end
  
  if(para["facecoverpri"]==nil)
  then
   return false;
  end
  
  self.facecoverpri = para["facecoverpri"];
  --self.vertexstream = self.facecoverpri.vertexstream;
  
  self.headIndex = para["headIndex"];
  self.bseq= false;
  local actualImgPath =nil;
  local alphaImgPath =nil;
  local liptableImagePath = nil;
  local reImg = string.find(configImagePath, self.textureext);--单独文件的话会有拓展名
  local liptableImg = nil;
  if configlipTablePath ~= nil then
    liptableImg = string.find(configlipTablePath, self.textureext)+1;--单独文件的话会有拓展名
  end
  
  if reImg then
    if self.texturesplit then
      local rgb = string.format(configImagePath, compress_root.compress_rgb_fix);
      local alpha = string.format(configImagePath, compress_root.compress_alpha_fix);
      actualImgPath = para[1] .. "/"..rgb;
      alphaImgPath = para[1] .. "/"..alpha;
    else
      actualImgPath = para[1] .. "/"..configImagePath;
    end    
  else
    local index = string.find(configImagePath, "/[^/]*$");
    local configpath = string.sub(configImagePath, 0, index);
    local configname= string.sub(configImagePath, index + 1, #configImagePath);
    local imagePath = para[1].."/"..configpath..configname.."/";
    local digit,digitstr,imageExt = self:GetDigit(imagePath,configname,compress_root);
    if (digit==0) then
      ERROR("facecover: file count failed or ext not matched");
      return false;
    end
    --local imageName = configname.."_%03d";
      local imageName = configname.."_%0"..digit.."d";
    local confi={{},{},1,imagePath,imageName,30,false,0};
    self:InitTextureReader(confi, compress_root, imageExt);
    actualImgPath = imagePath..string.format(self.rgbTextureName,digitstr);
    if self.texturesplit then
      alphaImgPath = imagePath..string.format(self.alphaTextureName, digitstr);
    end    
    self.bseq = true;
  end  
  
  if liptableImg then
    liptableImagePath = para[1] .. "/"..configlipTablePath;
  end
  
  
  local tex = apolloengine.TextureEntity();
  --local imagePath = "docs:facecute/tex/111.png";
  tex:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_BORDER,
      apolloengine.TextureEntity.TW_CLAMP_TO_BORDER,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      actualImgPath));
  local res = tex:CreateResource();
  self.tex = tex;
  
 if alphaImgPath then
    local atex = apolloengine.TextureEntity();
    atex:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TU_STATIC,
        apolloengine.TextureEntity.PF_AUTO,1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_BORDER,
        apolloengine.TextureEntity.TW_CLAMP_TO_BORDER,
        apolloengine.TextureEntity.TF_LINEAR,
        apolloengine.TextureEntity.TF_LINEAR,
        alphaImgPath));
    res = res and atex:CreateResource();
    self.atex = atex;
  end  
  
  if liptableImagePath then
    local ltex = apolloengine.TextureEntity();
    ltex:PushMetadata(apolloengine.TextureFileMetadata(apolloengine.TextureEntity.TU_STATIC,
        apolloengine.TextureEntity.PF_AUTO,1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_BORDER,
        apolloengine.TextureEntity.TW_CLAMP_TO_BORDER,
        apolloengine.TextureEntity.TF_LINEAR,
        apolloengine.TextureEntity.TF_LINEAR,
        liptableImagePath));
    res = res and ltex:CreateResource();
    self.ltex = ltex;
  end
  
  
  local imsize = nil;
  if config.original_image_size then--压缩纹理读取原始尺寸
    imsize = config.original_image_size;
    imsize = mathfunction.vector2(imsize[1], imsize[2]);
  else
    imsize = tex:GetSize();
  end
  self.imgsize = {imsize:x()*self.imageScale,imsize:y()*self.imageScale};
  
  if not self.texturesplit then
    self:SetParameter(apolloengine.ShaderEntity.TEXTURE_BACKG, self.tex); 
    self:SetParameter(apolloengine.ShaderEntity.TEXTURE_LUT, self.ltex);
  else
    self:SetParameter(apolloengine.ShaderEntity.TEXTURE_BACKG_RGB, self.tex); 
    self:SetParameter(apolloengine.ShaderEntity.TEXTURE_BACKG_ALPHA, self.atex); 
  end  
  
 -- local imgSize = {657,635};
  local imgSize = self.imgsize;
  local faceVecPoints={};
  local facePtTotal = facedefined.facePointCount+facedefined.facePointInterCount;
  for i=1,facePtTotal do
    faceVecPoints[2*i-1]=0;
    faceVecPoints[2*i]=0;
  end
  
 local faceTexs={};
 --local faceTexsOffset = {59,373};
 local    faceTexsOffset ={configPosition[1],configPosition[2]};
 local le = facedefined.facePointCount;
  for i =1,le do
    faceTexs[2*i-1] = facedefined.faceTexPoints[2*i-1]+facedefined.faceTexPointsOffset[1]-faceTexsOffset[1];
    faceTexs[2*i] = facedefined.faceTexPoints[2*i]+facedefined.faceTexPointsOffset[2]-faceTexsOffset[2];
  end
  
  le = facedefined.faceTriIndexCount;
  local faceTris={};
  for i=1,le do
    faceTris[i]=facedefined.faceTriangles[i];
  end
  
  local faceCenter = facedefined.faceCenter;
  local ptAdd = facedefined.facePtAddXY;
  local ptAddZ=facedefined.facePtAddZ;
  self.facePtAdd ={};
  self.facePtAddZ={};
  self.facePt={};
  local faceTexPtAdd={};
  local sc =1.0;
  le = table.getn(ptAdd);
  for i=1,le/2 do
      faceTexPtAdd[2*i-1] = (ptAdd[2*i-1]+faceCenter[1]-faceTexsOffset[1])/imgSize[1];
      faceTexPtAdd[2*i]= (-ptAdd[2*i]+faceCenter[2]-faceTexsOffset[2])/imgSize[2];
      self.facePtAdd[2*i-1]=ModelLengthToWorldLength(ptAdd[2*i-1]);
      self.facePtAdd[2*i]=ModelLengthToWorldLength(ptAdd[2*i]);
      self.facePtAddZ[i]=ptAddZ[i];
  end
  
  local screencen2={};
  for i=1,le/2 do
      screencen2[2*i-1] = 0;
      screencen2[2*i] = 0;
  end
  local facePt={};
  le = facedefined.facePointCount;
  for i =0,le-1 do
      facePt[2*i] = facedefined.faceTexPoints[2*(i+1)-1]+facedefined.faceTexPointsOffset[1];
      facePt[2*i+1] = facedefined.faceTexPoints[2*(i+1)]+facedefined.faceTexPointsOffset[2];
  end
  local offset = 0;
  local faceDtCount=106;
  facePt[(faceDtCount + 0+offset) * 2 + 0] = facePt[(33+offset) * 2 + 0] + (facePt[(33+offset) * 2 + 0] - facePt[(52+offset) * 2 + 0]) * 0.35;
  facePt[(faceDtCount + 0+offset) * 2 + 1] = facePt[(33+offset) * 2 + 1] + (facePt[(33+offset) * 2 + 1] - facePt[(52+offset) * 2 + 1]) * 0.35;
  facePt[(faceDtCount + 1+offset) * 2 + 0] = facePt[(42+offset) * 2 + 0] + (facePt[(42+offset) * 2 + 0] - facePt[(61+offset) * 2 + 0]) * 0.35;
  facePt[(faceDtCount + 1+offset) * 2 + 1] = facePt[(42+offset) * 2 + 1] + (facePt[(42+offset) * 2 + 1] - facePt[(61+offset) * 2 + 1]) * 0.35;
  facePt[(faceDtCount + 2+offset) * 2 + 0] = facePt[(34+offset) * 2 + 0] + (facePt[(34+offset) * 2 + 0] - facePt[(64+offset) * 2 + 0]) * 1.0;
  facePt[(faceDtCount + 2+offset) * 2 + 1] = facePt[(34+offset) * 2 + 1] + (facePt[(34+offset) * 2 + 1] - facePt[(64+offset) * 2 + 1]) * 1.0;
  facePt[(faceDtCount + 3+offset) * 2 + 0] = facePt[(35+offset) * 2 + 0] + (facePt[(35+offset) * 2 + 0] - facePt[(65+offset) * 2 + 0]) * 1.0;
  facePt[(faceDtCount + 3+offset) * 2 + 1] = facePt[(35+offset) * 2 + 1] + (facePt[(35+offset) * 2 + 1] - facePt[(65+offset) * 2 + 1]) * 1.0;
  facePt[(faceDtCount + 4+offset) * 2 + 0] = facePt[(36+offset) * 2 + 0] + (facePt[(36+offset) * 2 + 0] - facePt[(66+offset) * 2 + 0]) * 1.0;
  facePt[(faceDtCount + 4+offset) * 2 + 1] = facePt[(36+offset) * 2 + 1] + (facePt[(36+offset) * 2 + 1] - facePt[(66+offset) * 2 + 1]) * 1.0;
  facePt[(faceDtCount + 5+offset) * 2 + 0] = facePt[(37+offset) * 2 + 0] + (facePt[(37+offset) * 2 + 0] - facePt[(67+offset) * 2 + 0]) * 2.0;
  facePt[(faceDtCount + 5+offset) * 2 + 1] = facePt[(37+offset) * 2 + 1] + (facePt[(37+offset) * 2 + 1] - facePt[(67+offset) * 2 + 1]) * 2.0;
  facePt[(faceDtCount + 6+offset) * 2 + 0] = facePt[(38+offset) * 2 + 0] + (facePt[(38+offset) * 2 + 0] - facePt[(68+offset) * 2 + 0]) * 2.0;
  facePt[(faceDtCount + 6+offset) * 2 + 1] = facePt[(38+offset) * 2 + 1] + (facePt[(38+offset) * 2 + 1] - facePt[(68+offset) * 2 + 1]) * 2.0;
  facePt[(faceDtCount + 7+offset) * 2 + 0] = facePt[(39+offset) * 2 + 0] + (facePt[(39+offset) * 2 + 0] - facePt[(69+offset) * 2 + 0]) * 1.0;
  facePt[(faceDtCount + 7+offset) * 2 + 1] = facePt[(39+offset) * 2 + 1] + (facePt[(39+offset) * 2 + 1] - facePt[(69+offset) * 2 + 1]) * 1.0;
  facePt[(faceDtCount + 8+offset) * 2 + 0] = facePt[(40+offset) * 2 + 0] + (facePt[(40+offset) * 2 + 0] - facePt[(70+offset) * 2 + 0]) * 1.0;
  facePt[(faceDtCount + 8+offset) * 2 + 1] = facePt[(40+offset) * 2 + 1] + (facePt[(40+offset) * 2 + 1] - facePt[(70+offset) * 2 + 1]) * 1.0;
  facePt[(faceDtCount + 9+offset) * 2 + 0] = facePt[(41+offset) * 2 + 0] + (facePt[(41+offset) * 2 + 0] - facePt[(71+offset) * 2 + 0]) * 1.0;
  facePt[(faceDtCount + 9+offset) * 2 + 1] = facePt[(41+offset) * 2 + 1] + (facePt[(41+offset) * 2 + 1] - facePt[(71+offset) * 2 + 1]) * 1.0;
  
  
  for i=1,(#facePt+1)/2 do
    self.facePt[2*i-1] = ModelLengthToWorldLength(facePt[2*(i-1)]);
    self.facePt[2*i] = ModelLengthToWorldLength(facePt[2*(i-1)+1]);
  end
  
  
  local blendTag=config["tag"];
  local blendIndex = facedefined.blendMode[blendTag];
  if(blendIndex==nil)
  then
    blendIndex = 1;
  end
  
  self.blendIndex = blendIndex;
  --blendIndex = 6;
  local materialPath;
  
  --if self.texturesplit then
  --  materialPath = facedefined.materialPathSplit[blendIndex];
 -- else
   -- materialPath = facedefined.materialPath[blendIndex];
 -- end
  materialPath = self:GetMaterialPath(blendIndex);
  --self:CreateResource(faceVecPoints, faceTexs,faceTexPtAdd,faceTris,defined.facechange_material_path,imgSize,screencen2);
  self:CreateResource(faceVecPoints, faceTexs,faceTexPtAdd,faceTris,materialPath,imgSize,screencen2);
  self:SetLocalPosition(mathfunction.vector3(0,0,0.00));
  local zPos = config["zPosition"];
  --[[if(zPos~=nil)
  then
      local offset = -2000;
      local bindboxV = mathfunction.Aabbox3d(
              mathfunction.vector3(-1, -1, offset + zPos - 1),
              mathfunction.vector3( 1,  1, offset + zPos));
    
    self:SetBindBox(bindboxV);
    self:SetCull(false);
  end]]--
  self:SetTrigger(config);
  self.bParse = true;

  self.stateType = behdefined.stateType.NULL;
  local facevecpara = mathfunction.vector4(facedefined.cavasSize[1]/self.imgsize[1],facedefined.cavasSize[2]/self.imgsize[2],
                     -faceTexsOffset[1]/self.imgsize[1],-faceTexsOffset[2]/self.imgsize[2]);
  --local facevecpara = mathfunction.vector4(facedefined.cavasSize[1]/self.imgsize[1],facedefined.cavasSize[2]/self.imgsize[2],
                   --  0,0);
  self:SetParameter(apolloengine.ShaderEntity.UNIFORM_FACETEXPARA, facevecpara);
  
  local zval = config["zPosition"];
  if(zval==nil)
  then
    zval = para["zPos"];
  else
  end
  zval = (zval==nil) and 0 or zval;
  self.addIndex = para["addIndex"];
  self:SetRenderOrder(zval);
  self:SetParameter(apolloengine.ShaderEntity.UNIFORM_ALPHACOF,  mathfunction.vector1(1.0));
  return res;
end


function facecover:GetMaterialPath(blendModeIndex)
  
  local materialPath;
  if self.texturesplit then
    materialPath = facedefined.materialPathSplit[blendModeIndex];
  else
    materialPath = facedefined.materialPath[blendModeIndex];
  end  
  return materialPath;
  
end


function facecover:GetRenderOrder()
  
  local offset = -2000;
  local zorder = offset + self.zPos+self.addIndex/100;

  return zorder;
end

function facecover:SetRenderOrder(z)
  local zPos = z;
  if(zPos~=nil)
  then
    self.zPos = zPos;
    local offset = -2000;
    local bindboxV = mathfunction.Aabbox3d(mathfunction.vector3(-1,-1, offset + zPos+self.addIndex/100 -1),
    mathfunction.vector3(1,1,offset + zPos+self.addIndex/100));
     self:SetBindBox(bindboxV);
     self:SetCull(false);
  end
end

function facecover:InitTextureReader(confi, compress_root, imageExt)
  self.frameCount = confi[3];
  self.imagepath= confi[4];

  if compress_root then
    if compress_root.compress_split then
      self.rgbTextureName = confi[5]..compress_root.compress_rgb_fix..compress_root.compress_ext;
      self.alphaTextureName = confi[5]..compress_root.compress_alpha_fix..compress_root.compress_ext;
    else
      self.rgbTextureName = confi[5]..compress_root.compress_ext;
      self.alphaTextureName = nil;
    end
  elseif imageExt ~= nil then
    self.rgbTextureName = confi[5]..imageExt;
    self.alphaTextureName = nil;
  else
    self.rgbTextureName = confi[5]..self.textureext;
    self.alphaTextureName = nil;
  end  

  self.fps = confi[6];
  self.isloop = confi[7];
  self.beginid = confi[8];
  local res;
  if self.texturesplit then
    res = self.texturereader:SequentialLoad(self.fps, true, self.beginid, self.imagepath..self.rgbTextureName, self.imagepath..self.alphaTextureName);
  else
    res = self.texturereader:SequentialLoad(self.fps, true, self.beginid, self.imagepath..self.rgbTextureName);
  end  
  self.texturereader:TryKeepTexture();
  self.texturereader:Preloading();
  return res;
end

function facecover:NeedSwap()
  return  self.needswap;
end

function facecover:onTrigger()
  return true;
end

function facecover:SetTrigger(config)
  self.triggerType = config["triggerType"];
  self.triggerLoop = config["triggerLoop"];
  self.triggerDelay = config["triggerDelay"];
  self.triggerStop = config["triggerStop"];
end

function facecover:Play()
  self:SetVisible(true);
  self:Render();
end
function facecover:IsNeedZDepth()
  if(false and self.blendIndex==facedefined.blendMode.NONE)
  then
    return true;
  end
  return false;
end

function facecover:IsBeFullFace()
  return self.isFullFace;
end


function facecover:_ChangeVertex()
  local OriginalFaceCoords, _ =  self.facecoverpri:GetFaceCoods();  
  self.vertexstream:ChangeVertexDataArray(
    apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    1,
    2,
    OriginalFaceCoords);  
  
  local addFaceCoords, _ =self.facecoverpri:GetAddedFaceCoods(self.isFullFace);  
  self.vertexstream:ChangeVertexDataArray(
    apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    117,
    2,
    addFaceCoords);
end


function facecover:_ChangeVertexBuffer()
  
  if( self.addIndex~=1)
  then
    return;
  end
  --self.render:ChangeVertexBuffer(self.vertexstream);
  --self.facecoverpri.vertexstream:SetReflushInterval(1,124);
  --local val = self.facecoverpri.vertexstream:GetReflushInterval();
  self.render:ChangeVertexBuffer(self.facecoverpri.vertexstream);
end

function facecover:Render()
   if(self.bParse==false)
  then
     return;
  end
  local face = self.face;
  local timespan = self.timespan;
  local tex = renderqueue:GetLinkedTexture(self.renderLayer);
  self:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, tex);
  if(self.bseq==false)
  then
    if not self.texturesplit then
      self:SetParameter(apolloengine.ShaderEntity.TEXTURE_BACKG, self.tex); 
    else
      self:SetParameter(apolloengine.ShaderEntity.TEXTURE_BACKG_RGB, self.tex); 
      self:SetParameter(apolloengine.ShaderEntity.TEXTURE_BACKG_ALPHA, self.atex); 
    end  
  else
    local slotindex = self.texturesplit 
      and apolloengine.ShaderEntity.TEXTURE_BACKG_RGB
      or apolloengine.ShaderEntity.TEXTURE_BACKG
    self.rgbtexture, pic, self.alphatexture = self.texturereader:Update(timespan);    
    if(self.rgbtexture~=nil)
    then
      self:SetParameter(slotindex, self.rgbtexture);
    end
    if self.alphatexture~=nil then
        self:SetParameter(apolloengine.ShaderEntity.TEXTURE_BACKG_ALPHA, self.alphatexture);
    end
    if self.ltex ~= nil then
      self:SetParameter(apolloengine.ShaderEntity.TEXTURE_LUT, self.ltex);
    end

  end
  
  self:_ChangeVertexBuffer();

end


function facecover:SetVisible(vis)
    facecover.super.SetShow(self,vis);
end

function facecover:GetLoopCount()
  if(self.bseq)
  then
      return 0;
  else
      return  self.texturereader:GetLoopCount();
  end
end

function facecover:ResetLoopCount()
  if(self.bseq)
  then
  else
    return self.texturereader:ResetLoopCount();
  end
end

function facecover:GetLoopFrameCount()
  return self.curFrame;
end

function facecover:AddEvent(event)
   table.insert(self.events,event);
end

function facecover:ResetEvent()
  self.events={};
end

function facecover:SetPreDiffuseTex(tex)
   self:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, tex);
end

--[[function facecover:GetRenderOrder()
  local zPos = self.zPos;
  local offset = -2000;
  if(zPos~=nil)
  then
     local offset = 0;
     return (offset + zPos);
   end
   return -2400+self.addIndex;
end]]--

function facecover:ResetLoopFrameCount()
  self.curFrame = 0;
end

function facecover:Update(timespan, face, position, rotation, action)
  self.timespan = timespan;
  self.face = face;
  self.action = action;
  self.curFrame= self.curFrame+1;
  self:ResetEvent();
  cutebehavior:tick(self);
end
return facecover;