local BundleSystem = require "venuscore.bundle.bundlesystem"
local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local defined = require "apolloutility.defiend"
local mathfunction = require "mathfunction"
local apolloengine = require "apollocore"
local videodecet = require "videodecet"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local editorscene = require "editorscene"
local JointNode = require "apolloengine.nodes.jointnode"
local apollocore = require "apollocore"
local apolloDefine = require "apolloutility.defiend"


local editorscenemanager = {}

function editorscenemanager:Initialize(prevlayer,resourceType)
  self.scene = {};
  self.baseobjects = {};
  self.sceneIndex = 0;
  self.prevLayer = prevlayer;
  self.resourceType = resourceType;
  renderqueue:Activate(self.prevLayer);
  self.lastTex =  renderqueue:GetTexture(self.prevLayer);
  self.currentSceneIndex = 0;
end

function editorscenemanager:LoadConfig(path,insertLocation)
  local rootconfig = venusjson.LaodJsonFile(path);
  if rootconfig.scene then
    apollocore.IResourceSystem:ResourcekeyRedirect(
      defined.LAST_QUEUE_TEXTURE, 
      defined.LAST_QUEUE_TEXTURE_STICKER);
    apolloengine.DeviceResource:PushDeviceResource(
      defined.LAST_QUEUE_TEXTURE_STICKER,
      self.lastTex);
    
    local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
    local rootdir = pathDir.."/";
    venuscore.IFileSystem:SetResourcePath(rootdir);
    local baseobject = self:CreateInstanceFromBundle(venuscore.IFileSystem:PathAssembly(rootconfig.scene));
    local layer = insertLocation or self.prevLayer;
    local newscene = editorscene(layer,self.resourceType);
    newscene:LoadConfig(baseobject);
    self.sceneIndex = self.sceneIndex + 1;
    self.scene[self.sceneIndex] = newscene;
    self.baseobjects[self.sceneIndex] = baseobject;
    
  end
  return true;
end

function editorscenemanager:LoadScene(path)
  local rootconfig = venusjson.LaodJsonFile(path);
  local baseobject = nil;
  if rootconfig.scene then
    local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
    local rootdir = pathDir.."/";
    venuscore.IFileSystem:SetResourcePath(rootdir);
    baseobject = self:CreateInstanceFromBundle(venuscore.IFileSystem:PathAssembly(rootconfig.scene));
    self:DisableObjects(baseobject);
  end
  return baseobject;
end

function editorscenemanager:InitScene(baseobject,insertLayer,index,resourceType)
  local newscene = nil;
  local newsceneIndex = nil;
  local layer = insertLayer or self.prevLayer;
  if self.scene[index] ~= nil then
    newscene = self.scene[index];
    newsceneIndex = index;
  else
    newscene = editorscene(layer,self.resourceType);
    self.sceneIndex = self.sceneIndex + 1;
    self.scene[self.sceneIndex] = newscene;
    self.baseobjects[self.sceneIndex] = baseobject;
    newsceneIndex = self.sceneIndex;
  end
  self:EnableObjects(baseobject);
  newscene:LoadConfig(baseobject);
  newscene:Enable();
  --newscene.enable = true;
  self.currentSceneIndex = newsceneIndex;
  return newscene, newsceneIndex;
end

function editorscenemanager:EnableObjects(objects)
  for i = 1, #objects do
    local rendercom = objects[i]:GetComponent(apolloengine.Node.CT_RENDER)
    if rendercom then
      rendercom:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
    end
    local cameracom = objects[i]:GetComponent(apolloengine.Node.CT_CAMERA)
    if cameracom then
      cameracom:Activate();
    end
  end
end

function editorscenemanager:DisableObjects(objects)
  for i = 1, #objects do
    local rendercom = objects[i]:GetComponent(apolloengine.Node.CT_RENDER)
    if rendercom then
      rendercom:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
    end
    local cameracom = objects[i]:GetComponent(apolloengine.Node.CT_CAMERA)
    if cameracom then
      cameracom:Deactivate();
    end
  end
end

function editorscenemanager:DisableCurrentScene()
  if self.scene[self.currentSceneIndex] and self.baseobjects[self.currentSceneIndex] then
    self:DisableObjects(self.baseobjects[self.currentSceneIndex]);
    self.scene[self.currentSceneIndex]:RemoveCurrentSceneCameras();
    self.scene[self.currentSceneIndex]:Disable();
    --self.scene[self.currentSceneIndex].enable = false;
  end
end

function editorscenemanager:CreateInstanceFromBundle(path)
  local bundlepath = venuscore.IFileSystem:PathAssembly(path);
  local file = io.open(bundlepath, "rb");
  local str = file:read("*a");
  local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
  return BundleSystem:DeSerialize(str,scene,BundleSystem.DeserializeMode.Scene);
end

function editorscenemanager:OnRecordStart()
end

function editorscenemanager:ReleaseResource()
   for i = 1, self.sceneIndex do
    self.scene[i]:ReleaseResource();
    self.scene[i] = nil;
    self.baseobjects[i] = nil;
   end
   self.sceneIndex = 0;
end

function editorscenemanager:Update(def)
  for k,v in pairs(self.scene) do 
    if v.enable then
      v:Update(def)
    end
  end
  
end

return editorscenemanager;
