local BundleSystem = require "venuscore.bundle.bundlesystem"
local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local defined = require "apolloutility.defiend"
local mathfunction = require "mathfunction"
local apolloengine = require "apollocore"
local videodecet = require "videodecet"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local editorscene = require "editorscene"
local GenericNode = require "apolloengine.nodes.genericnode"
local apolloDefine = require "apolloutility.defiend"

local editormakeupmanager = {}

function editormakeupmanager:Initialize(layer,resourceType)
  self.scene = {};
  self.baseobjects = {};
  self.layer = layer;
  self.resourceType = resourceType;
  renderqueue:Activate(self.layer);
end

function editormakeupmanager:LoadConfig(path,makeuptype,rootconfig)
  if rootconfig.scene then
    if self.scene[makeuptype] ~= nil then --加载同类型素材
      --self.scene[makeuptype]["scene"]:ReleaseResource();
      --self.scene[makeuptype] = nil;
      --self.baseobjects[makeuptype] = nil;
      self:ReleaseResource(makeuptype);
    end
    local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
    local rootdir = pathDir.."/"; 
    venuscore.IFileSystem:SetResourcePath(rootdir);
    local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
    
    --收集美妆Node
    --scene:Begin(makeuptype);
    local baseobject = self:CreateInstanceFromBundle(venuscore.IFileSystem:PathAssembly(rootconfig.scene),scene,BundleSystem.DeserializeMode.Scene);
    --local layer = renderqueue.CAMERA_LAYER_FIRST;
    local layer = self.layer;
    --local newscene = editorscene(layer,self.mainrt);
    local newscene = editorscene(layer,self.resourceType);
    newscene:LoadConfig(baseobject);
    self.scene[makeuptype] = {["index"] = newscene.index,["scene"] = newscene};
    self.baseobjects[makeuptype] = {["index"] = newscene.index,["baseobject"] = baseobject};
    --scene:End(makeuptype);
  end
  return true;
end


function editormakeupmanager:CreateInstanceFromBundle(path)
  local bundlepath = venuscore.IFileSystem:PathAssembly(path);
  local file = io.open(bundlepath, "rb");
  local str = file:read("*a");
  local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
  return BundleSystem:DeSerialize(str,scene,BundleSystem.DeserializeMode.Scene);
end

function editormakeupmanager:OnRecordStart()
end

function editormakeupmanager:IsExistMakeup()
  --self.scene是makeuptype的hash表
  if next(self.scene) ~= nil then 
    return true;
  end
  return false;
end


function editormakeupmanager:ReleaseResource(makeuptype)
  if self.scene[makeuptype] ~= nil then
    self.baseobjects[makeuptype] = nil;
    self.scene[makeuptype]["scene"]:ReleaseResource();
    self.scene[makeuptype] = nil;
    collectgarbage();
    return true;
  end
  
  return false;
end


function editormakeupmanager:SetMakeupStrength(strength, maketype)
  if self.scene[maketype] ~= nil then
    self.scene[maketype]["scene"]:SetMakeupStrength(strength, maketype);
    return true;
  end
  
  return false;
end


function editormakeupmanager:Update(def)
  
  for k,v in pairs(self.scene) do 
    v["scene"]:Update(def)
  end
  
end

return editormakeupmanager;
