local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local SquareInfo = require "biugo.squareinfo";
local Object = require "classic"
local apolloDefine = require "apolloutility.defiend"
local renderqueue = require "apolloutility.renderqueue"



local MaskRender = Object:extend();


function MaskRender:new(material)

  local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
  self.node = scene:CreateNode(apolloengine.Node.CT_NODE);
  --self.node = apolloengine.Node();
  apolloengine.ShaderEntity.MASK_TEXTURE =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"MASK_TEXTURE");
  apolloengine.ShaderEntity.MASK_CHANNEL = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"MASK_CHANNEL");
  apolloengine.ShaderEntity.CUSTOM_TEXTURE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"CUSTOM_TEXTURE");
  apolloengine.ShaderEntity.CUSTOM_TEXTURE_COORDNITE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"MASK_COORNIDATE");
  apolloengine.ShaderEntity.MASK_LOCATION = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"MASK_LOCATION");
  apolloengine.ShaderEntity.TEXTURE_SIZE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "TEXTURE_SIZE");
  


  self.render = self.node:CreateComponent(apolloengine.Node.CT_RENDER);
  self:SetShow(false);


  self.vertexstream = apolloengine.VertexStream();
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,4);
   self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);
  --self.vertexstream:ReserveBuffer(4);
  self.vertexstream:ReserveBuffer((SquareInfo.split_w + 1) * (SquareInfo.split_h + 1));

  self.indexstream = apolloengine.IndicesStream();
  self.indexstream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
  --self.indexstream:ReserveBuffer(6);
  self.indexstream:ReserveBuffer(SquareInfo.split_w * SquareInfo.split_h * 6);



  --vertex data
  for i = 1, (SquareInfo.split_w + 1) * (SquareInfo.split_h + 1) do
	self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector4(0,0,0,0));
	self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,mathfunction.vector2(0.0,0.0));
  end

  --index
  for i = 1, SquareInfo.split_h do
    for j = 1, SquareInfo.split_w do
		self.indexstream:PushIndicesData((i - 1) * (SquareInfo.split_w + 1) + (j - 1));  --0
		self.indexstream:PushIndicesData(i * (SquareInfo.split_w + 1) + (j - 1));  --2
		self.indexstream:PushIndicesData(i * (SquareInfo.split_w + 1) + j); --3
		self.indexstream:PushIndicesData((i - 1) * (SquareInfo.split_w + 1) + (j - 1)); --0
		self.indexstream:PushIndicesData(i * (SquareInfo.split_w + 1) + j); --3
		self.indexstream:PushIndicesData((i - 1) * (SquareInfo.split_w + 1) + j); --1
    end
  end


  --材质元数据
  self.render:PushMetadata(
    apolloengine.RenderObjectMaterialMetadata(
      apolloengine.StringBufferMetadata(material)));
  
  --self.render:PushMetadata(
  --  apolloengine.RenderObjectMaterialMetadata(
  --    apolloengine.PathMetadata(material)));

  --顶点流元数据
  self.render:PushMetadata(
		apolloengine.RenderObjectMeshMetadate(
			apolloengine.RenderComponent.RM_TRIANGLES,
      apolloengine.ReferenceVertexMetadata(
        apolloengine.VertexBufferEntity.MU_DYNAMIC,--使用可以修改的显存区域
        self.vertexstream),
      apolloengine.ReferenceIndicesMetadata(
        apolloengine.VertexBufferEntity.MU_STATIC,--使用不可修改的显存区域
        self.indexstream)));
  self.render:CreateResource();


  self.mask_channel_uniform = mathfunction.vector3(0,0,0);
  self.mask_location = mathfunction.vector1(0.0);
end

function MaskRender:SetShow(isshow)
  if isshow then
    self.render:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
  else
    self.render:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
  end
end

function MaskRender:SetSequence(s)
  self.render:SetSequence(s);
end

--新的renderqueue要求传一个Node进去，但是C++的Node是没有SetSequence函数的
--这里Hack下，传递renderomponent下去
function MaskRender:After()
  renderqueue:After(self.node)
end


function MaskRender:SetCustomTexture(customtexture)
  self.render:SetParameter(apolloengine.ShaderEntity.CUSTOM_TEXTURE,customtexture);
  --LOG("MaskRender: " .. tostring(apolloengine.ShaderEntity.CUSTOM_TEXTURE));
end


function MaskRender:SetMaskTexture(masktexture,maskchannel)
  self:SetMaskChannel(maskchannel);
  self.render:SetParameter(apolloengine.ShaderEntity.MASK_TEXTURE,masktexture);
  
  local tex_size = masktexture:GetSize();
  self.render:SetParameter(apolloengine.ShaderEntity.TEXTURE_SIZE,mathfunction.vector2(tex_size:x(),tex_size:y()));
end

function MaskRender:SetMaskChannel(mask_channel)
  if mask_channel == "R" then
    self.mask_channel_uniform:Set(1.0,0,0);
    self.mask_location:Set(0.0);
  elseif mask_channel == "G" then
    self.mask_channel_uniform:Set(0,1.0,0);
    self.mask_location:Set(1.0);
  elseif mask_channel == "B" then
    self.mask_channel_uniform:Set(0,0,1.0);
    self.mask_location:Set(2.0);
  end
  self.render:SetParameter(apolloengine.ShaderEntity.MASK_CHANNEL,self.mask_channel_uniform);
  self.render:SetParameter(apolloengine.ShaderEntity.MASK_LOCATION,self.mask_location);
end



--更新顶点流
function MaskRender:Update(vertexArray,texcoordArray)
  local newpoint =  mathfunction.vector4(0, 0, 0, 1);
  local newtexcoord = mathfunction.vector2(0,0);
  local index_vertex = self.vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_POSITION);
  local index_texcoord = self.vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0);


  for i = 1, #vertexArray do
    local point = vertexArray[i];
    newpoint:Set(point[1],point[2],0,1);
    self.vertexstream:ChangeVertexDataWithAttributeFast(
      index_vertex,
      i,
      newpoint);
  end

  for i = 1, #texcoordArray do
	local texcoord = texcoordArray[i];
    newtexcoord:Set(texcoord[1],texcoord[2]);
    self.vertexstream:ChangeVertexDataWithAttributeFast(
      index_texcoord,
      i,
      newtexcoord);
  end



  self.vertexstream:SetReflushInterval(1, (SquareInfo.split_h + 1) * (SquareInfo.split_w + 1));
  self.render:ChangeVertexBuffer(self.vertexstream);
end



function MaskRender:Update2(points,texcoords)
  local newpoint =  mathfunction.vector4(0, 0, 0, 1);
  local newTexcoord = mathfunction.vector2(0,0);
  local index_vertex = self.vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_POSITION);
  local index_texcoord = self.vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0);
  
  
  for i = 1, #points do
    local point = points[i];
    newpoint:Set(point[1],point[2],0,1);
    self.vertexstream:ChangeVertexDataWithAttributeFast(
      index_vertex,
      i,
      newpoint);
    local texcoord = texcoords[i];
    newTexcoord:Set(texcoord[1],texcoord[2]);
    self.vertexstream:ChangeVertexDataWithAttributeFast(
      index_texcoord,
      i,
      newTexcoord);
  end
  
 
  self.vertexstream:SetReflushInterval(1, 4);
  self.render:ChangeVertexBuffer(self.vertexstream);
  --self.render:SetDrawCount(6);
end

--目前Node需要自己删除
function MaskRender:Clear()
  local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
  scene:DeleteNode(self.node);
  self.node = nil;
end


return MaskRender;