local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local pnpestimates = require "pnpestimates"
local cv = require "computervisionfunction"


local MaterialSwitchBehavior = venuscore.VenusBehavior:extend("MaterialSwitchBehavior");

function MaterialSwitchBehavior:GetTest()
    return self.matpath;
end

function MaterialSwitchBehavior:SetTest(value)
    self.matpath = value;
end


function MaterialSwitchBehavior:GetRender()
    if self.render==nil then
        self.render = self.Node:GetComponent(apolloengine.Node.CT_RENDER);
        if self.render==nil then
         LOG("WE HAVE NO render COMPOENENT!")
        end
    end
    return  self.render;
end

function MaterialSwitchBehavior:new()
    self.matpath = "";
    --self.offset = mathfunction.vector3(2.0,2.0,2.0);
end

function MaterialSwitchBehavior:_OnStart()
    if self.matpath~="" then
        LOG("Switch head gogogo");
        local render = self:GetRender();
        local meta = apolloengine.MaterialMetadata(self.matpath);
        local sceneid = self.Node:GetHostScene():GetStaticID();
        meta:SetSceneID(sceneid);
        local materialEntity = apolloengine.MaterialEntity();
        materialEntity:PushMetadata(meta);
        materialEntity:CreateResource();
        render:ChangeMaterial(materialEntity, 1);
    end

    LOG("Switch head over ".. self.matpath);
end


function MaterialSwitchBehavior:_OnUpdate()
    --[[
    if self.offset:x()<1.0 then
        local render = self:GetRender();
        local meta = apolloengine.MaterialMetadata(self.matpath);
        local sceneid = self.Node:GetHostScene():GetStaticID();
        meta:SetSceneID(sceneid);
        local materialEntity = apolloengine.MaterialEntity();
        materialEntity:PushMetadata(meta);
        materialEntity:CreateResource();
        render:ChangeMaterial(materialEntity, 1);
        self.offset[1] = 3.0;
    end
    ]]
end

--MaterialSwitchBehavior:MemberRegister("offset");

MaterialSwitchBehavior:MemberRegister("matpath",  
  venuscore.ScriptTypes.FilePathType(
    {"mat" },
    MaterialSwitchBehavior.GetTest,
    MaterialSwitchBehavior.SetTest
  ));

return MaterialSwitchBehavior;