local Venuscore = require "venuscore"
local Apolloengine = require "apolloengine"
local SkeletonBehavior = Venuscore.VenusBehavior:extend("SkeletonBehavior"); 

local rootBone   = "Pelvis";
local spineBones = {}
local bonesNames = {};
    
table.insert( spineBones, "Spine1" );
table.insert( spineBones, "Spine2" );
table.insert( spineBones, "Spine3" );

table.insert( bonesNames, "R_Shoulder" );
table.insert( bonesNames, "R_Elbow" );
table.insert( bonesNames, "R_Wrist" );
table.insert( bonesNames, "L_Shoulder" );
table.insert( bonesNames, "L_Elbow" );
table.insert( bonesNames, "L_Wrist" );
table.insert( bonesNames, "R_Hip" );
table.insert( bonesNames, "R_Knee" );
table.insert( bonesNames, "R_Ankle" );
table.insert( bonesNames, "L_Hip" );
table.insert( bonesNames, "L_Knee" );
table.insert( bonesNames, "L_Ankle" );
table.insert( bonesNames, "Neck" );
table.insert( bonesNames, "Head" );

local children = {2,3,0,5,6,0,8,9,0,11,12,0,14,0};
local bodyPair = {{1,2},{3,4},{1,3},{2,4}};

function SkeletonBehavior:new()
    self.Pelvis = nil;
    self.Spine1 = nil;
    self.Spine2 = nil;
    self.Spine3 = nil;

    self.R_Shoulder = nil;
    self.R_Elbow    = nil;
    self.R_Wrist    = nil;
    self.R_Hip      = nil;
    self.R_Knee     = nil;
    self.R_Ankle    = nil;

    self.L_Shoulder = nil;
    self.L_Elbow    = nil;
    self.L_Wrist    = nil;
    self.L_Hip      = nil;
    self.L_Knee     = nil;
    self.L_Ankle    = nil;
    self.Neck       = nil;
    self.Head       = nil;
    
    self.Target = nil;
end

function SkeletonBehavior:Init()
  self.BoneNodes = 
  {
      ["Pelvis"] = self.Pelvis,
      ["Spine1"] = self.Spine1,
      ["Spine2"] = self.Spine2,
      ["Spine3"] = self.Spine3,

      ["R_Shoulder"] = self.R_Shoulder,
      ["R_Elbow"] = self.R_Elbow,
      ["R_Wrist"] = self.R_Wrist,
      ["R_Hip"] = self.R_Hip,
      ["R_Knee"] = self.R_Knee,
      ["R_Ankle"] = self.R_Ankle,

      ["L_Shoulder"] = self.L_Shoulder,
      ["L_Elbow"] = self.L_Elbow,
      ["L_Wrist"] = self.L_Wrist,
      ["L_Hip"] = self.L_Hip,
      ["L_Knee"] = self.L_Knee,
      ["L_Ankle"] = self.L_Ankle,
      ["Neck"] = self.Neck,
      ["Head"] = self.Head
  }
  if self.TargetSkeleton ~= nil then
    local targetScriptCom = self.TargetSkeleton:GetComponent(Apolloengine.Node.CT_SCRIPT);
    if targetScriptCom ~= nil then
      local skelScriptPath = "scrs:behavior/avatar_behavior/skeleton_behavior.lua"
      for sckey, scvalue in pairs(targetScriptCom.Instances) do
        if sckey == skelScriptPath then
          self.targetBehavior = scvalue;
          break;
        end
      end      
    end
  end
  
end

function SkeletonBehavior:GetJointConfig()
  return rootBone,spineBones,bonesNames,children,bodyPair
end

function SkeletonBehavior:GetJoints()
  if self.BoneNodes == nil then
    self:Init();
  end
  return self.BoneNodes;
end

function SkeletonBehavior:GetTargetJoints()
  if self.targetBehavior ~= nil then
    return self.targetBehavior:GetJoints()
  end
  return nil;
end

SkeletonBehavior:MemberRegister(rootBone,
Venuscore.ScriptTypes.ReferenceType(
Apolloengine.Node:RTTI()
)); 

for i=1, #spineBones do
  SkeletonBehavior:MemberRegister(spineBones[i],
    Venuscore.ScriptTypes.ReferenceType(
    Apolloengine.Node:RTTI()
  )); 
end

for i=1, #bonesNames do
  SkeletonBehavior:MemberRegister(bonesNames[i],
    Venuscore.ScriptTypes.ReferenceType(
    Apolloengine.Node:RTTI()
  )); 
end

SkeletonBehavior:MemberRegister("TargetSkeleton",
    Venuscore.ScriptTypes.ReferenceType(
    Apolloengine.Node:RTTI()
));

return SkeletonBehavior;