local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local optimization = require "optimization"
local collisionhandler = require "avatar.retarget.collisionhandler"
local cv = require "computervisionfunction"
local util = require "behavior.avatar_behavior.util"
local skelScriptPath = "scrs:behavior/avatar_behavior/skeleton_behavior.lua"


local SkeCubes = {}

table.insert( SkeCubes, "RARM" );
table.insert( SkeCubes, "RFOREARM" );
table.insert( SkeCubes, "LARM" );
table.insert( SkeCubes, "LFOREARM" );
table.insert( SkeCubes, "RLEG" );
table.insert( SkeCubes, "RFORELEG" );
table.insert( SkeCubes, "LLEG" );
table.insert( SkeCubes, "LFORELEG" );
table.insert( SkeCubes, "NECKANDHEAD" );

local AvatarTest = venuscore.VenusBehavior:extend("AvatarTest"); 

function AvatarTest:new()
    self.RootEstimate = optimization.RootEstimate();
    self.ReprojCorrect = optimization.ReprojCorrect();
    self.ReprojCorrect:SetBoneLengthWeight({0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05,0.05});

    self.ReprojCorrect:SetMinimizeCWeight({0.06,0.0,0.0,0.06,0.0,0.0,0.06,0.0,0.0,0.06,0.0,0.0,0.0,0.0});
    self.ReprojCorrect:SetMinimizeZWeight({1.5,0.03,0.03,1.5,0.03,0.03,1.5,0.03,0.03,1.5,0.03,0.03,0.03,0.03});
    self.ReprojCorrect:SetBonePair({{0,1},{1,2},{3,4},{4,5},{6,7},{7,8},{9,10},{10,11},{12,13},{0,9},{3,6}});
    self.boneoffset = {0,0.3,0,0.3,0,0,0,0,0,0,0};
    self.boneMargin = {{1.8,1.3,1.0},{1.8,1.3,1.0},{1.8,1.3,1.0},{1.8,1.3,1.0},{1.8,1.3,1.0},{1.8,1.3,1.0},{1.8,1.3,1.0},{1.8,1.3,1.0},{2.3,1.3,1.0}};

    self.recogition=nil;
   
    self.parents = {0,1,2,0,4,5,0,7,8,0,10,11,0,13}

    self.RARM = nil;
    self.RFOREARM = nil;
    self.LARM = nil;
    self.LFOREARM = nil;
    self.RLEG = nil;
    self.RFORELEG = nil;
    self.LLEG = nil;
    self.LFORELEG = nil;
    self.NECKANDHEAD = nil;

    self.BODYUPPER = nil;
    self.BODYLOWER = nil;

    self.BodyUpperMargin = mathfunction.vector3(1.5,1.6,1.0);
    self.BodyLowerMargin = mathfunction.vector3(2.0,1.2,1.0);
    self.BoxScale = 10;


    self.camera=nil;

    self.trans = {};

end

function AvatarTest:GetCamera()
    return  self.camera;
end

function AvatarTest:SetCamera(camera)
    self.camera = camera;
end

function AvatarTest:GetRecognitionComponent()
    return  self.recognition;
end

function AvatarTest:SetRecognitionComponent(recognition)
    self.recognition = recognition;
end

function AvatarTest:UpdateCameraParam()
    if  self.camera==nil then
        return;
    end
    
    local resolution = self.camera.CameraResolution;
  
    local cx = 0.5*resolution:x();
    local cy = 0.5*resolution:y();


    local projectionmat = self.camera:GetProject();
    local fx = projectionmat.a11;
    local fy = projectionmat.a22;
    fx = fx * cx;
    fy = fy * cy;

    if math.abs(fx-fy)>0.01 then
        LOG("DIFF FOCUS DISTANCE"..fx.." "..fy);
    end
    
    self.RootEstimate:SetCameraParam(fx,fy,cx,cy);
    self.RootEstimate:SetContinueWeight(0.01);

    self.ReprojCorrect:SetCameraParam(fx,fy,cx,cy);
end

function AvatarTest:GetHumanPose()
    if self.recognition==nil then
        return;
    end
    local results = self.recognition:GetResult();
    if results == nil or
       results[128] == nil or
       results[256] == nil then
        return nil, nil, nil
    end
    
    local pose2d_raw = results[128][1]; -- x1, y1, score1, x2, y2, score2, ...
    local pose3d_raw = results[256][1]; -- x1, y1,     z1, x2, y2,     z2, ...
    local pose2d_ret = {};
    local score_ret = {};
    local pose3d_ret = {};
    for i = 1, 14 do
        pose2d_ret[i] = {pose2d_raw[(i-1)*3+1], pose2d_raw[(i-1)*3+2]};
        score_ret[i] = pose2d_raw[(i-1)*3+3];
        pose3d_ret[i] = {pose3d_raw[(i-1)*3+1], pose3d_raw[(i-1)*3+2], pose3d_raw[(i-1)*3+3]}

        --LOG("2d POSITION IS "..pose2d_ret[i][1].." "..pose2d_ret[i][2]);
        --LOG("3d POSITION IS "..pose3d_ret[i][1].." "..pose3d_ret[i][2].." "..pose3d_ret[i][3]);
    end

    self:UpdateCameraParam();

    if self.lastroot==nil then
        self.lastroot = {0,0,-4.3}
    end

    if self.lastroot[1]>20 or self.lastroot[2]>20 or self.lastroot[3]>20 or self.lastroot[1]<-20 or self.lastroot[2]<-20 or self.lastroot[3]<-20 then
        self.lastroot = {0,0,-4.3};
        self.RootEstimate:SetContinueWeight(0.0);
        self.RootEstimate:SetLastRootPose(mathfunction.vector3(self.lastroot[1],self.lastroot[2],self.lastroot[3]));
    end
    
    if self.first==false or self.first==nil  then
        self.RootEstimate:SetLastRootPose(mathfunction.vector3(self.lastroot[1],self.lastroot[2],self.lastroot[3]));
    end
    
    self.RootEstimate:SetRootPose(mathfunction.vector3(self.lastroot[1],self.lastroot[2],self.lastroot[3]));
    self.RootEstimate:SetPose3D(pose3d_ret);
    self.RootEstimate:SetPose2D(pose2d_ret);
    self.lastroot = self.RootEstimate:Minimize();
    self.lastroot = {0,0,-4.3}
    --LOG("ROOT POSITION IS "..self.lastroot[1].." "..self.lastroot[2].." "..self.lastroot[3]);

    for i = 1, 14 do
        pose3d_ret[i][1] =  pose3d_ret[i][1]+self.lastroot[1];
        pose3d_ret[i][2] =  pose3d_ret[i][2]+self.lastroot[2];
        pose3d_ret[i][3] =  pose3d_ret[i][3]+self.lastroot[3];
    end

    if self.first==false or self.first==nil  then
        self.ReprojCorrect:SetLastPose3D(pose3d_ret);
    end
    self.first = true;
    self.ReprojCorrect:SetPose3D(pose3d_ret);
    self.ReprojCorrect:SetPose2D(pose2d_ret);
    pose3d_ret_tmp = self.ReprojCorrect:Minimize();
--[[
    for i = 1, 14 do
        LOG("3d POSITION IS "..pose3d_ret_tmp[i][1].." "..pose3d_ret_tmp[i][2].." "..pose3d_ret_tmp[i][3]);
    end]]
    pose3d_ret = pose3d_ret_tmp;
    self.ReprojCorrect:SetLastPose3D(pose3d_ret);
    return pose2d_ret, score_ret, pose3d_ret
end


function AvatarTest:_OnAwake()

  
end

function AvatarTest:Lerp(from,to,percent)
    local ret = mathfunction.vector3();
    ret.mx = (to.mx - from.mx)*percent+from.mx;
    ret.my = (to.my - from.my)*percent+from.my;
    ret.mz = (to.mz - from.mz)*percent+from.mz;
    return ret;
end

function AvatarTest:_OnUpdate(def)
    self.trans[1] = self.RARM ;
    self.trans[2] = self.RFOREARM ;
    self.trans[3] = self.LARM ;
    self.trans[4] = self.LFOREARM ;
    self.trans[5] = self.RLEG ;
    self.trans[6] = self.RFORELEG ;
    self.trans[7] = self.LLEG ;
    self.trans[8] = self.LFORELEG ;
    self.trans[9] = self.NECKANDHEAD ;

    local pos2d, scores, pos3d = self:GetHumanPose();
    if pos2d == nil or pos3d == nil then
        return;
    end
    
    local transidx = 1;
    for i =1 , #self.parents do
        if self.parents[i] ~= 0 then
           
            local mypos = mathfunction.vector3((pos3d[i][1]),(pos3d[i][2]),pos3d[i][3]);
            local paridx = self.parents[i]
            local parentpos = mathfunction.vector3((pos3d[paridx][1]),(pos3d[paridx][2]),pos3d[paridx][3]);
            local cubepos = (mypos-parentpos)*(0.5+ self.boneoffset[transidx])+parentpos;

            local dir = parentpos-mypos;
            local length = dir:Length()*(1+ self.boneoffset[transidx]*2);
            local otherscale = length/4;
            dir:NormalizeSelf();
            local rotation = mathfunction.Quaternion();
            rotation:AxisToAxis(mathfunction.vector3(0,0,1),dir);
            
            if self.trans[transidx] ~= nil then
              local margin = self.boneMargin[transidx];
              if margin~=nil then
                otherscale = otherscale*margin[1];
                length = length*margin[3]
              end
              self.trans[transidx]:SetLocalScale(mathfunction.vector3(otherscale*self.BoxScale,otherscale*self.BoxScale,length*self.BoxScale));
              self.trans[transidx]:SetLocalPosition(cubepos);
              self.trans[transidx]:SetLocalRotation(rotation);
              transidx= transidx+1
            end
        end
    end

    if self.BODYUPPER~=nil and  self.BODYLOWER~=nil   then
        local RSPos = mathfunction.vector3( pos3d[1][1],  pos3d[1][2],  pos3d[1][3]);
        local LSPos = mathfunction.vector3( pos3d[4][1],  pos3d[4][2],  pos3d[4][3]);
        local RHPos = mathfunction.vector3( pos3d[7][1],  pos3d[7][2],  pos3d[7][3]);
        local LHPos = mathfunction.vector3( pos3d[10][1], pos3d[10][2], pos3d[10][3]);
        
        local shoulderwidth = (RSPos - LSPos):Length();
        local hipwidth = (RHPos - LHPos):Length();

        local bodyvector = (RSPos+LSPos)/2 - (RHPos+LHPos)/2;
        local bodyheight = bodyvector:Length();
        local shouldervector = LSPos-RSPos;
        local hipvector = LHPos-RHPos;

        local hiprotate      =  util:ConstractRotationFromVector(hipvector:Normalize(),bodyvector:Normalize());
        local shoulderrotate =  util:ConstractRotationFromVector(shouldervector:Normalize(),bodyvector:Normalize());

        local hippos = (RHPos+LHPos)/2;
        local sholderpos = (RSPos+LSPos)/2;
        local modelhippos = self:Lerp(hippos,sholderpos,0.25);
        local modelshoulderpos = self:Lerp(sholderpos,hippos,0.25);

        self.BODYUPPER:SetLocalScale(mathfunction.vector3(shoulderwidth*self.BodyUpperMargin:x()*self.BoxScale,bodyheight/2*self.BodyUpperMargin:y()*self.BoxScale,shoulderwidth/3*self.BodyUpperMargin:z()*self.BoxScale));
        self.BODYUPPER:SetLocalPosition(modelshoulderpos);
        self.BODYUPPER:SetLocalRotation(shoulderrotate:ToQuaternion());

        self.BODYLOWER:SetLocalScale(mathfunction.vector3(hipwidth*self.BodyLowerMargin:x()*self.BoxScale,bodyheight/2*self.BodyLowerMargin:y()*self.BoxScale,hipwidth/3*self.BodyLowerMargin:z()*self.BoxScale));
        self.BODYLOWER:SetLocalPosition(modelhippos);
        self.BODYUPPER:SetLocalRotation(hiprotate:ToQuaternion());
    end
end

for i=1, #SkeCubes do
    AvatarTest:MemberRegister(SkeCubes[i],
    venuscore.ScriptTypes.ReferenceType(
    apolloengine.TransformComponent:RTTI()
  )); 
end

AvatarTest:MemberRegister("BODYUPPER",
venuscore.ScriptTypes.ReferenceType(
apolloengine.TransformComponent:RTTI()
)); 

AvatarTest:MemberRegister("BODYLOWER",
venuscore.ScriptTypes.ReferenceType(
apolloengine.TransformComponent:RTTI()
)); 

AvatarTest:MemberRegister("camera",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.CameraComponent:RTTI(),
    AvatarTest.GetCamera,
    AvatarTest.SetCamera 
)); 


AvatarTest:MemberRegister("recognition",
  venuscore.ScriptTypes.ReferenceType(
    cv.RecognitionComponent:RTTI(),
    AvatarTest.GetRecognitionComponent,
    AvatarTest.SetRecognitionComponent 
)); 

AvatarTest:MemberRegister("BodyUpperMargin");
AvatarTest:MemberRegister("BodyLowerMargin");

return AvatarTest;