local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local optimization = require "optimization"
local collisionhandler = require "avatar.retarget.collisionhandler"
local cv = require "computervisionfunction"
local skeletonnode = require "behavior.avatar_behavior.skeleton_node"
local skelScriptPath = "scrs:behavior/avatar_behavior/skeleton_behavior.lua"

local Avatar = venuscore.VenusBehavior:extend("Avatar"); 

function Avatar:new()
    self.LaplacianRetarget = optimization.LaplacianRetarget();
    self.RootEstimate = optimization.RootEstimate();

    self.skeBehvr = nil;
    self.recogition=nil;
end

function Avatar:GetRecongition()
    if self.recogition==nil then
        self.recogition = self.Node:GetComponent(apolloengine.Node.CT_CV_RECOGNITION);
    end
    if self.recogition == nil then
      return nil, nil, nil;
    end
    local results = self.recogition:GetResult();
    if results == nil or
       results[128] == nil or
       results[256] == nil then
        return nil, nil, nil
    end
    
    local pose2d_raw = results[128][1]; -- x1, y1, score1, x2, y2, score2, ...
    local pose3d_raw = results[256][1]; -- x1, y1,     z1, x2, y2,     z2, ...
    local pose2d_ret = {};
    local score_ret = {};
    local pose3d_ret = {};
    for i = 1, 14 do
        pose2d_ret[i] = {pose2d_raw[(i-1)*3+1], pose2d_raw[(i-1)*3+2]};
        score_ret[i] = pose2d_raw[(i-1)*3+3];
        pose3d_ret[i] = {pose3d_raw[(i-1)*3+1], pose3d_raw[(i-1)*3+2], pose3d_raw[(i-1)*3+3]}
    end
    return pose2d_ret, score_ret, pose3d_ret
end

function Avatar:_InitSkeleton(onIK)
  self.boneNodes = self.skeBehvr:GetJoints();  
  self.skeletonNode = skeletonnode()
  self.skeletonNode:SetBonesRef(self.boneNodes);
  self.skeletonNode:SetPoseEstimateBoneNames(self.skeBehvr:GetJointConfig());
  self.skeletonNode:BindPose();
  self.skeletonNode:InitCollision();
  
  if onIK then
    self.boneNodesPose = self.skeBehvr:GetTargetJoints();
    self.skeletonNodePose = skeletonnode();
    self.skeletonNodePose:SetBonesRef(self.boneNodesPose);
    self.skeletonNodePose:SetPoseEstimateBoneNames(self.skeBehvr:GetJointConfig());
    self.skeletonNodePose:BindPose();
    self.skeletonNodePose:InitCollision();
    self.skeletonNode:SetTarget(self.boneNodesPose);
  end
end

function Avatar:_UpdateSkeleton(pos3d, cameraT, cameraR)
  if self.skeletonNodePose then 
    self.skeletonNodePose:UpdateSkeleton(pos3d,cameraT,cameraR);
  else
    self.skeletonNode:UpdateSkeleton(pos3d,cameraT,cameraR);
    self.skeletonNode:CorrectArmsTwist();
  end
end

function Avatar:_UpdateIK(cameraT,cameraR,scores)
  if self.skeletonNodePose then
    --LOG("_UpdateIK")
    local curtargets,rootRot = self.skeletonNodePose:GetTargets()
    self.skeletonNode:UpdateIK(rootRot,cameraT,cameraR,scores);
  end
end


function Avatar:_GetSkeletonNode()
  if self.skeletonNodePose then
    return self.skeletonNodePose;
  else
    return self.skeletonNode;
  end
end

function Avatar:_OnAwake()

    self._isInit = false;

    local scriptCom = self.Node:GetComponent(apolloengine.Node.CT_SCRIPT);
    if scriptCom ~= nil then
        for sckey, scvalue in pairs(scriptCom.Instances) do
            if sckey == skelScriptPath then
                self.skeBehvr = scvalue;
                break;
            end
        end
    else
        return;
    end
    
    if self.skeBehvr == nil then
      return;
    end
    
    local onIK = true;
    self:_InitSkeleton(onIK);

    collisionhandler:Init(self:_GetSkeletonNode());
    local static_anchors = {7, 10};
    self.LaplacianRetarget:SetupStaticAnchor(static_anchors, 4000.0);
    local bonepair = {{1,2},{2,3},{4,5},{5,6},{7,8},{8,9},{10,11},{11,12}};
    self.LaplacianRetarget:SetBonePair(bonepair,2000.0);
    local links = {  {2,{4,7,10,13,14}},
                    {3,{4,7,10,13,14,6}},
                    {5,{1,7,10,13,14}},
                    {6,{1,7,10,13,14,3}},
                    {8,{1,4,10,11,12}},
                    {9,{1,4,10,11,12}},
                    {11,{1,4,7,8,9}},
                    {12,{1,4,7,8,9}},
                    {13,{1,4,7,10}},
                    {14,{1,4,7,10}},
                    {1,{4,7,10}},
                    {4,{1,7,10}},
                    };
    self.LaplacianRetarget:SetBoneLink(links,20.0);
    self.LaplacianRetarget:SetupFrameLinkData(200);
    local bondIds = collisionhandler:getCollisionBoneId();
    self.LaplacianRetarget:SetupCollisionBone(bondIds, 2000);
    
    self.LaplacianRetarget:SetupCeres(14);
    
    self.RootEstimate:SetCameraParam(23,23,6,12);
    self.RootEstimate:SetContinueWeight(0.003);

  
end

function Avatar:_OnUpdate(def)

    local pos2d, scores, pos3d = self:GetRecongition();
    if pos2d == nil or pos3d == nil then
        return;
    end
    
    LOG("Avatar:_OnUpdate");

    if self.lastroot==nil then
        self.lastroot = {0,0,4}
     end
    
    self.RootEstimate:SetRootPose(mathfunction.vector3(self.lastroot[1],self.lastroot[2],self.lastroot[3]));
    self.RootEstimate:SetPose3D(pos3d);
    self.RootEstimate:SetPose2D(pos2d);
    self.lastroot = self.RootEstimate:Minimize();

    cameraT = mathfunction.vector3(self.lastroot[1],self.lastroot[2],self.lastroot[3]);
    cameraT =  cameraT + mathfunction.vector3(0,0,0);
cameraT = nil;
cameraR = nil;
    self:_UpdateSkeleton(pos3d, cameraT, cameraR)
    local modelpose = self:_GetSkeletonNode():GetCurrentPose()
--[[
    local jac, luacoll = collisionhandler:CaculatePD(pos3d);
    if jac ~= nil and luacoll ~= nil  then
        self.LaplacianRetarget:SetupCollision(jac, luacoll);
    end
]]
    self.LaplacianRetarget:SetupInitPose(pos3d, modelpose);
    self.LaplacianRetarget:CaculateWeightFromLink();
    self.LaplacianRetarget:SetupBoneData();

    local retpose3dlua = {};
    local retpose3d = self.LaplacianRetarget:Minimize();
    for i=1,14 do
        retpose3dlua[i] = {};
        retpose3dlua[i][1] = retpose3d[i][1];
        retpose3dlua[i][2] = retpose3d[i][2];
        retpose3dlua[i][3] = retpose3d[i][3];
    end
    --retpose3dlua[15] = {cameraT:x(),cameraT:y(),cameraT:z()};

    self:_UpdateSkeleton(retpose3dlua,cameraT,cameraR);
    self:_UpdateIK(cameraT,cameraR,scores);
end

return Avatar;