local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local filter = require "avatar.filter.pose_stablizer_soft"
local mathfunction = require "mathfunction"

local AttachBehavior = venuscore.VenusBehavior:extend("AttachBehavior"); 

function AttachBehavior:new()
    self.th = 15    -- degree
    self.k  = 1     -- smoother and more jagged with higher k
    self.filter = filter()
    self.filter:Initialize(self.th, self.k)
    self.Parent = nil
    self.Wing = nil
    self.WingOffset = mathfunction.vector3(0,0,0)
end

function AttachBehavior:_OnAwake()
end

function AttachBehavior:_OnUpdate(def)

    if self.Parent and self.Wing  then
        local parent_local_pos = self.Parent:GetLocalPosition()
        self.Wing:SetLocalPosition(parent_local_pos + self.WingOffset)
        
        local parent_local_quat = self.Parent:GetLocalRotation()
        --[[
        local parent_local_euler = parent_local_quat:ToEulerAngle()
        temp = {{parent_local_euler:x()},{parent_local_euler:y()},{parent_local_euler:z()}}
        temp = self.filter:Update(temp)

        parent_local_quat = mathfunction.Quaternion();
        parent_local_quat:YawPitchRoll(temp[1][1], temp[2][1], temp[3][1]);

        parent_local_quat:NormalizeSelf()]]
        self.Wing:SetLocalRotation(parent_local_quat)
    end
end

function AttachBehavior:GetSmoothThreshold()
    return self.th
end

function AttachBehavior:SetSmoothThreshold(value)
    self.th = value
    self.filter:Reset(self.th, self.k)
    --print("AttachBehavior: reset filter: th: ", self.th, " k: ", self.k)
end

function AttachBehavior:GetSmoothFactor()
    return self.k
end

function AttachBehavior:SetSmoothFactor(value)
    self.k = value
    self.filter:Reset(self.th, self.k)
    --print("AttachBehavior: reset filter: th: ", self.th, " k: ", self.k)
end

function AttachBehavior:GetWingOffset()
    return self.WingOffset
end

function AttachBehavior:SetWingOffset(value)
    self.WingOffset = value
    --print("AttachBehavior: SetWingOffset")
end

AttachBehavior:MemberRegister("Parent",
    venuscore.ScriptTypes.ReferenceType(
    apolloengine.TransformComponent:RTTI()
));

AttachBehavior:MemberRegister("Wing",
    venuscore.ScriptTypes.ReferenceType(
    apolloengine.TransformComponent:RTTI()
));

AttachBehavior:MemberRegister("smooth_threshold",
  venuscore.ScriptTypes.FloatType(
    0.01, 30,
    AttachBehavior.GetSmoothThreshold,
    AttachBehavior.SetSmoothThreshold
));

AttachBehavior:MemberRegister("smooth_factor",
  venuscore.ScriptTypes.FloatType(
    0, 5,
    AttachBehavior.GetSmoothFactor,
    AttachBehavior.SetSmoothFactor
));

AttachBehavior:MemberRegister("WingOffset",
  venuscore.ScriptTypes.FloatArrayType(
      3,
      AttachBehavior.GetWingOffset,
      AttachBehavior.SetWingOffset
));

return AttachBehavior;