local venusjson = require "venusjson"
local venuscore = require "venuscore"
local object = require "classic"
--local torch = require "torch"
local mathfunction = require "mathfunction"
local pnpestimates = require "pnpestimates"

local CameraCorrection = {}

--[[
1.LeftShoulder
2.RightShoulder
3.LeftHip
4.RightHip
]]--


function CameraCorrection:Initialize(focallength, cx, cy)
  self.focallength = focallength
  self.cx = cx
  self.cy = cy
  --[[self.viewmat = torch.Tensor(3,3):fill(0);
  self.viewmat[1][1] = self.focallength;
  self.viewmat[2][2] = self.focallength;
  self.viewmat[3][1] = self.cx;
  self.viewmat[3][2] = self.cy;
  self.viewmat[3][3] = 1;]]--
  
  self.fullpnp = pnpestimates.EPnPShell();
  self.fullpnp:SetIntrinsic(focallength, focallength, cx, cy);
end

function CameraCorrection:GetTorsoJoints(pos2d, pos3d)
  local torso2d = {}
  local torso3d = {}
  
  torso2d[1] = pos2d[4]
  torso2d[2] = pos2d[1]
  torso2d[3] = pos2d[10]
  torso2d[4] = pos2d[7]
  
  torso3d[1] = pos3d[4]
  torso3d[2] = pos3d[1]
  torso3d[3] = pos3d[10]
  torso3d[4] = pos3d[7]
  
return torso2d, torso3d;
end


function CameraCorrection:Correct(pos2d, pos3d)

  local vec3array = mathfunction.vector3array();
  for i=1,14 do
    vec3array:PushBack(mathfunction.vector3(pos3d[i][1], pos3d[i][2], pos3d[i][3]));
  end
  self.fullpnp:SetModelPoints(vec3array);
  

  self.screenpos = mathfunction.vector2array();
  self.screenpos:Resize(14);
  local vec2 = mathfunction.vector2();
  for i=1,14 do
    vec2:Set(pos2d[i][1] , pos2d[i][2]);
    self.screenpos:Set(i, vec2);
  end

  self.fullpnp:Estimates(self.screenpos);  
  local res = {
      position = self.fullpnp:GetTransform();
      rotation = self.fullpnp:GetRotation();
    }


  return res.position, res.rotation;
end

return CameraCorrection;