local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local apolloDefine = require "apolloutility.defiend"

local collisionhandler = {}

function collisionhandler:Init(skenode)
  self.PartList =  {"Bip001 Head", "Bip001 R Forearm", "Bip001 L Forearm", 
  "Bip001 L Calf", "Bip001 R Calf", "Bip001 Spine1"};

  self.PartList = {}
  for i=1,#skenode.collisionshapenames do
    self.PartList[i] = skenode.collisionshapenames[i];
  end


  self.MassList = {0,1,1,1,1,0};
  self.skenode = skenode;
  
  self.ResultIdx = {[self.PartList[2] ] = 1, 
                    [self.PartList[3] ] = 2, 
                    [self.PartList[4] ] = 3, 
                    [self.PartList[5] ] = 4}
                  
  self.JDelta = 0.001;
end

function collisionhandler:getCollisionBoneId()
    local boneIds = {};
    for name, _ in pairs(self.ResultIdx) do
      local boneId, boneId2 = self:GetIdxInBone(name);
      local boneIdPair = {}
      table.insert( boneIdPair, boneId );
      table.insert( boneIdPair, boneId2 );
      table.insert(boneIds, boneIdPair); 
    end
    return boneIds;
end

function collisionhandler:tbl_copy(orig)
    local orig_type = type(orig)
    local copy
    if orig_type == "table" then
        copy = {}
        for orig_key, orig_value in next, orig, nil do
            copy[self:tbl_copy(orig_key)] = self:tbl_copy(orig_value)
        end
    else -- number, string, boolean, etc
        copy = orig
    end
    return copy
end

function collisionhandler:mat43minus(left,right)
  local ret = {}
  for i=1,4 do
    ret[i] = {}
    for j=1,3 do
      ret[i][j] = left[i][j]-right[i][j];
    end
  end
  return ret;
end

function collisionhandler:CaculatePD( basepose)
  local Jacobian = {};
  local jac = {};
  --apolloengine.IPhysicSystem:UpdateCollision(0.01,10,1.0/60.0);
  local scene = apolloengine.SceneManager:GetNativeScene(apolloDefine.default_scene_name);
  local physicsworld = scene:GetPhysicWorld();
  physicsworld:UpdateCollision(0.01,10,1.0/60.0);
  
  local collisionInfo = physicsworld:GetPhysicsCollisionInfo();
  local basecollision,collisionIdx = self:GetCollisionResult(collisionInfo);
  local basemodelpose =  basepose;
  local hascollision = false;
  for index,_ in pairs(collisionIdx) do
    hascollision = true;
    local boneDer = {}
    table.insert( boneDer,  index);
    for i=1,3 do 
      local offsetmodepose = self:tbl_copy(basemodelpose);
      offsetmodepose[index][i] = offsetmodepose[index][i]+self.JDelta;
      self.skenode:UpdateSkeleton(offsetmodepose);
      physicsworld:UpdateCollision(0.01,10,1.0/60.0);
      local collisionInfo = physicsworld:GetPhysicsCollisionInfo();
      local offsetcollision,_ = self:GetCollisionResult(collisionInfo);
      local deltacollision = self:mat43minus(offsetcollision,basecollision);
     
      local eachDer = {}
      for j = 1,12 do
         eachDer[j] = deltacollision[math.floor((j-1)/3)+1][(j-1)%3+1]/self.JDelta;
      end
      
      table.insert( boneDer, eachDer );
    end
    table.insert( jac, boneDer );
  end
  if hascollision then
    ERROR("hascollision");
    return Jacobian,basecollision, jac, basecollision;
  else
    return
  end
end



function collisionhandler:GetCollisionResult(collisionInfo)

  local result = {};

  for i=1, 4 do
    result[i] = {0,0,0};
  end

  --local result = torch.Tensor(4,3):fill(0);
  local collisionIdx = {};
  for i = 1,#collisionInfo do
    local bid = collisionInfo[i]["objBId"];
    local aid = collisionInfo[i]["objAId"];
    local bname = self.skenode:GetNameByID(bid);
    local aname = self.skenode:GetNameByID(aid);
    LOG(aname.." col "..bname)
    local aresultidx = self.ResultIdx[aname];
    local bresultidx = self.ResultIdx[bname];
    local aboneidx,aboneidx2 = self:GetIdxInBone(aname);
    local bboneidx,bboneidx2 = self:GetIdxInBone(bname);
    
    local pointList = collisionInfo[i]["collisionPointList"]
    local distance = 0;
    local normal = nil;
    for j=1,#pointList do
      if pointList[j].distance<distance then
        distance = pointList[j].distance;
        normal = pointList[j].worldNormalOnB;
      end
    end
    
    local adepths = self:GetDepthS(result[aresultidx]);
    local bdepths = self:GetDepthS(result[bresultidx]);
    if adepths<distance*distance and aresultidx~=nil then
      result[aresultidx][1] = -distance*normal[1];
      result[aresultidx][2] = -distance*normal[2];
      result[aresultidx][3] = -distance*normal[3];
      collisionIdx[aboneidx]=1;
      collisionIdx[aboneidx2]=1;
    end
    
    if bdepths<distance*distance and bresultidx~=nil then
      result[bresultidx][1] = distance*normal[1];
      result[bresultidx][2] = distance*normal[2];
      result[bresultidx][3] = distance*normal[3];
      collisionIdx[bboneidx]=1;
      collisionIdx[bboneidx2]=1;
    end 
  end

  return result,collisionIdx;
end

function collisionhandler:GetDepthS(vec3)
  if vec3==nil then
    return 0
  end
  local depthsquare = vec3[1]*vec3[1]+vec3[2]*vec3[2]+vec3[3]*vec3[3];
  return depthsquare;
end


function collisionhandler:GetIdxInBone(name)
  local idx = 0;
  for i=1,#self.skenode.bonenamemap do 
    if name == self.skenode.bonenamemap[i] then
      idx = i;
      break;
    end
  end
  if idx == 0 then
    --LOG(name.."   not found!")
  end
  local idx2 = 0;
  if idx ==5 then
    idx2 = 6;
  end
  if idx ==6 then
    idx2 = 5;
  end
  if idx ==2 then
    idx2 = 3;
  end
  if idx ==3 then
    idx2 = 2;
  end
  if idx == 8 then
    idx2 = 9;
  end
  if idx == 9 then
    idx2 = 8;
  end
  if idx == 11 then
    idx2 = 12;
  end
  if idx == 12 then
    idx2 = 11;
  end
  return idx,idx2;
end

function collisionhandler:GetIdx(name)
  local idx = 0;
  for i=1,#self.PartList do
    if self.PartList[i] == name then
      idx = i;
      break;
    end
  end
  return idx;
end

function collisionhandler:GetMass(name)
  local idx = self:GetIdx(name);
  if idx ~=0 then
    return  self.MassList[idx];
  end
end


return collisionhandler;