local b3 = require 'behavior3.b3';
require 'behavior3.core.Decorator'

local particlescope = b3.Class("ParticleScope", b3.Decorator)

function particlescope:ctor(properties, target)
  b3.Decorator.ctor(self)
	self.name = "ParticleScope"
  self.position = string.tovector(properties.position);
  self.loopcnt = properties.preloopcount;
  self.paths = {};
  for k,v in pairs(properties) do
    if "position" ~= k and "preloopcount" ~= k then
      table.insert(self.paths, v);
    end    
  end  
end


--新增的这种初始化接口，需要解决一个问题，同一个节点会调用多次初始化，
--那么被调用多次产生的多个数据如何储存的问题，而如何解决这个问题
--目前尽量不保存本地数据，通过将自身id传递给target取出对应数据来实现
function particlescope:init(tick)
  local board = tick.blackboard;
  local targetscope = board:get("targetscope");  
  
  local particles = targetscope:LoadParticles(self.paths, self.id);
  for _,p in ipairs(particles) do
    p:SetLocalPosition(self.position);
    for i=1, self.loopcnt do
      p:Update(0.033);
    end
  end
  local oldscope = board:get("particlescope");
  board:set("particlescope", particles);
  self.child:init(tick);
  board:set("particlescope", oldscope);
end

function particlescope:tick(tick)
	if not self.child then
		return b3.ERROR
	end
  local board = tick.blackboard;
  local targetscope = board:get("targetscope");
  
  local particles = targetscope:GetParticles(self.id);  
  local oldscope = board:get("particlescope");
  board:set("particlescope", particles);
  local status = self.child:_execute(tick);
  board:set("particlescope", oldscope);
	return status;
end

return particlescope;