local b3 = require 'behavior3.b3';
require 'behavior3.core.Action'

local timeslowdown = b3.Class("TimeSlowdown", b3.Action)

function timeslowdown:ctor(properties)
	b3.Action.ctor(self)	
	self.name = "TimeSlowdown"
  self.timespeed = properties.speed;
end


function timeslowdown:tick(tick)
  local board = tick.blackboard;
  local timespan = board:get("timespan");
  local timemul = board:get("timemultiper");
  timemul = timemul or 1;
  timemul = timemul - self.timespeed * timespan;
  timemul = timemul > 0 and timemul or 0;
  board:set("timespan", timespan * timemul);
  board:set("timemultiper", timemul);
  return b3.SUCCESS;
end

return timeslowdown;