local meshnode = require "apolloutility.apollonode.meshnode"
local skeletonnode = require "apolloutility.apollonode.skeletonnode"
local trasnnode = require "apolloutility.apollonode.trasnnode"
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venusjson = require "venusjson"
local Object = require "classic"

local cjson = require "cjson"

local TextureSlot = 
{
  TS_DIFFUSE = 0,
  TS_NORMAL = 1
};

local MaterialType = 
{
  MT_OPAQUE = 0,
  MT_TRANSPARENT = 1
};

--模型节点
local ModelNode = trasnnode:extend();

local AS_ERROR = apolloengine.IComponent.AS_ERROR;
local AS_PLAYING = apolloengine.IComponent.AS_PLAYING;
local AS_DONE = apolloengine.IComponent.AS_DONE;
local AS_STOP = apolloengine.IComponent.AS_STOP;

function ModelNode:new()
  ModelNode.super.new(self);
  self.node:SetName("ModelNode")
  self.isSkined = false;
  self.isShow = true;
  --self.isReset = true;
  self.nodes = {};
  self.keepsource = false;
  self.bindbox = self.node:CreateComponent(apolloengine.Node.CT_BIND);
  self.skincoms = {}
  self.sequence = 0;
end



function ModelNode:CreateResource(rootpath, defmaterial, memoryuseage,retarget_rootpath)
  memoryuseage = memoryuseage or apolloengine.VertexBufferEntity.MU_STATIC;
  local res = true;
  local configFullPath = rootpath .. "/" .. "config.json";
  local modelconfig = venusjson.LaodJsonFile(configFullPath);
  if modelconfig.version==2 then
    return self:CreateResource2(rootpath, defmaterial, memoryuseage,retarget_rootpath);
  end
  if modelconfig.version==3 then
    return self:CreateResource3(rootpath, defmaterial, memoryuseage,retarget_rootpath);    
  end
  local bind = mathfunction.Aabbox3d();
  for meshesKey, meshesValue in pairs(modelconfig) do
    for meshKey,meshValue in pairs(meshesValue) do
      local meshpath = meshValue.name;
      local meshFullPath = rootpath .. "/" .. meshpath;
      local diffusetex;
      local normaltex;
      local pbrtex;
      local diffuseFullPath;
      local normalFullPath;
      local materialtype;
      local pbrtextureFullPath;
      local ispbr = false;

      local material = meshValue.material;
      if material then
        materialtype = material.alphamode;
        if material.normaltexture then
          normaltex = material.normaltexture.path;
        end

        if material.pbrmetallicroughness.basecolortexture then
          diffusetex = material.pbrmetallicroughness.basecolortexture.path;
        end  
      end

      if diffusetex then
        diffuseFullPath = rootpath .. "/" .. diffusetex;
      end
      if normaltex then
        normalFullPath = rootpath .. "/" .. normaltex;
      end


      local materialFullPath = defmaterial or defiend.model_simple_material_path;
      if material.pbrmetallicroughness.metallicroughnesstexture ~= nil then  --pbr材质
        ispbr = true;
        materialFullPath = defiend.model_pbr_material_path;
        pbrtex = material.pbrmetallicroughness.metallicroughnesstexture.path;
        pbrtextureFullPath = rootpath .. "/" .. pbrtex;
      end

      local skeletonPath = meshValue.skeleton;
      local maxBone = meshValue.maxbonecnt;
      local animationPath = meshValue.animation;
      local frameCount = meshValue.framecount;
      local isHasScale = meshValue.hasscale;

      local transList = meshValue.translation;
      local rotList = meshValue.rotation;
      local scaleList = meshValue.scale;

      local bindmin = meshValue.boundingbox.min;
      local bindmax = meshValue.boundingbox.max;

      local bindboxV = mathfunction.Aabbox3d(
        mathfunction.vector3(bindmin[1],bindmin[2],bindmin[3]),
        mathfunction.vector3(bindmax[1],bindmax[2],bindmax[3]));

      --local transV = mathfunction.vector3(transList[1],transList[2],transList[3]);
      --local rotationV = mathfunction.Quaternion(rotList[1],rotList[2],rotList[3],rotList[4]);
      --local scaleV = mathfunction.vector3(scaleList[1],scaleList[2],scaleList[3]);

      if animationPath then

        local suffix = materialtype == MaterialType.MT_TRANSPARENT and "_t" or "";
        --local materialpath = defiend.model_simple_material_path;
		local materialpath = ispbr
            and (isHasScale and defiend.model_pbr_matrix_material_path or defiend.model_pbr_dual_material_path)
            or (isHasScale and defiend.model_matrix_material_path or defiend.model_dual_material_path) 
        materialFullPath = string.format(materialpath, maxBone,suffix);

        --materialFullPath = defiend.model_simple_material_path; --用简单材质测试阴影

        self.isSkined = true;
        animationPath = rootpath .. "/" .. animationPath;
        skeletonPath = rootpath .. "/" .. skeletonPath;
      end

      local node = meshnode();
      node:SetSequence(self.sequence);

      if self.keepsource then
        node:SetKeepSource(self.keepsource);
      end

      if diffuseFullPath then
        node:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,diffuseFullPath);
      end

      if normalFullPath then
        node:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_BUMP,normalFullPath);
      end

      if material.pbrmetallicroughness.metallicroughnesstexture ~= nil then  --pbr材质
        node:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_AMR,pbrtextureFullPath);
        node:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_NORMAL,normalFullPath);
        node:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_ALDEBO,diffuseFullPath);
      end


      self.nodes[meshpath] = node;
      res = res and node:CreateResource(meshFullPath,materialFullPath,skeletonPath,animationPath,frameCount, isHasScale and 0 or 1, memoryuseage);
      node:SetBindBox(bindboxV);
      if maxBone ~= nil and res then
        local skinCom = node:CreateComponent(apolloengine.Node.CT_SKIN);

        skinCom:SetHasScale(isHasScale);
        skinCom:SetSkeletonComponent(node.skeleton);
        table.insert(self.skincoms,skinCom);
      end
      bind:Contains(bindboxV);
      self:AttachNode(node);
    end
  end
  self.bindbox:SetBindBox(bind);
  return res;
end

function ModelNode:CreateResource2(rootpath, defmaterial, memoryuseage,retarget_rootpath)
  local res = true;
  memoryuseage = memoryuseage or apolloengine.VertexBufferEntity.MU_STATIC;
  local configFullPath = rootpath .. "/" .. "config.json";
  local modelconfig = venusjson.LaodJsonFile(configFullPath);
  if modelconfig.version ~=2 then
    return false; 
  end
  self.version = 2;
  local bind = mathfunction.Aabbox3d();

  local hasAnim = false;
  local isHasScale = false;

  if modelconfig.skeleton~=nil and modelconfig.skeleton.name~=""  then
    local skeletonPath = modelconfig.skeleton.name;
    skeletonPath = rootpath .. "/" .. skeletonPath;

    local animInfos =  modelconfig.skeleton.animation;
    if animInfos~=nil then
      animInfos.name = rootpath .. "/" .. animInfos.name;
    end
   
    local skenode = skeletonnode();
    
    if retarget_rootpath then
      local retarget_configFullPath = retarget_rootpath .. "/" .. "config.json";
      local retarget_modelconfig = venusjson.LaodJsonFile(retarget_configFullPath);
      if modelconfig.version == 2 then 
         local retarget_SkeletonPath = retarget_modelconfig.skeleton.name;
         retarget_SkeletonPath = retarget_rootpath .. "/" .. retarget_SkeletonPath;
         
         local retarget_animInfos = retarget_modelconfig.skeleton.animation;
         retarget_animInfos.name = retarget_rootpath .. "/" .. retarget_animInfos.name;
         skenode:SetRetargetSkeletonAndAnims(skeletonPath,animInfos,retarget_SkeletonPath,retarget_animInfos);
      end
    else
       skenode:SetSkeletonAndAnims(skeletonPath,animInfos);
    end
    
    
    self:AttachNode(skenode);
    self.skeletonNode = skenode;
   
    if animInfos~=nil then
      isHasScale = animInfos.hasscale;
      hasAnim = true;
    else
      isHasScale = true;
    end
  end
  local outlineconfig = nil;
  for meshKey,meshValue in pairs(modelconfig.meshes) do
    local meshpath = meshValue.name;
    local meshFullPath = rootpath .. "/" .. meshpath;
    local diffusetex;
    local normaltex;
    local pbrtex;
    local diffuseFullPath;
    local normalFullPath;
    local materialtype;
    local pbrtextureFullPath;
    local ispbr = false;
    local reflectiontex;
    local reflectionfullPath;
    

    outlineconfig = meshValue.outline and meshValue.outline or modelconfig.outline;

    local material = meshValue.material;
    if material then
      materialtype = material.alphamode;
      if material.normaltexture then
        normaltex = material.normaltexture.path;
      end
      
      if material.pbrmetallicroughness.basecolortexture then
        diffusetex = material.pbrmetallicroughness.basecolortexture.path;
      end

	  if material.reflectiontexture then
          reflectiontex = material.reflectiontexture.path;
      end
    end
    
    if diffusetex then
      diffuseFullPath = rootpath .. "/" .. diffusetex;
    end
    if normaltex then
      normalFullPath = rootpath .. "/" .. normaltex;
    end
	if reflectiontex then
        reflectionfullPath = rootpath .. "/" .. reflectiontex; 
    end

    local materialFullPath = defmaterial or defiend.model_simple_material_path;
    if material.pbrmetallicroughness.metallicroughnesstexture ~= nil then  --pbr材质
      ispbr = true;
      materialFullPath = defiend.model_pbr_material_path;
      pbrtex = material.pbrmetallicroughness.metallicroughnesstexture.path;
      pbrtextureFullPath = rootpath .. "/" .. pbrtex;
    end

    
    local maxBone = meshValue.maxbonecnt;

    local transList = meshValue.translation;
    local rotList = meshValue.rotation;
    local scaleList = meshValue.scale;
    
    local bindmin = meshValue.boundingbox.min;
    local bindmax = meshValue.boundingbox.max;
    
    local bindboxV = mathfunction.Aabbox3d(
      mathfunction.vector3(bindmin[1],bindmin[2],bindmin[3]),
      mathfunction.vector3(bindmax[1],bindmax[2],bindmax[3]));
    
    if modelconfig.skeleton~=nil and maxBone~=nil then
      local suffix = materialtype == MaterialType.MT_TRANSPARENT and "_t" or "";
      local materialpath = 
        ispbr
          and (isHasScale and defiend.model_pbr_matrix_material_path or defiend.model_pbr_dual_material_path)
          or (isHasScale and defiend.model_matrix_material_path or defiend.model_dual_material_path)
      materialFullPath = string.format(materialpath, maxBone,suffix);
    
      self.isSkined = true;
    end

    local node = meshnode();
    node:SetSequence(self.sequence);

    if self.keepsource then
      node:SetKeepSource(self.keepsource);
    end
    
    if diffuseFullPath then
      node:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,diffuseFullPath);
    end 
  
    if normalFullPath then
      node:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_BUMP,normalFullPath);
    end
  local UNIFORM_REFFACTOR;
	if reflectionfullPath then 
		materialFullPath = defiend.model_reflection_path;
     UNIFORM_REFFACTOR = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_REFFACTOR");
      node:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_REFLECTION,reflectionfullPath,apolloengine.TextureEntity.TW_MIRRORED_REPEAT);
    end
    
    if material.pbrmetallicroughness.metallicroughnesstexture ~= nil then  --pbr材质
      node:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_AMR,pbrtextureFullPath);
      node:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_NORMAL,normalFullPath);
      node:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_ALDEBO,diffuseFullPath);
    end

    self.nodes[meshpath] = node;
    
    --materialFullPath = defiend.model_simple_material_path; --用简单材质测试阴影
    res = res and node:CreateResource(meshFullPath,materialFullPath,nil,nil,nil, nil, memoryuseage,outlineconfig);
    if reflectionfullPath then

      node:SetParameter(UNIFORM_REFFACTOR,mathfunction.vector1(1));
    end
    
    --if materialtype == 1 then
      --node:SetShadowCaster(false);
    --end

    --node:SetLocalPosition(transV);
    --node:SetLocalRotation(rotationV);
    --node:SetLocalScale(scaleV);
    node:SetBindBox(bindboxV);
    bind:Contains(bindboxV);

    if(maxBone~=nil) and self.skeletonNode~=nil then
      local skinCom = node:CreateComponent(apolloengine.Node.CT_SKIN);

      skinCom:SetHasScale(isHasScale);
      skinCom:SetSkeletonComponent(self.skeletonNode.skeleton);
      table.insert(self.skincoms,skinCom);
    end
   

    self:AttachNode(node);
  end

  self.bindbox:SetBindBox(bind);
  return res;
end

function ModelNode:CreateResource3(rootpath, defmaterial, memoryuseage,retarget_rootpath)
  local res = true;
  memoryuseage = memoryuseage or apolloengine.VertexBufferEntity.MU_STATIC;
  local configFullPath = rootpath .. "/" .. "config.json";
  local modelconfig = venusjson.LaodJsonFile(configFullPath);
  if modelconfig.version ~=3 then
    return; 
  end
  self.version = 3;
  local bind = mathfunction.Aabbox3d();

  local hasAnim = false;
  local isHasScale = false;

  if modelconfig.skeleton~=nil then
    local skeletonPath = modelconfig.skeleton.name;
    skeletonPath = rootpath .. "/" .. skeletonPath;
    local animInfos 
	local originalName
	if modelconfig.skeleton.animation~=nil then
	  animInfos =  modelconfig.skeleton.animation; 
	  originalName = modelconfig.skeleton.originalani.original
	end
  
    if animInfos~=nil then
	    local animationCount = table.getn(animInfos);
	    if originalName == "" then
	      originalName = animInfos.name
	    end
	    for i = 1, animationCount, 1 do
        animInfos[i].name = rootpath .. "/" .. animInfos[i].name;
	    end
	    isHasScale =  modelconfig.skeleton.scale.hasscale;
      hasAnim = true;
    else
      isHasScale = true;
    end
    local skenode = skeletonnode();
    
    if retarget_rootpath then
      local retarget_configFullPath = retarget_rootpath .. "/" .. "config.json";
      local retarget_modelconfig = venusjson.LaodJsonFile(retarget_configFullPath);
      if modelconfig.version == 3 then 
         local retarget_SkeletonPath = retarget_modelconfig.skeleton.name;
         retarget_SkeletonPath = retarget_rootpath .. "/" .. retarget_SkeletonPath;
         
         local retarget_animInfos = retarget_modelconfig.skeleton.animation;
		 local animationCount = table.getn(retarget_animInfos);
		 retarget_animInfos.name = retarget_rootpath .. "/" .. retarget_animInfos.name;

         skenode:SetRetargetSkeletonAndAnims(skeletonPath,animInfos,retarget_SkeletonPath,retarget_animInfos,isHasScale);
      end
    else
       skenode:SetSkeletonAndAnims2(skeletonPath,animInfos,isHasScale, originalName);
    end     
    self:AttachNode(skenode);
    self.skeletonNode = skenode;
  end

  local outlineconfig = nil;
  for meshKey,meshValue in pairs(modelconfig.meshes) do
    local meshpath = meshValue.name;
    local meshFullPath = rootpath .. "/" .. meshpath;
    local diffusetex;
    local normaltex;
    local pbrtex;
    local diffuseFullPath;
    local normalFullPath;
    local materialtype;
    local pbrtextureFullPath;
    local ispbr = false;
 
    local reflectiontex;
    local reflectionfullPath;
 
    outlineconfig = meshValue.outline and meshValue.outline or modelconfig.outline;
    LOG("CREATE RESOURCE 3")
    if modelconfig.outline~= nil then
      LOG(modelconfig.outline.material);
    end
 
    
    local material = meshValue.material;
    if material then
      materialtype = material.alphamode;
      if material.normaltexture then
        normaltex = material.normaltexture.path;
      end
      
      if material.pbrmetallicroughness.basecolortexture then
        diffusetex = material.pbrmetallicroughness.basecolortexture.path;
      end

	  if material.reflectiontexture then
          reflectiontex = material.reflectiontexture.path;
      end
    end
    
    if diffusetex then
      diffuseFullPath = rootpath .. "/" .. diffusetex;
    end
    if normaltex then
      normalFullPath = rootpath .. "/" .. normaltex;
    end
	if reflectiontex then
        reflectionfullPath = rootpath .. "/" .. reflectiontex; 
    end

    local materialFullPath = defmaterial or defiend.model_simple_material_path;
    if material.pbrmetallicroughness.metallicroughnesstexture ~= nil then  --pbr材质
      ispbr = true;
      materialFullPath = defiend.model_pbr_material_path;
      pbrtex = material.pbrmetallicroughness.metallicroughnesstexture.path;
      pbrtextureFullPath = rootpath .. "/" .. pbrtex;
    end

    
    local maxBone = meshValue.maxbonecnt;

    local transList = meshValue.translation;
    local rotList = meshValue.rotation;
    local scaleList = meshValue.scale;
    
    local bindmin = meshValue.boundingbox.min;
    local bindmax = meshValue.boundingbox.max;
    
    local bindboxV = mathfunction.Aabbox3d(
      mathfunction.vector3(bindmin[1],bindmin[2],bindmin[3]),
      mathfunction.vector3(bindmax[1],bindmax[2],bindmax[3]));
    
    if modelconfig.skeleton~=nil and maxBone~=nil then
      local suffix = materialtype == MaterialType.MT_TRANSPARENT and "_t" or "";
      local materialpath = 
        ispbr
          and (isHasScale and defiend.model_pbr_matrix_material_path or defiend.model_pbr_dual_material_path)
          or (isHasScale and defiend.model_matrix_material_path or defiend.model_dual_material_path)
      materialFullPath = string.format(materialpath, maxBone,suffix);
    
      self.isSkined = true;
    end

    local modelnode = meshnode();
    modelnode:SetSequence(self.sequence);
    if self.keepsource then
      modelnode:SetKeepSource(self.keepsource);
    end
    
    if diffuseFullPath then 
      modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,diffuseFullPath);
    end 
  
    if normalFullPath then
      modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_BUMP,normalFullPath);
    end
  local UNIFORM_REFFACTOR ;
	if reflectionfullPath then 
		materialFullPath = defiend.model_reflection_path;
        UNIFORM_REFFACTOR = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNIFORM_REFFACTOR");
        modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_REFLECTION,reflectionfullPath,apolloengine.TextureEntity.TW_MIRRORED_REPEAT);
    end
    
    if material.pbrmetallicroughness.metallicroughnesstexture ~= nil then  --pbr材质
      modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_AMR,pbrtextureFullPath);
      modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_NORMAL,normalFullPath);
      modelnode:PushTextureMetadata(apolloengine.ShaderEntity.TEXTURE_ALDEBO,diffuseFullPath);
    end
  
    self.nodes[meshpath] = modelnode;
    res = res and modelnode:CreateResource(meshFullPath,materialFullPath,nil,nil,nil, nil, memoryuseage,outlineconfig);
    if reflectionfullPath then 
      
        modelnode:SetParameter(UNIFORM_REFFACTOR,mathfunction.vector1(1));
    end
    --modelnode:SetLocalPosition(transV);
    --modelnode:SetLocalRotation(rotationV);
    --modelnode:SetLocalScale(scaleV);
    modelnode:SetBindBox(bindboxV);
    bind:Contains(bindboxV);
    --if materialtype == 1 then
      --modelnode:SetShadowCaster(false);
    --end
    if(maxBone~=nil) then
      local skinCom = modelnode:CreateComponent(apolloengine.Node.CT_SKIN);

      skinCom:SetHasScale(isHasScale);
      skinCom:SetSkeletonComponent(self.skeletonNode.skeleton);
      table.insert(self.skincoms,skinCom);
    end

    self:AttachNode(modelnode);
  end

  self.bindbox:SetBindBox(bind);
  return res;
end


function ModelNode:GetSkinNode()
  return self.skeletonNode;
end


function ModelNode:AddRetarget(modelTarget)
  self.skeletonNode:AddRetarget(modelTarget:GetSkinNode());
end


function ModelNode:UpdateAnimation(def)
  local res = true;
  if (self.version == 2 or self.version == 3) and self.skeletonNode ~= nil then
    res = self.skeletonNode:UpdateAnimation(def);
    return res;
  end

  local animError = false;
  local animPlaying = false;
  local animDone = false;
  local animStop = false;
  if self.isSkined then
    for key,value in pairs(self.nodes) do
      local animStatus = value:UpdateAnimation(def);
      if animStatus == AS_ERROR then
        animError = true
      elseif animStatus == AS_PLAYING then
        animPlaying = true
      elseif animStatus == AS_DONE then
        animDone = true
      elseif animStatus == AS_STOP then
        animStop = true
      end
    end
  end
  if animError then
    return AS_ERROR
  elseif animPlaying then
    return AS_PLAYING
  elseif animDone and not animStop then
    return AS_DONE
  elseif not animDone and animStop then
    return AS_STOP
  else
    return AS_STOP
  end
end

function ModelNode:SetLoop(loop)
  if self.isSkined then
    if (self.version == 2 or self.version == 3) and self.skeletonNode ~= nil then
      self.skeletonNode:SetLoop(loop);
      return;
    end

    for key,value in pairs(self.nodes) do
      value:SetLoop(loop);
    end
  end
end

function ModelNode:Play()
  if self.isSkined then
    --self.isReset = false;

    if (self.version == 2 or self.version == 3) and self.skeletonNode ~= nil then
      self.skeletonNode:Play();
      return;
    end

    for key,value in pairs(self.nodes) do
      value:Play();
    end
  end
end

function ModelNode:Stop()
  if self.isSkined then
    if (self.version == 2 or self.version == 3) and self.skeletonNode ~= nil then
      self.skeletonNode:Stop();
      return;
    end

    for key,value in pairs(self.nodes) do
      value:Stop();
    end
  end
end

function ModelNode:Reset(frame)
  if self.isSkined then --and not self.isReset then
    --self.isReset = true;
    if (self.version == 2 or self.version == 3) and self.skeletonNode ~= nil then
      self.skeletonNode:Reset(frame);
      return;
    end

    for key,value in pairs(self.nodes) do
      value:Reset(frame);
    end
  end
end

function ModelNode:SetAnimationInterval(from,to)
  if self.isSkined then
    --self.isReset = false;
    if (self.version == 2 or self.version == 3) and self.skeletonNode ~= nil then
      self.skeletonNode:SetAnimationInterval(from,to);
      return;
    end

    for key,value in pairs(self.nodes) do
      value:SetAnimationInterval(from,to);
    end
  end
end

function ModelNode:GetFrameCount()
  local count = 0;
  if self.isSkined then
    if (self.version == 2 or self.version == 3) and self.skeletonNode ~= nil then
      return self.skeletonNode.framecount;
    end

    for key,value in pairs(self.nodes) do
      count = math.max(count, value:GetFrameCount());
    end
  end
  return count;
end

function ModelNode:SetParameter(slot, value)
  for key,value in pairs(self.nodes) do
    value:SetParameter(slot, value);
  end
end

function ModelNode:SetShow(isshow)
  if self.isShow ~= isshow then
    self.isShow = isshow;
    for key,value in pairs(self.nodes) do
      value:SetShow(isshow);
    end
  end  
end

--控制是否投射阴影
function ModelNode:SetShadowCaster(iscaster)
  if self.isCaster ~= iscaster then
    self.isCaster = iscaster;
    for key,value in pairs(self.nodes) do
      value:SetShadowCaster(iscaster);
    end
  end
end

function ModelNode:SetBindBox(aabb)
  self.bindbox:SetBindBox(aabb);
end

function ModelNode:GetBindBox()
  return self.bindbox:GetBindBox();
end

--设置摄像机所属的队列
function ModelNode:SetSequence(s)
  self.sequence = s;
  for key,value in pairs(self.nodes) do
    value:SetSequence(s);
  end
end

function ModelNode:RigidBodyComponent(shape, mass) 

  --FIXME: #self.nodes无法正确返回其中个数
  --目前只支持一个mesh node
  if shape == apolloengine.RigidBodyComponent.CST_MESH and #self.nodes > 1 then
      error("Physic component only support one mesh node model!");
  end  
  for key, value in pairs(self.nodes) do
    local meshNode = value;
    local collisionShape;
    if shape == apolloengine.RigidBodyComponent.CST_BOX then
      local halfsize = self.bindbox:GetOriginalBindBox():GetExtent();
      collisionShape = apolloengine.BoxShape(halfsize);
       ModelNode.super.RigidBodyComponent(self,collisionShape,mass);
    elseif shape == apolloengine.RigidBodyComponent.CST_MESH then
      local vertexstream = meshNode:GetVertexStream();
      local indexstream = meshNode:GetIndexStream();
      collisionShape = apolloengine.MeshShape(vertexstream, indexstream);
       ModelNode.super.RigidBodyComponent(self,collisionShape,mass);
    elseif shape == apolloengine.RigidBodyComponent.CST_SPHERE then
      local halfsize = self.bindbox:GetOriginalBindBox():GetExtent();
      local x = halfsize:x();
      local y = halfsize:y();
      local z = halfsize:z();
      local radius = x;
      if radius < y then
        radius = y;
      end
      if radius < z then
        radius = z;
      end
      collisionShape = apolloengine.SphereShape(radius);
      ModelNode.super.RigidBodyComponent(self,collisionShape,mass);
    end
   
  end
end

function ModelNode:GetMeshNode(meshPath)
  return self.nodes[meshPath];
end

function ModelNode:KeepSource(iskeepsource)
  self.keepsource = iskeepsource;
end

function ModelNode:GetJoint(name)
    return self.skeletonNode:GetJoint(name);
end

function ModelNode:GetJointNames()
  return self.skeletonNode:GetJointNames()
end

function ModelNode:CreateJoint(name, rotlimlow, rotlimup)
  return self.skeletonNode:CreateJoint(name, rotlimlow, rotlimup);
end

function ModelNode:GetBoneRoots()
  return self.skeletonNode:GetBoneRoots();
end

function ModelNode:SetTarget(name, t)
  return self.skeletonNode:SetTarget(name, t);
end

function ModelNode:CreateEffector(name)
  return self.skeletonNode:CreateEffector(name);
end

function ModelNode:SetRootJoint(name)
  return self.skeletonNode:SetRootJoint(name);
end

function ModelNode:LinkJoints(j1, j2)
  return self.skeletonNode:LinkJoints(j1, j2);
end

function ModelNode:BuildKinematics()
  self.skeletonNode:BuildKinematics();
end

function ModelNode:UpdateKinematics()
  return self.skeletonNode:UpdateKinematics();
end

return ModelNode;
