
#DEFPARAMS
TEXTURE_DIFFUSE = { "Main Tex", TEXTURE2D, "white" },
VERTEX_SCALER = { "vertex Scale", VEC2, "1.0,1.0" },
#END

#DEFTAG
ShaderName = "MaskClip"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE ={ CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 uv : TEXCOORD0;
};

sampler2D TEXTURE_DIFFUSE;
float2 VERTEX_SCALER;

v2f vert(appdata v)
{
	v2f o;
	float4 in_vertex = UniformNDC(v.vertex);
	float2 vertex_xy = float2(in_vertex.xy);
    vertex_xy = vertex_xy * VERTEX_SCALER;
    o.vertex = float4(vertex_xy.x,vertex_xy.y,0.0,1.0);
	o.uv = v.uv;
	return o;
}

float4 frag(v2f i) : SV_Target
{
	return tex2D(TEXTURE_DIFFUSE, i.uv);
}
ENDCG
#END
