
#DEFPARAMS
TEXTURE_DIFFUSE = {"TEXTURE_DIFFUSE", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "imageblit_queue_overlay"
RenderQueue = "Overlay"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 in_Position : POSITION;
	float2 in_Coordinate : TEXCOORD0;
};

struct v2f
{
	float2 out_Coordinate : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

v2f vert(appdata v)
{
	v2f o;
	
	o.vertex = UniformNDC(v.in_Position);
	o.out_Coordinate = v.in_Coordinate.xy;
	return o;
}

sampler2D TEXTURE_DIFFUSE;

float4 frag(v2f i) : SV_Target
{
	return tex2D(TEXTURE_DIFFUSE, i.out_Coordinate.xy);
}

ENDCG
#END
