

#DEFPARAMS
#END

#DEFTAG
ShaderName = "DirMap"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "utils.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

sampler2D TEXTURE_Lab;
float2 UNIFORM_uOs;
float UNIFORM_uVer;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float4 frag(v2f i) : SV_Target
{
	float3 m01 = tex2D(TEXTURE_Lab, i.uv + UNIFORM_uOs * float2(-1., +0.)).rgb;
    float3 m10 = tex2D(TEXTURE_Lab, i.uv + UNIFORM_uOs * float2(+0., -1.)).rgb;
    float3 m12 = tex2D(TEXTURE_Lab, i.uv + UNIFORM_uOs * float2(+0., +1.)).rgb;
    float3 m21 = tex2D(TEXTURE_Lab, i.uv + UNIFORM_uOs * float2(+1., +0.)).rgb;

    float3 dx = (m21 - m01);
    float3 dy = (m12 - m10);

    float E;
    float F;
    float G;

    dx *= 100.0;
    dy *= 100.0;
    E = dot(dx, dx);
    F = dot(dx, dy);
    G = dot(dy, dy);
    float gof = ( E + G + sqrt(fsqr(E - G) + 4.0 * F * F) ) / 2.0;
    float2 v1 = float2(gof - E, - F);
    if (length(v1) < 0.005)
	{
 		v1 = float2(0.0, 1.0);
	}
    return encode(v1);
}
ENDCG
#END
