
#DEFPARAMS
UNIFORM_LEFT_EYE = {"UNIFORM_LEFT_EYE", VEC2, "1.0,1.0"},
UNIFORM_RIGHT_EYE = {"UNIFORM_RIGHT_EYE", VEC2, "1.0,1.0"},
UNIFORM_RADIUS = {"UNIFORM_RADIUS", VEC2, "1.0,1.0"},
UNIFORM_RATIOASPECT = {"UNIFORM_RATIOASPECT", FLOAT, "1.0"},
UNIFORM_FACECOEF = {"UNIFORM_FACECOEF", FLOAT, "1.0"},
UNIFORM_CHINCOEF = {"UNIFORM_CHINCOEF", FLOAT, "1.0"},
UNIFORM_SCALERATIO = {"UNIFORM_SCALERATIO", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "biggereyes"
RenderQueue = "Overlay"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 in_Position : POSITION;
	float2 in_Coordinate : TEXCOORD0;
};

struct v2f
{
	float2 out_Coordinate : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

float2 UNIFORM_LEFT_EYE;
float2 UNIFORM_RIGHT_EYE;
float2 UNIFORM_RADIUS;
float UNIFORM_RATIOASPECT;
float2 UNIFORM_NOSE[7];
float4 UNIFORM_FACE_PTS[37];
float UNIFORM_FACECOEF;
float UNIFORM_CHINCOEF;
float2 FACEPARA[19];
float UNIFORM_SCALERATIO;
float3x3 UNIFORM_ZOOMSCALE;

float2 transformWarpPositionToUseByFactor(float2 currentPoint, float2 src, float2 dst, float radiusFactor, float deltaFactor, float aspectRatio)
{
    float2 currentPointToUse = float2(currentPoint.x, currentPoint.y * aspectRatio);
    float2 srcToUse = float2(src.x, src.y * aspectRatio);

    float2  rvec = currentPointToUse - srcToUse;
    float rdot = dot(rvec, rvec);

    float2  dir    = dst - src;
    float dirDot = dot(dir, dir);
    float radiusSquare = radiusFactor * radiusFactor * dirDot; 

    if(rdot > radiusSquare)
    {
        return currentPoint;
    }

    float r = sqrt(rdot);

    float dirLen = sqrt(dirDot);
    dir = dir / dirLen;

    float dist  = radiusSquare - rdot;
    float delta = deltaFactor * dirLen;
    float tmp = r - delta;
    float alpha = dist / (dist + tmp * tmp);
    alpha = alpha * alpha;
    float2 positionToUse = currentPoint - (alpha * delta) * dir;
     
    return positionToUse;
} 

float2 scaleWarpPositionToUse(float2 centerPostion, float2 currentPosition, float radius, float scaleRatio, float aspectRatio)
{
     
    float2 currentPositionToUse = float2(currentPosition.x, currentPosition.y * aspectRatio);
    float2 centerPostionToUse = float2(centerPostion.x, centerPostion.y * aspectRatio);

    float2  rvec = currentPositionToUse - centerPostionToUse;
    float rdot = dot(rvec, rvec);
    
    float radius_square = radius * radius;
    if(rdot > radius_square)
    {
        return currentPosition;
    }

    float r = sqrt(rdot);
    float factor = r / radius - 1.0;   
    float alpha = 1.0 - scaleRatio * factor * factor;
    float2 positionToUse = centerPostion + alpha * (currentPosition - centerPostion);
     
    return positionToUse; 
}

v2f vert(appdata v)
{
#define nose UNIFORM_NOSE
#define facePointsArray UNIFORM_FACE_PTS
#define facepara  FACEPARA
	float4 in_Position = v.in_Position;
	float2 in_TexCooridate = v.in_Coordinate;
	float2 leftEyeCenterPosition = UNIFORM_LEFT_EYE;
	float2 rightEyeCenterPosition = UNIFORM_RIGHT_EYE;
	float2 radius = UNIFORM_RADIUS;
	float aspectRatio = UNIFORM_RATIOASPECT;
	float faceCoef = UNIFORM_FACECOEF;
	float chinCoef = UNIFORM_CHINCOEF;
	float scaleRatio = UNIFORM_SCALERATIO;
	float3x3 zoomscale = UNIFORM_ZOOMSCALE;

    float2 newpos = (mul(float3(in_Position.xy,1.0), zoomscale)).xy;
    float4 outPos = float4(newpos,in_Position.z,in_Position.a);
    
    float2 newTexCooridate = float2((newpos.x+1.0)*0.5,(newpos.y+1.0)*0.5);
    const int facePointNum = 37;
    float2 positionToUse  = newTexCooridate * 2.0 - 1.0;

    //眼睛
    positionToUse = scaleWarpPositionToUse(leftEyeCenterPosition,  positionToUse, radius.x, 0.7*scaleRatio, aspectRatio);
    positionToUse = scaleWarpPositionToUse(rightEyeCenterPosition, positionToUse, radius.y, 0.7*scaleRatio, aspectRatio);

    
    for(int j = 0; j < facePointNum; ++j){
      int k = j/2;
      positionToUse = transformWarpPositionToUseByFactor(positionToUse, facePointsArray[j].xy, facePointsArray[j].zw, facepara[k].x, facepara[k].y* faceCoef, aspectRatio);
    }

    float2 out_TexCooridate =  0.5 * positionToUse + 0.5;

	v2f o;
	o.vertex = UniformNDC(outPos);
	o.out_Coordinate = float2(out_TexCooridate.x, 1.0 - out_TexCooridate.y);
	return o;
}

sampler2D TEXTURE_DIFFUSE;

float4 frag(v2f i) : SV_Target
{
	#define inputImageTexture TEXTURE_DIFFUSE
	float2 textureCoordinate = i.out_Coordinate.xy;

	float4 outColor = tex2D(inputImageTexture,float2(clamp(textureCoordinate.x,0.001,0.999),clamp(textureCoordinate.y,0.001,0.999)));
	return outColor;
}

ENDCG
#END
