
#DEFPARAMS
UNIFORM_RATIOASPECT = {"UNIFORM_RATIOASPECT", FLOAT, "1.0"},
UNIFORM_FACESNUM = {"UNIFORM_FACESNUM", FLOAT, "1.0"},
UNIFORM_FACECOEF = {"UNIFORM_FACECOEF", VEC2, "1.0,1.0"},
UNIFORM_EYE_LARGE = {"UNIFORM_EYE_LARGE", VEC2, "1.0,1.0"},
UNIFORM_FACE_NARROW = {"UNIFORM_FACE_NARROW", VEC2, "1.0,1.0"},
UNIFORM_CHIN_LENG = {"UNIFORM_CHIN_LENG", FLOAT, "1.0"},
UNIFORM_NOSE_NARROW = {"UNIFORM_NOSE_NARROW", FLOAT, "1.0"},
UNIFORM_NOSE_LENG = {"UNIFORM_NOSE_LENG", FLOAT, "1.0"},
UNIFORM_CANTHUS_OPEN = {"UNIFORM_CANTHUS_OPEN", VEC2, "1.0,1.0"},
UNIFORM_CANTHUS_ANGLE = {"UNIFORM_CANTHUS_ANGLE", VEC2, "1.0,1.0"},
UNIFORM_EYE_DIS = {"UNIFORM_EYE_DIS", FLOAT, "1.0"},
UNIFORM_MOUTH = {"UNIFORM_MOUTH", FLOAT, "1.0"},
UNIFORM_LINE_HAIR = {"UNIFORM_LINE_HAIR", FLOAT, "1.0"},
UNIFORM_NOSE_HUMP = {"UNIFORM_NOSE_HUMP", FLOAT, "1.0"},
UNIFORM_NOSE_HUMP_RATE = {"UNIFORM_NOSE_HUMP_RATE", FLOAT, "1.0"},
UNIFORM_PHILTRUM_LENG = {"UNIFORM_PHILTRUM_LENG", FLOAT, "1.0"},
UNIFORM_MACINTOSH = {"UNIFORM_MACINTOSH", FLOAT, "1.0"},
#END

#DEFTAG
ShaderName = "biggereyes"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 in_Position : POSITION;
	float2 in_Coordinate : TEXCOORD0;
};

struct v2f
{
	float2 out_Coordinate : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

float UNIFORM_RATIOASPECT;
float UNIFORM_FACESNUM;
float4 UNIFORM_FACES_BOX[3];
float2 UNIFORM_LEFT_EYES[33];
float2 UNIFORM_RIGHT_EYES[33];
float2 UNIFORM_MOUSE[60];
float2 UNIFORM_LEFT_PTS[48];
float2 UNIFORM_RIGHT_PTS[48];
float2 UNIFORM_CHIN[3];
float2 UNIFORM_NOSE[51];
float2 UNIFORM_FOREHEAD[18];
float2 UNIFORM_FACECOEF;
float2 UNIFORM_EYE_LARGE;
float2 UNIFORM_FACE_NARROW;
float UNIFORM_CHIN_LENG;
float UNIFORM_NOSE_NARROW;
float UNIFORM_NOSE_LENG;
float2 UNIFORM_CANTHUS_OPEN;
float2 UNIFORM_CANTHUS_ANGLE;
float UNIFORM_EYE_DIS;
float UNIFORM_MOUTH;
float UNIFORM_LINE_HAIR;
float UNIFORM_NOSE_HUMP;
float UNIFORM_NOSE_HUMP_RATE;
float UNIFORM_PHILTRUM_LENG;
float UNIFORM_MACINTOSH;

float2 faceStretch(float2 textureCoord, float2 originPosition, float2 targetPosition, float radius, float curve)
{
    float2 direction = targetPosition - originPosition;
    float lengthA = length(direction);
    float lengthB = min(lengthA, radius);
    direction *= lengthB / lengthA;
    float infect = distance(textureCoord, originPosition)/radius;
    infect = clamp(1.0-infect,0.0,1.0);
    infect = pow(infect, curve);
    
    return direction * infect;
}

v2f vert(appdata v)
{
	float4 in_Position = v.in_Position;
	float2 in_TexCooridate = v.in_Coordinate.xy;

	half aspectRatio = UNIFORM_RATIOASPECT;
	half facesNum = UNIFORM_FACESNUM;
	#define facesBox UNIFORM_FACES_BOX
	#define leftEyes UNIFORM_LEFT_EYES
	#define rightEyes UNIFORM_RIGHT_EYES
	#define mouse UNIFORM_MOUSE
	#define leftContourPoints UNIFORM_LEFT_PTS
	#define rightContourPoints UNIFORM_RIGHT_PTS
	#define chin UNIFORM_CHIN
	#define nose UNIFORM_NOSE
	#define forehead UNIFORM_FOREHEAD
	float2 faceCoef = UNIFORM_FACECOEF;
	float2 eyeLarge = UNIFORM_EYE_LARGE;
	float2 narrowfaceCoef = UNIFORM_FACE_NARROW;
	half lengchinCoef = UNIFORM_CHIN_LENG;
	half narrownoseCoef = UNIFORM_NOSE_NARROW;
	half lengnoseCoef = UNIFORM_NOSE_LENG;
	float2 opencanthus = UNIFORM_CANTHUS_OPEN;
	float2 anglecanthus = UNIFORM_CANTHUS_ANGLE;
	half diseye = UNIFORM_EYE_DIS;
	half mouthCoef = UNIFORM_MOUTH;
	half hairline = UNIFORM_LINE_HAIR;
	half nosehump = UNIFORM_NOSE_HUMP;
	half nosehump_rate = UNIFORM_NOSE_HUMP_RATE;
	half lengphiltrum = UNIFORM_PHILTRUM_LENG;
	half macintosh = UNIFORM_MACINTOSH;

	const int halfFaceNum = 9;
    const int halfChinNum = 7;
    const int halfEyeNum = 9;
    float2 positionToUse  = in_TexCooridate * 2.0 - 1.0;

    int num = int(facesNum);
    for(int i = 0; i < num; ++i)
    {
      float alpha = 0.0;
      // eye1
      float eyeRadius = distance( mouse[i*20], mouse[i*20+6])*0.33;
      if(eyeLarge.x >=0.01)
      {
        float dis_eye1 = distance(float2(positionToUse.x,positionToUse.y*aspectRatio), float2(leftEyes[i*11+9].x,leftEyes[i*11+9].y*aspectRatio));
        if(dis_eye1 <= eyeRadius)
        {
           alpha = pow(dis_eye1 / eyeRadius, eyeLarge.x);
           positionToUse.x = leftEyes[i*11+9].x +(positionToUse.x - leftEyes[i*11+9].x) * alpha;
           positionToUse.y = leftEyes[i*11+9].y +(positionToUse.y - leftEyes[i*11+9].y) * alpha;
        }
       
      }
      // eye2   
     if(eyeLarge.y >=0.01)
     {
       float dis_eye2 = distance(float2(positionToUse.x,positionToUse.y*aspectRatio),float2(rightEyes[i*11+9].x,rightEyes[i*11+9].y*aspectRatio));            
       if(dis_eye2 <= eyeRadius)
       {
         alpha = pow(dis_eye2 / eyeRadius,eyeLarge.y);
         positionToUse.x = rightEyes[i*11+9].x +(positionToUse.x - rightEyes[i*11+9].x) * alpha;
         positionToUse.y = rightEyes[i*11+9].y +(positionToUse.y - rightEyes[i*11+9].y) * alpha;
       }
     }
     //鼻子中心的点
     float2 curNose = nose[i*13+4];
     float2 curChin = chin[i];
     float2 chinCenter = curNose + (curChin - curNose) * 0.7;
     float face_width = distance(leftEyes[i*11+9],rightEyes[i*11+9]);
       
     //下巴最下面一个点
     float normalScale = 1.0;
		 float2 leftF = float2(0.0);
     float2 targetleftF = float2(0.0);
     float2 leftFplus = float2(0.0);
     float2 rightF = float2(0.0);
     float2 targetrightF = float2(0.0);
     float2 rightFplus = float2(0.0);
     
     float curRadius = face_width*1.0;
       //脸两侧左右的点9,23
       if(faceCoef.x >=0.01)
       {
         normalScale = 1.0 -faceCoef.x*0.1;
         leftF = leftContourPoints[i*16+9];    
         targetleftF = curNose + (leftF - curNose) * normalScale ;
         leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
         positionToUse = positionToUse - leftFplus;
       }
       if(faceCoef.y >=0.01)
       {
         normalScale = 1.0 -faceCoef.y*0.1;
         rightF = rightContourPoints[i*16+9];
         targetrightF = curNose + (rightF - curNose) * normalScale ;
         rightFplus = faceStretch(positionToUse, rightF, targetrightF, curRadius, 1.0);
         positionToUse = positionToUse - rightFplus;
       }
       ////收下巴点位13，19
       curRadius = face_width*1.2;
       if(faceCoef.x >=0.01)
       {
         normalScale = 1.0 -faceCoef.x*0.1;
         
         leftF = float2(leftContourPoints[i*16+14].x, leftContourPoints[i*16+14].y);
         targetleftF = chinCenter + (leftF - chinCenter) *  normalScale;
         leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
         positionToUse = positionToUse - leftFplus;
       }
       if(faceCoef.y >=0.01)
       {
         normalScale = 1.0 -faceCoef.y*0.1;
         rightF = float2(rightContourPoints[i*16+14].x, rightContourPoints[i*16+14].y);
         targetrightF = chinCenter + (rightF - chinCenter) *  normalScale;
         rightFplus = faceStretch(positionToUse, rightF, targetrightF, curRadius, 1.0);
         positionToUse = positionToUse - rightFplus;
       }
       
     //微整形的半径要小，不能影响其他部位
     //窄脸微整形:脸两侧左右的点10,22  
     
     curRadius = face_width*0.2;
     for(int j= 2;j<12;++j)
     {
       if(narrowfaceCoef.x >=0.01)
       {
         normalScale = 1.0 -narrowfaceCoef.x*0.02;
         leftF = leftContourPoints[i*16+j];    
         targetleftF = curNose + (leftF - curNose) * normalScale ;
         leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
         positionToUse = positionToUse - leftFplus;
       }
       if(narrowfaceCoef.y >=0.01)
       {
         normalScale = 1.0 -narrowfaceCoef.y*0.02;
         rightF = rightContourPoints[i*16+j];
         targetrightF = curNose + (rightF - curNose) * normalScale ;
         rightFplus = faceStretch(positionToUse, rightF, targetrightF, curRadius, 1.0);
         positionToUse = positionToUse - rightFplus;
       }
     }
     //下巴长短
     if(lengchinCoef >=0.01||lengchinCoef <= -0.01)
     {
       curRadius = face_width*0.2;
       normalScale = 1.0 + lengchinCoef*0.025;//+或者-为拉长或者变短
       float2 targetchin = mouse[i*20+9]  +(curChin - mouse[i*20+9]) *  normalScale;
       float2 noseplus = float2(0.0);
       noseplus = faceStretch(positionToUse, curChin, targetchin, curRadius, 1.0);
       positionToUse = positionToUse - noseplus;
       float k = 0.25;
       for(int j= 12;j<16;++j)
       {
         leftF = leftContourPoints[i*16+j];    
         targetleftF = leftF + (targetchin - curChin)*k ;
         leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
         positionToUse = positionToUse - leftFplus;
       
         rightF = rightContourPoints[i*16+j];
         targetrightF = rightF + (targetchin - curChin)*k ;
         rightFplus = faceStretch(positionToUse, rightF, targetrightF, curRadius, 1.0);
         positionToUse = positionToUse - rightFplus;
         k = k+0.25;
       }
     }
     //瘦鼻子
     curRadius = face_width*0.2;
     if(narrownoseCoef >=0.01)
     {
       normalScale = 1.0 - narrownoseCoef*0.1;
       for(int j= 5;j<8;++j)
       {   
           leftF = nose[i*13+j]; 
           rightF = nose[i*13+j+4];
           float2 target = (leftF+rightF)/2.0;
           targetleftF = target + (leftF - target) * normalScale ;
           leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
           positionToUse = positionToUse - leftFplus;
           targetrightF = target + (rightF - target) * normalScale ;
           rightFplus = faceStretch(positionToUse, rightF, targetrightF, curRadius, 1.0);
           positionToUse = positionToUse - rightFplus;
       }
     }
     //鼻子长短：往下或者往上移
     curRadius = face_width*0.2;
     if(lengnoseCoef >=0.01 || lengnoseCoef <= -0.01)
     {
       normalScale = lengnoseCoef*0.01;//+或者-为拉长或者变短
       float2 targetNose = (curChin - curNose) *  normalScale ;
       
       for(int j= 0;j<13;++j)
       {
         leftF = nose[i*13+j];    
         targetleftF = leftF + targetNose;
         leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
         positionToUse = positionToUse - leftFplus;
       }
     }
     //开眼角 
     curRadius = face_width*0.2;
     if(opencanthus.x >=0.01 )
     {
       normalScale = 1.0 - opencanthus.x*0.03;
     
       float2 target = nose[i*13];
      
       leftF  = leftEyes[i*11+4]; 
       targetleftF = target + (leftF - target) * normalScale ;
       leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
       positionToUse = positionToUse - leftFplus;
     }
     if(opencanthus.y >=0.01)
     {
       normalScale = 1.0 - opencanthus.y *0.03;
       float2 target = nose[i*13];
       rightF = rightEyes[i*11+4];
       targetrightF = target + (rightF - target) * normalScale ;
       rightFplus = faceStretch(positionToUse, rightF, targetrightF, curRadius, 1.0);
       positionToUse = positionToUse - rightFplus;
     }
     //眼睛角度：以眼球为中心，两边的点上移或者下移
     if(anglecanthus.x >=0.0001)
     {
        curRadius = face_width*0.1;
        normalScale = 0.99;
        float2 leftEye  = leftEyes[i*11+9]; 
        float2 rightEye  = rightEyes[i*11+9];
        for(int j=0;j<8;j++)
        {
          
          leftF = leftEyes[i*11 + j]; 
          targetleftF.x = (leftF.x - leftEye.x)*cos(anglecanthus.x) - (leftF.y - leftEye.y)*sin(anglecanthus.x) + leftEye.x  ;
          targetleftF.y = (leftF.x - leftEye.x)*sin(anglecanthus.x) + (leftF.y - leftEye.y)*cos(anglecanthus.x) + leftEye.y  ;
          leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
          positionToUse = positionToUse - leftFplus; 
        }
     }
     if(anglecanthus.y >=0.0001)
     { 
       curRadius = face_width*0.1;
       normalScale = 0.99;
       float2 rightEye  = rightEyes[i*11+9];
       for(int j=0;j<8;j++)
       {
         rightF = rightEyes[i*11 + j]; 
         targetrightF.x = (rightF.x - rightEye.x)*cos(-anglecanthus.y ) - (rightF.y - rightEye.y)*sin(-anglecanthus.y ) + rightEye.x  ;
         targetrightF.y = (rightF.x - rightEye.x)*sin(-anglecanthus.y ) + (rightF.y - rightEye.y)*cos(-anglecanthus.y ) + rightEye.y  ;
         rightFplus = faceStretch(positionToUse, rightF, targetrightF, curRadius, 1.0);
         positionToUse = positionToUse - rightFplus; 
       } 
     }
     //眼距 两只眼睛往中间或者两边移动
     if(diseye >=0.01 || diseye <= -0.01)
     {
       curRadius = face_width*0.2;
       normalScale = diseye*0.01;//+或者-为拉长或者变短
       float2 leftEye  = leftEyes[i*11+9]; 
       float2 rightEye  = rightEyes[i*11+9];
       float2 eyeCenter = (leftEye+rightEye)/2.0;
       float2 targetEyeL = leftEye  +(eyeCenter - leftEye) *  normalScale;
       float2 targetEyeR = rightEye  +(eyeCenter - rightEye) *  normalScale;
       float2 leftdis = targetEyeL - leftEye;
       float2 rightdis = targetEyeR - rightEye ;
       
       for(int j= 0;j<10;++j)
       {
         leftF = leftEyes[i*11+j];    
         targetleftF = leftF + leftdis ;
         leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
         positionToUse = positionToUse - leftFplus;
         
         rightF = rightEyes[i*11+j];    
         targetrightF = rightF + rightdis ;
         rightFplus = faceStretch(positionToUse, rightF, targetrightF, curRadius, 1.0);
         positionToUse = positionToUse - rightFplus;
       }
     }
     //嘴型
     if(mouthCoef >=0.01 || mouthCoef <= -0.01)
     {
       curRadius = face_width*0.2;
       normalScale = 1.0 - mouthCoef*0.1;
       float2 mouthCenter =( mouse[i*20+14] +  mouse[i*20+18] )/2.0 ;   //98- 14  102-18
       
       for(int j= 0;j<12;++j)
       {
          leftF = mouse[i*20+j];    
          targetleftF = mouthCenter + (leftF - mouthCenter) * normalScale ;
          leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
          positionToUse = positionToUse - leftFplus;
       }
     }
       //人中长短  49 87
     if(lengphiltrum >=0.01 || lengphiltrum <= -0.01)
     {
       curRadius = face_width*0.2;
       normalScale = lengphiltrum*0.01;//+或者-为拉长或者变短
       float2 mouthUp  = mouse[i*20+3]; 
       float2 noseBottom  = nose[i*13+4];
       float2 targetVec2 =(noseBottom - mouthUp) *  normalScale ;
       
       for(int j= 0;j<12;++j)
       {
         leftF = mouse[i*20+j];    
         targetleftF = leftF + targetVec2 ;
         leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
         positionToUse = positionToUse - leftFplus;
       }
      }
     
     //侧脸隆鼻,43,44,45三个点做一个平均向量，逆时针旋转90度，为三个点的平移向量
     if(((nosehump_rate >= 20.0 && nosehump_rate <= 30.0) || (nosehump_rate >= -30.0 && nosehump_rate <= -20.0) )&& nosehump >= 0.01)
     {
       curRadius = face_width*0.2;
       float2 nose46 = nose[i*13+0];
       float2 nose44 = nose[i*13+1];
       float2 nose45 = nose[i*13+2];
       
       float2 v1 = nose45 - nose44;
       float2 v2 = nose46 - nose45;
       float2 v = (v1+v2)*0.5;
       
       //逆时针旋转90度
       float2 v90;
       
      if(nosehump_rate>0.0)
      {
        v90.x = v.x*cos(90.0) - v.y*sin(90.0);
        v90.y = v.x*sin(90.0) + v.y*cos(90.0);
      }
      else
      {
        v90.x = v.x*cos(-90.0) - v.y*sin(-90.0);
        v90.y = v.x*sin(-90.0) + v.y*cos(-90.0);
      }
      
       normalScale = nosehump*0.3;//+或者-为拉长或者变短
       float2 tempNose = v90 *  normalScale ;
       
       for(int j= 1;j<4;++j)
       {
         leftF = nose[i*13+j];    
         targetleftF = leftF - tempNose;
         leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
         positionToUse = positionToUse - leftFplus;
       }
     }
     //苹果肌macintosh
     if(macintosh >= 0.01)
     {
       leftF  = (leftContourPoints[3]  + nose[5])*0.5;
       rightF = (rightContourPoints[3] + nose[9])*0.5;
       
       float2 v1 = leftContourPoints[0]  - leftContourPoints[1];
       float2 v2 = rightContourPoints[0] - rightContourPoints[1];
       
       curRadius = face_width*0.2;
       normalScale = macintosh*0.002;
       
       float2 temp = v1 *  normalScale ;
       
       targetleftF = leftF + temp;
       leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
       positionToUse = positionToUse - leftFplus;
       
       temp = v2 *  normalScale ;
       targetrightF = rightF + temp;
       rightFplus = faceStretch(positionToUse, rightF, targetrightF, curRadius, 1.0);
       positionToUse = positionToUse - rightFplus;
     }
     //发际线
     if(hairline >= 0.01)
     {
        normalScale = 1.0 - hairline*0.028;
        curRadius = face_width*0.4;
       for(int j= 1;j<6;++j)
       {   
           leftF = forehead[i*8+j]; 
           float2 target = forehead[0];
           targetleftF = target + (leftF - target) * normalScale ;
           leftFplus = faceStretch(positionToUse, leftF, targetleftF, curRadius, 1.0);
           positionToUse = positionToUse - leftFplus;
       }
     }
      
    }
    float2 out_TexCooridate =  0.5 * positionToUse + 0.5;

	v2f o;
	o.vertex = UniformNDC(in_Position);
	o.out_Coordinate = out_TexCooridate.xy;
	return o;
}

sampler2D TEXTURE_DIFFUSE;

float4 frag(v2f i) : SV_Target
{
	#define inputImageTexture TEXTURE_DIFFUSE
	float2 textureCoordinate = i.out_Coordinate.xy;

	float4 outColor = tex2D(inputImageTexture,float2(clamp(textureCoordinate.x,0.001,0.999),clamp(textureCoordinate.y,0.001,0.999)));
	return outColor;
}

ENDCG
#END