local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local Object = require "classic"
local am = require "mathfunction"
local rendernode = require "apolloutility.apollonode.rendernode"
local facecrop = require "game.facecrop"
local videodecet = require "videodecet"
--local paradef = require "game.defined"
local gameparadef = require "game.defined"
local paradef = nil;
local facecorpmouthptcount = 0;
local facecorpmouthindexcount = 0;
local behdefined = require "facecute.behavior.behdefined"
local facecropmouth  = facecrop:extend();
function facecropmouth:new(maincamera)
  
  self.maincamera = maincamera;
  facecropmouth.super.new(self);  
  facecropmouth.super.SetShow(self, false);
  apolloengine.ShaderEntity.UNIFORM_CROPCENTER = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_CROPCENTER");
     apolloengine.ShaderEntity.UNIFORM_CROPSCALE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "UNIFORM_CROPSCALE");
    
  apolloengine.ShaderEntity.UNIFORM_EDGEJUDGE = apolloengine.IMaterialSystem:NewParameterSlot(
  apolloengine.ShaderEntity.UNIFORM,
  "UNIFORM_EDGEJUDGE");
  
  apolloengine.ShaderEntity.UNIFORM_EDGEALPHA = apolloengine.IMaterialSystem:NewParameterSlot(
  apolloengine.ShaderEntity.UNIFORM,
  "UNIFORM_EDGEALPHA");
  
  self.mouthavg={0,0};
  --self.lastFrames = 100000;
  self.curGameFrame = 0;
  self.mouthAngle = 0;
  self.bstartFirst = true; 
end

function facecropmouth:GetFaceCropPtCount()
  return facecorpmouthptcount;
end

function facecropmouth:GetFaceCropTriIndexCount()
  return facecorpmouthindexcount;
end


function facecropmouth:_CaculateCoords()  
  local face = self.face;
  local facePtCount = facecorpmouthptcount;
  local Keypoints = face:GetKeypointArray();
  local faceMouthIndex = paradef.faceMouthIndex;
  self.OriginalFaceCoords = self.OriginalFaceCoords and self.OriginalFaceCoords or {};
  local OriginalFaceCoords = self.OriginalFaceCoords;
  local xsum = 0;
  local ysum = 0;
  
  for i=0,facePtCount-1 do
      local points = Keypoints[faceMouthIndex[i+1]+1];
      xsum = xsum + points[1];
      ysum = ysum + points[2];
  end
  
  local xavg = xsum / facePtCount;
  local yavg = ysum/ facePtCount;

  local euler = self.face:GetRotation();
  local avgLen = self:_GetLen(self.mouthavg,{xavg,yavg});
  if(avgLen<paradef.jerkLenCenter and not self.bstartFirst)
  then
    self.mouthavg[1] =  xavg*paradef.jerkWeight+self.mouthavg[1]*(1.0-paradef.jerkWeight) ;
    self.mouthavg[2] = yavg*paradef.jerkWeight+self.mouthavg[2]*(1.0-paradef.jerkWeight);
    xavg= self.mouthavg[1] ;
    yavg = self.mouthavg[2] ;
  else
    self.mouthavg[1] =  xavg;
    self.mouthavg[2] = yavg;
    self.bstartFirst = false;
  end

  local mouthExtendScale  = paradef.mouthExtendScale;
  for i=0,facePtCount-1 do
      local points = Keypoints[faceMouthIndex[i+1]+1];
      OriginalFaceCoords[i * 2] =  xavg+(points[1]-xavg)*mouthExtendScale[1];--2 *  points[2*(i+1)-1] / vec2[1] - 1;
      OriginalFaceCoords[i * 2 +1] = yavg+(points[2]-yavg)*mouthExtendScale[2];--2 * points[2*(i+1)] / vec2[2] - 1;
  end
  OriginalFaceCoords[facePtCount * 2] =  xavg;--2 *  points[2*(i+1)-1] / vec2[1] - 1;
  OriginalFaceCoords[facePtCount * 2 +1] = yavg;--2 * points[2*(i+1)] / vec2[2] - 1;
  

end

function facecropmouth:GetMaterailPath(config)
  local path = paradef.filePrefix..paradef.faceMouthMaterial;
  return path;
end

function facecropmouth:GetFaceCoods()
  self:_CaculateCoords();
  self:_FittingCoords();
  return self.newCoords;
end

function facecropmouth:GetFaceCropTriIndex()
  
  return nil;
  --return paradef.faceMouthTriangles;
end



function facecropmouth:GetActionRect(action)

   local len = table.getn(action);
    self.rect = nil;
    self.center = nil;
    for i=1,len do
         local id = action[i]:GetActionID();
      if(id==behdefined.triggerType.OpenMouth)
      then
         local rect =action[i]:GetRect();
         local  center =action[i]:GetCenter();
         self.rect = rect;
         self.center = center;
         --LOG("OPEN MOUTH TRIGGER")
         if(self.rect)
         then
           --LOG("OPEN MOUTH RECT")
         end
         if(self.center)
         then
           --LOG("OPEN MOUTH CENTER")
         end
      end
    end
end


function facecropmouth:InitVertexSteam()
  local ptcount = facecorpmouthptcount/2*self.ptcount;
  
  --bound
  for i =1,ptcount do
          self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
      mathfunction.vector4(0,0,0,1));
    
             self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE1,
      mathfunction.vector1(1));
  end
  
  --center
    self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
      mathfunction.vector4(0,0,0,1)
    );
    
    
    self.vertexstream:PushVertexData(
    apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE1,
    mathfunction.vector1(0));
  
end

function facecropmouth:_GetLen(p1,p2)
  
  local dx = (p2[1]-p1[1]);
  local dy = (p2[2]-p1[2]);
  return math.sqrt(dx*dx+dy*dy);
  --local p1p2 = mathfunction.vector2(p2[1]-p1[1],p2[2]-p1[2]);
  --return p1p2:Length();
end

function facecropmouth:_GetAnchorPoint(p1,p2,p3,k)
  local x0 = p1[1];
  local y0 = p1[2];
  local x1 = p2[1];
  local y1 = p2[2];
  local x2 = p3[1];
  local y2 = p3[2];
  
  local midx01 = (x0+x1)/2;
  local midy01 =(y0+y1)/2;
  local midx12 =(x1+x2)/2;
  local midy12 =(y1+y2)/2;
  local len01 = self:_GetLen({x0,y0},{x1,y1});
  local len12 = self:_GetLen({x1,y1},{x2,y2});
  
  local lenr=(len12<paradef.zeroJudge) and 1 or len01/len12;
  local cx = midx01/(1+lenr)+midx12*lenr/(1+lenr);
  local cy = midy01/(1+lenr)+midy12*lenr/(1+lenr);
  local dx = x1-cx;
  local dy = y1-cy;
  --local k = 0.5;
  local anchor01x = (midx01+dx-x1)*k+x1;
  local anchor01y = (midy01+dy-y1)*k+y1;
  local anchor12x = (midx12+dx-x1)*k+x1;
  local anchor12y = (midy12+dy-y1)*k+y1;
  local anchors = {anchor01x,anchor01y,anchor12x,anchor12y};
  return anchors;

end


function facecropmouth:_GetAllPoint(ptcount)
  
   local newcoords= self.newCoords and self.newCoords or {};
   local facePtCount = facecorpmouthptcount;
   self.anchors={};
   local org=    self.OriginalFaceCoords;
    for i=0,facePtCount-1 do
      local s1 = ((i-1)>=0) and (i-1) or (i-1+facecorpmouthptcount) ;
      local s2= i;
      local s3 = ((i+1)==facePtCount) and 0 or (i+1) ;
      local p1 = {org[s1*2],org[s1*2+1]};
      local p2 ={org[s2*2],org[s2*2+1]};
      local p3={org[2*s3],org[2*s3+1]};
      local anchor =self:_GetAnchorPoint(p1,p2,p3,0.6);
      table.insert(self.anchors,anchor);
  end
  
    local curindex = 0;
    for i=0,facePtCount-1 do
      local s1 = ((i-1)>=0) and (i-1) or (i-1+facecorpmouthptcount) ;
      local s2= i;
      local s3 = ((i+1)==facePtCount) and 0 or (i+1) ;
      local startpt ={org[s2*2],org[s2*2+1]};
      local endpt={org[2*s3],org[2*s3+1]};
      local aindex1 = i+1;
      local aindex2 = (i+2==(facePtCount+1)) and 1 or (i+2) ;
      local anchor1 = {self.anchors[aindex1][3],self.anchors[aindex1][4]};
      local anchor2 = {self.anchors[aindex2][1],self.anchors[aindex2][2]};
      
      local x0= startpt[1];
      local y0= startpt[2];
      local x2 = endpt[1];
      local y2 = endpt[2];
      local anchor01x = anchor1[1];
      local anchor01y = anchor1[2];
      local anchor12x = anchor2[1];
      local anchor12y = anchor2[2];
      
      local stepb = 1/(ptcount);
      for j= 0,ptcount-1 do
        local t = j*stepb;
        local aa =(1-t)*(1-t);
        local bb = t*t;
        local a1= aa*(1-t);
        local a2 = 3*t*aa;
        local a3 = 3*bb*(1-t);
        local a4 = t*bb;
        --local x =(1-t)*(1-t)*(1-t)*x0+3*t*(1-t)*(1-t)*anchor01x+3*t*t*(1-t)*anchor12x+x2*t*t*t;
        --local y =(1-t)*(1-t)*(1-t)*y0+3*t*(1-t)*(1-t)*anchor01y+3*t*t*(1-t)*anchor12y+y2*t*t*t;
        local x =a1*x0+a2*anchor01x+a3*anchor12x+x2*a4;
        local y =a1*y0+a2*anchor01y+a3*anchor12y+y2*a4;
        curindex = i*ptcount+j+1;
        newcoords[2*(curindex)-1] = x;
        newcoords[2*(curindex)] = y;
      end
          
      

  end

   newcoords[2*(curindex+1)-1] = self.mouthavg[1];
   newcoords[2*(curindex+1)] = self.mouthavg[2];
 -- table.insert( newcoords,self.mouthavg[1]);
  --table.insert(newcoords,self.mouthavg[2]);
  return newcoords;
  
  
end



function facecropmouth:_addNewCoords(index,ptcount,newcoords)
  local x0 = self.OriginalFaceCoords[2*index[1]];
  local y0 =   self.OriginalFaceCoords[2*index[1]+1];
  
  local x1 = self.OriginalFaceCoords[2*index[2]];
  local y1 =   self.OriginalFaceCoords[2*index[2]+1];
  
  local x2 = self.OriginalFaceCoords[2*index[3]];
  local y2 =   self.OriginalFaceCoords[2*index[3]+1];
  
  local midx01 = (x0+x1)/2;
  local midy01 =(y0+y1)/2;
  local midx12 =(x1+x2)/2;
  local midy12 =(y1+y2)/2;
  local len01 = self:_GetLen({x0,y0},{x1,y1});
  local len12 = self:_GetLen({x1,y1},{x2,y2});
  local lenr=len01/len12;
  
  local cx = midx01/(1+lenr)+midx12*lenr/(1+lenr);
  local cy = midy01/(1+lenr)+midy12*lenr/(1+lenr);
  
  local dx = x1-cx;
  local dy = y1-cy;
  local k = 1.0;
  local anchor01x = (midx01+dx-x1)*k+x1;
  local anchor01y = (midy01+dy-y1)*k+y1;
  local anchor12x = (midx12+dx-x1)*k+x1;
  local anchor12y = (midy12+dy-y1)*k+y1;
  local stepb = 1/(ptcount);
  
  for i= 0,ptcount-1 do
    local t = i*stepb;
    local x =(1-t)*(1-t)*(1-t)*x0+3*t*(1-t)*(1-t)*anchor01x+3*t*t*(1-t)*anchor12x+x2*t*t*t;
    local y =(1-t)*(1-t)*(1-t)*y0+3*t*(1-t)*(1-t)*anchor01y+3*t*t*(1-t)*anchor12y+y2*t*t*t;
    table.insert( newcoords,x);
    table.insert( newcoords,y);
  end
  
  
end

function facecropmouth:_FittingCoords()
 --[[ self.newCoords={};
  local len = #self.orgIndex;
  for i=1,len do
    local index = self.orgIndex[i];
    self:_addNewCoords(index,self.ptcount,self.newCoords);
  end
  
  table.insert( self.newCoords,self.mouthavg[1]);
  table.insert(self.newCoords,self.mouthavg[2]);
  len = #self.newCoords/2;
  local k = len/2;]]--
  self.newCoords = self:_GetAllPoint(self.ptcount/2);
  --local len = #self.newCoords/2;
  --local k = len/2;
end

function facecropmouth:ReStart()
  facecropmouth.super.ReStart(self);
  self.mouthavg={0,0};
  self.mouthAngle = 0;
  self.bstartFirst = true;
end


function facecropmouth:DeepCopy(object)
    local lookup_table = {}
    local function _copy(object)
        if type(object) ~= "table" then
            return object
        elseif lookup_table[object] then
            return lookup_table[object]
        end
        local new_table = {}
        lookup_table[object] = new_table
        for index, value in pairs(object) do
            new_table[_copy(index)] = _copy(value)
        end
        return setmetatable(new_table, getmetatable(object))
    end

    return _copy(object)
end

function facecropmouth:ParseConfig(config) 
  
  
  
  self.mouthpara={};
  local para = self.mouthpara;
 
  for key, value in pairs(gameparadef) do 
    para[key] = self:DeepCopy((config and config[key]) and config[key] or gameparadef[key]);
  
  end
  paradef = self.mouthpara;

  facecorpmouthptcount = #para.faceMouthIndex;
  --facecorpmouthindexcount = #para.faceMouthTriangles;




  facecropmouth.super.Initialize(self,config);
  local triggerconfig={};
  triggerconfig.triggerType = 0;
  triggerconfig.triggerLoop = 0;
  triggerconfig.triggerDelay = 0;
  triggerconfig.triggerStop = true;
  facecropmouth.super.SetTrigger(self,triggerconfig);  
  





  --para.mouthJudgeEdge = config and config.mouthJudgeEdge or nil;
  --local mouthJudgeEdge =para.mouthJudgeEdge and para.mouthJudgeEdge or paradef.mouthJudgeEdge;
  self:SetParameter( apolloengine.ShaderEntity.UNIFORM_EDGEJUDGE, mathfunction.vector1(para.mouthJudgeEdge));
  
  --para.mouthEdgeAlpha = config and config.mouthEdgeAlpha or nil;
  --local mouthEdgeAlpha = para.mouthEdgeAlpha and para.mouthEdgeAlpha or paradef.mouthEdgeAlpha;
  self:SetParameter( apolloengine.ShaderEntity.UNIFORM_EDGEALPHA, mathfunction.vector3(para.mouthEdgeAlpha[1],para.mouthEdgeAlpha[2],para.mouthEdgeAlpha[3]));
  
  

end
function facecropmouth:GetMouthAngle(p1,p2,p3)
  local p1p2 = mathfunction.vector2(p2[1]-p1[1],p2[2]-p1[2]);
  local p1p3 = mathfunction.vector2(p3[1]-p1[1],p3[2]-p1[2]);
  
  local t = p1p2:x()*p1p3:x()+ p1p2:y()*p1p3:y();
  local length12 = p1p2:Length();
  local length13 = p1p3:Length();
  
  local le = length12*length13;
  
  if(le<paradef.zeroJudge)
  then
    return 0;
  end
  
  local cosangle = t/(le);
  local angle  = math.acos(cosangle)*paradef.ArcToDeg;
  return angle;
end
function facecropmouth:Render()
  
  local tex = videodecet:GetVideoTexture();
  self:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, tex);
  
  --local mouthAngle = facegame:GetMouthAngle();
  local Keypoints = self.face:GetKeypointArray();
  local refIndex = paradef.mouthAngleRefIndex;
  local mouthAngle = self:GetMouthAngle(Keypoints[refIndex[1]+1],Keypoints[refIndex[2]+1],Keypoints[refIndex[3]+1]);
  local refIndexAdd = paradef.mouthAngleRefIndexAdd;
  local mouthAngleAdd = self:GetMouthAngle(Keypoints[refIndexAdd[1]+1],Keypoints[refIndexAdd[2]+1],Keypoints[refIndexAdd[3]+1]);
  local euler = self.face:GetRotation();
  mouthAngle =(mouthAngle+mouthAngleAdd)/2;
  
  if(math.abs(self.mouthAngle-mouthAngle)<paradef.jerkMouthAngle and not self.bstartFirst)
  then
    mouthAngle = mouthAngle*paradef.jerkWeight+self.mouthAngle*(1.0-paradef.jerkWeight);
    self.mouthAngle = mouthAngle;
  else
     self.mouthAngle = mouthAngle;
     self.bstartFirst = false;
  end
  
  mouthAngle = mouthAngle * math.cos(euler[3]*paradef.DegToArc);
  
 
  local mouthRatio = 0;
  self:SetShow(true);
  self:SetParameter(apolloengine.ShaderEntity.UNIFORM_CROPCENTER, mathfunction.vector2(self.mouthavg[1],self.mouthavg[2]));
  self:SetParameter(apolloengine.ShaderEntity.UNIFORM_CROPSCALE, mathfunction.vector2(math.max(paradef.mouthAngleRatio[1]*mouthAngle,1.0),math.max(paradef.mouthAngleRatio[2]*mouthAngle,1.0)));
  --self.face = face;
  --self:SetShow(true);
  self:UpdateVertex();
end

function facecropmouth:InitIndexStream()
  local faceOutPtCount = facecorpmouthptcount/2*self.ptcount;
   -- local faceOutPtCount = 110;
  for i=1,faceOutPtCount-1 do
    self.indicesstream:PushIndicesData(faceOutPtCount);
    self.indicesstream:PushIndicesData(i);
    self.indicesstream:PushIndicesData(i-1);
  end
  self.indicesstream:PushIndicesData(faceOutPtCount);
  self.indicesstream:PushIndicesData(0);
  self.indicesstream:PushIndicesData(faceOutPtCount-1);
end

--function facecropmouth:ReSet()
  --self.curGameFrame = 0;
 ---- self:ReStart();
 -- self:SetShow(false);
--end

function facecropmouth:Update(timespan, face, position, rotation, action)
  --self.curGameFrame = self.curGameFrame +1;
  -- self:GetActionRect(action);
  facecropmouth.super.Update(self,timespan,face,position,rotation,action);
end

return facecropmouth;