#SHADER_DEFINE HistoricalrgbVertex

	FUNCTION_INPUT =
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},

	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    vec2 positionToUse  = vec2(in_TexCooridate.x * 2.0 - 1.0, in_TexCooridate.y * 2.0 - 1.0);
    vec2 out_TexCooridate = vec2(positionToUse.x *0.5 + 0.5,positionToUse.y *0.5+0.5);
    gl_Position = in_Position;
#END_CODE
#END_DEFINE

#SHADER_DEFINE HistoricalrgbFragment

	FUNCTION_INPUT =
	{
		{ TEXTURE_DIFFUSE,		    NONE,	 TEXTURE2D,		"uniCurrentTexture"},
    { ATTRIBUTE_COORDNATE0,		HIGH,	      VEC2,		"textureCoordinate"},
    { TEXTURE_RED,            NONE,  TEXTURE2D,   "testTextureR"},
    { TEXTURE_GREEN,          NONE,  TEXTURE2D,   "testTextureG"},
    { TEXTURE_BLUE,           NONE,  TEXTURE2D,   "testTextureB"},
    { UNIFORM_RGBSCALE,        LOW,      FLOAT,   "rgbscale"},
	}

#SHADER_CODE
    float timescale = 0.5;
    vec4 rgb =  texture2D(uniCurrentTexture, textureCoordinate);
    vec4 rgb1 = texture2D(testTextureR, vec2(textureCoordinate.x, textureCoordinate.y));
    vec4 rgb2 = texture2D(testTextureG, vec2(textureCoordinate.x, textureCoordinate.y));
    vec4 rgb3 = texture2D(testTextureB, vec2(textureCoordinate.x, textureCoordinate.y));
    vec3 newrgb = vec3(rgb1.r,rgb2.g,rgb3.b);
    newrgb = vec3(clamp(newrgb.r,0.0,1.0),clamp(newrgb.g,0.0,1.0),clamp(newrgb.b,0.0,1.0));
    gl_FragColor = vec4(newrgb,1.0);
#END_CODE
#END_DEFINE
