
#DEFPARAMS
TEXTURE_DIFFUSE = {"TEXTURE_DIFFUSE", TEXTURE2D, "white" },
TEXTURE_MASK = {"TEXTURE_MASK", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "hairseg"
RenderQueue = "Background"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, ONE, ONE, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 in_Position : POSITION;
	float2 in_Coordinate : TEXCOORD0;
};

struct v2f
{
	float2 out_Coordinate : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

v2f vert(appdata v)
{
	v2f o;
	
	o.vertex = UniformNDC(v.in_Position);
	o.out_Coordinate = v.in_Coordinate.xy;
	return o;
}

sampler2D TEXTURE_DIFFUSE;
sampler2D TEXTURE_MASK;

float4 frag(v2f i) : SV_Target
{
	#define in_SrcTexture TEXTURE_DIFFUSE
	#define in_ColorMask TEXTURE_MASK
	float2 in_TexCoordinate = i.out_Coordinate.xy;

	float4 mask = tex2D(in_ColorMask, float2(in_TexCoordinate.x, in_TexCoordinate.y));
	float4 src_color = tex2D(in_SrcTexture,float2(in_TexCoordinate.x, in_TexCoordinate.y));
	float alpha = src_color.a * mask.r;
	float4 outColor = float4(src_color.rgb,alpha);

	return outColor;
}

ENDCG
#END

