
#DEFPARAMS
POINT_TEXTURE = {"POINT_TEXTURE", TEXTURE2D, "POINT_TEXTURE"},
SECOND_POINT_TEXTURE = {"SECOND_POINT_TEXTURE", TEXTURE2D, "SECOND_POINT_TEXTURE"},
FRAME_TEXTURE = {"FRAME_TEXTURE", TEXTURE2D, "FRAME_TEXTURE"},
BLEND_MODE = {"BLEND_MODE", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName  = "RenderBlingV2"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = {ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE}
DRAW_MODE    = {CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF}
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "blendfunc.inc"

struct appdata
{
    float2 in_pos : POSITION;
    float2 in_tex_coord : TEXCOORD0;
    float2 in_frame_tex_coord : TEXCOORD1;
    float2 in_tex_idx : TEXCOORD2;
};

struct v2f
{
    float2 out_tex_coord : TEXCOORD0;
    float2 out_frame_tex_coord : TEXCOORD1;
    float2 out_tex_idx : TEXCOORD2;
    float4 out_pos : SV_POSITION;
};

v2f vert(appdata v)
{
    v2f o;
    o.out_pos	               = float4(v.in_pos.x, v.in_pos.y, 0.0, 1.0);
    o.out_pos                = o.out_pos;
    o.out_tex_coord          = v.in_tex_coord;
    o.out_frame_tex_coord    = float2(v.in_frame_tex_coord.x, 1.0 - v.in_frame_tex_coord.y);
    o.out_tex_idx            = v.in_tex_idx;
    return o;
}

sampler2D POINT_TEXTURE;
sampler2D SECOND_POINT_TEXTURE;
sampler2D FRAME_TEXTURE;
float BLEND_MODE;

float4 frag(v2f i) : SV_Target
{
#define in_pt_texture POINT_TEXTURE
#define in_second_pt_texture SECOND_POINT_TEXTURE
#define in_frame_texture FRAME_TEXTURE
#define in_blend_mode BLEND_MODE

      float4 base_color = tex2D(in_frame_texture, i.out_frame_tex_coord);
      float4 billboard_color;
      if((i.out_tex_idx).x > 0.0) //x component of out_tex_idx stores index of billboard texture
        billboard_color = tex2D(in_second_pt_texture, i.out_tex_coord);
      else
        billboard_color = tex2D(in_pt_texture, i.out_tex_coord);
      int blend_mode = int(in_blend_mode);
      float4 outColor = float4(blend(blend_mode, base_color.rgb, billboard_color.rgb), billboard_color.a);
      return outColor;
}
ENDCG
#END
