
#DEFPARAMS
PATCH_SIZE = {"PATCH_SIZE", FLOAT, "15.0"},
TEX_COORD_OFFSET = {"TEX_COORD_OFFSET", VEC2, "0.1, 0.1"},
FRAME_IMG = {"FRAME_IMG", TEXTURE2D, "FRAME_IMG"},
#END

#DEFTAG
ShaderName = "CreatePatchImg"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = {ALPAH_OFF}
DRAW_MODE    = {CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF}
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
    float4 in_pos : POSITION;
    float2 in_tex_coord : TEXCOORD0;
};

struct v2f
{
    float2 out_tex_coord : TEXCOORD1;
    float4 out_pos : SV_POSITION;
};

v2f vert(appdata v)
{
    v2f o;
    o.out_pos = v.in_pos;
    o.out_tex_coord = v.in_tex_coord;
    return o;
};

float PATCH_SIZE;
float2 TEX_COORD_OFFSET;
sampler2D FRAME_IMG;

float4 frag(v2f i) : SV_Target
{
#define in_patch_size PATCH_SIZE
#define in_high_res_img FRAME_IMG
#define in_tex_coord_offset TEX_COORD_OFFSET

    float patch_pixel_num = 0.0;
    float patch_pixel_intensity = 0.0;
    float2 patch_pixel = i.out_tex_coord;
    float3 pixel_rgb = float3(0.0, 0.0, 0.0);
    for(float offset_x = 0.0; offset_x < in_patch_size; offset_x += 1.0)
    {
      patch_pixel.x = (i.out_tex_coord).x + offset_x * in_tex_coord_offset.x;
      if(patch_pixel.x > 1.0)
          break;

          for(float offset_y = 0.0; offset_y < in_patch_size; offset_y += 1.0)
          {
              patch_pixel.y = (i.out_tex_coord).y + offset_y * in_tex_coord_offset.y;
              if(patch_pixel.y > 1.0)
                  break;

              pixel_rgb = tex2D(in_high_res_img, patch_pixel).rgb;
              patch_pixel_intensity += (0.299 * pixel_rgb.r + 0.587 * pixel_rgb.g + 0.114 * pixel_rgb.b);
              patch_pixel_num += 1.0;
          }
      }
      if(patch_pixel_num > 0.0)
          patch_pixel_intensity /= patch_pixel_num;
      float4 outColor = float4(patch_pixel_intensity);
      return outColor;
}
ENDCG
#END
