
#SHADER_DEFINE BaseVideoVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 		HIGH,	VEC4,	"in_Position" },
        { ATTRIBUTE_COORDNATE0,			MEDIUM,	VEC2,		"in_Coordinate" },
        { DEVICE_COORDINATE_Y_FLIP, HIGH,   FLOAT,  "in_Flip"},
	}
	FUNCTION_OUTPUT =
	{
        { ATTRIBUTE_COORDNATE0,		MEDIUM,	VEC2,		"Out_Coordinate" },
	}

#SHADER_CODE	
    vec4 scale = vec4(
      1.0f,
      in_Flip,
      1.0f,
      1.0f
    );
    gl_Position = scale * in_Position;
    mediump vec2 Out_Coordinate = in_Coordinate;
#END_CODE
#END_DEFINE


#SHADER_DEFINE BaseVideoFragment

	FUNCTION_INPUT = 
	{
        { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,	"in_DiffuseTexture" },
        { ATTRIBUTE_COORDNATE0,	MEDIUM,	VEC2,		"in_Coordinate" },
        { TEXTURE_LOCATION, MEDIUM, VEC2, "in_TextureLocation" },
        { TEXTURE_SPLIT_INFO, MEDIUM, VEC2, "in_TextureSplitInfo"},
        { TEXTURE_SIZE, MEDIUM, VEC2, "in_TextureSize"},
	}
  FUNCTION_OUTPUT =
  {
  }
#SHADER_CODE

    mediump float rows = in_TextureSplitInfo.x;
    mediump float cols = in_TextureSplitInfo.y;
    mediump float xLoc = in_TextureLocation.x;
    mediump float yLoc = in_TextureLocation.y;
    
    mediump float texSizeX = in_TextureSize.x;
    mediump float texSizeY = in_TextureSize.y;
    

    //纹理中间切割的地方两遍必须都让出一个像素
    //yLoc: 0, in_Coordinate.x:1 -
    //yLoc: 1, in_Coordinate.x:0 +
    mediump float dir = sign(yLoc - 0.5);
    mediump float coordinate_v = xLoc / rows + in_Coordinate.y / rows;
    mediump float coordinate_u = yLoc / cols + in_Coordinate.x / cols;

    gl_FragColor = texture2D(in_DiffuseTexture,vec2(coordinate_u,coordinate_v));
#END_CODE
#END_DEFINE



