#SHADER_DEFINE TTSmoothVertex

#SHADER_CODE

attribute vec3 attPosition;
attribute vec2 attUV;

varying mediump vec2 textureCoordinate;
varying mediump vec4 textureShift_1;
varying mediump vec4 textureShift_2;
varying mediump vec4 textureShift_3;
varying mediump vec4 textureShift_4;

uniform float widthOffset;
uniform float heightOffset;

void main(void) {
    gl_Position = vec4(attPosition, 1.0);
    textureCoordinate = attUV;
    
    textureShift_1 = vec4(attUV + vec2(-widthOffset, 0.0), attUV + vec2(widthOffset, 0.0));
    textureShift_2 = vec4(attUV + vec2(0.0, -heightOffset), attUV + vec2(0.0, heightOffset));
    textureShift_3 = vec4(attUV + vec2(widthOffset, heightOffset), attUV + vec2(-widthOffset, -heightOffset));
    textureShift_4 = vec4(attUV + vec2(-widthOffset, heightOffset), attUV + vec2(widthOffset, -heightOffset));
}

#END_CODE
#END_DEFINE


#SHADER_DEFINE TTSmoothFragment


#SHADER_CODE

precision lowp float;

varying mediump vec2 textureCoordinate;
varying mediump vec4 textureShift_1;
varying mediump vec4 textureShift_2;
varying mediump vec4 textureShift_3;
varying mediump vec4 textureShift_4;

uniform sampler2D inputImageTexture1;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;
uniform sampler2D inputImageTexture4;

uniform float smoothIntensity;
uniform float whitenIntensity;
uniform float sharpenIntensity;

lowp vec3 lookup8x8(lowp vec3 iColor) {
    iColor = clamp(iColor, 0.0, 1.0);
    mediump float blueColor = iColor.b * 63.0;
    mediump vec2 quad1;
    quad1.y = floor(floor(blueColor) / 8.0);
    quad1.x = floor(blueColor) - (quad1.y * 8.0);
    mediump vec2 texPos1;
    texPos1.x = (quad1.x * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * iColor.r);
    texPos1.y = (quad1.y * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * iColor.g);

    return texture2D(inputImageTexture4, texPos1).rgb;
}

lowp vec3 ContrastSaturationBrightness(lowp vec3 color, lowp float brt, lowp float sat, lowp float con) {
    const lowp vec3 LumCoeff = vec3(0.2125, 0.7154, 0.0721);
    lowp vec3 AvgLumin = vec3(0.5);
    lowp vec3 brtColor = color * brt;
    lowp vec3 intensity = vec3(dot(brtColor, LumCoeff));
    lowp vec3 satColor = mix(intensity, brtColor, sat);
    lowp vec3 conColor = mix(AvgLumin, satColor, con);

    return conColor;
}

void main() {

    float factor1 = 2.782;
    float factor2 = 1.131;
    float factor3 = 1.158;
    float factor4 = 2.901;
    float factor5 = 0.979;
    float factor6 = 0.639;
    float factor7 = 0.963;
    float blurOpacity = 0.460;

    lowp vec4 inputColor = texture2D(inputImageTexture1, textureCoordinate);
    if(smoothIntensity < 0.01) {
        lowp vec3 lookupColor = lookup8x8(inputColor.rgb);
        gl_FragColor = vec4(mix(inputColor.rgb, lookupColor, whitenIntensity), 1.0);
        return;
    }
    float skinProbability = texture2D(inputImageTexture3, textureCoordinate).r * blurOpacity;
    lowp vec4 blurColor = texture2D(inputImageTexture2, textureCoordinate);

    float cDist = distance(vec3(0.0), max(blurColor.rgb - inputColor.rgb, 0.0)) * factor1;
    float dDist = distance(vec3(0.0), max(inputColor.rgb - blurColor.rgb, 0.0)) * factor4;

    lowp vec3 brightColor = ContrastSaturationBrightness(inputColor.rgb, factor2, 1.0, factor3);
    lowp vec3 mix11Color = mix(inputColor.rgb, brightColor.rgb, cDist);

    lowp vec3 darkColor = ContrastSaturationBrightness(inputColor.rgb, factor5, 1.0, factor6);
    lowp vec3 mix115Color = mix(mix11Color.rgb, darkColor.rgb, dDist);

    lowp vec3 mix116Color = mix(inputColor.rgb, mix115Color.rgb, factor7);
    lowp vec3 mix12Color = mix(mix116Color.rgb, blurColor.rgb, skinProbability);

    lowp vec3 smoothColor = mix(inputColor.rgb, mix12Color.rgb, smoothIntensity);

    mediump float sum = 0.25 * inputColor.g;

    sum += 0.125 * texture2D(inputImageTexture1, textureShift_1.xy).g;
    sum += 0.125 * texture2D(inputImageTexture1, textureShift_1.zw).g;
    sum += 0.125 * texture2D(inputImageTexture1, textureShift_2.xy).g;
    sum += 0.125 * texture2D(inputImageTexture1, textureShift_2.zw).g;
    sum += 0.0625 * texture2D(inputImageTexture1, textureShift_3.xy).g;
    sum += 0.0625 * texture2D(inputImageTexture1, textureShift_3.zw).g;
    sum += 0.0625 * texture2D(inputImageTexture1, textureShift_4.xy).g;
    sum += 0.0625 * texture2D(inputImageTexture1, textureShift_4.zw).g;

    float hPass = inputColor.g - sum + 0.5;
    float flag = step(0.5, hPass);
    highp vec3 sharpColor = mix(max(vec3(0.0), (2.0 * hPass + smoothColor - 1.0)),
                                min(vec3(1.0), (2.0 * hPass + smoothColor - 1.0)),
                                flag);
    vec3 empColor = mix(smoothColor.rgb, sharpColor.rgb, sharpenIntensity);

    lowp vec3 lookupColor = lookup8x8(empColor);
    gl_FragColor = vec4(smoothColor, 1.0);
}

#END_CODE

#END_DEFINE
