#SHADER_DEFINE TTGaussianBlurVertex


#SHADER_CODE

attribute vec3 attPosition;
attribute vec2 attUV;
const int GAUSSIAN_SAMPLES = 9;
uniform float texelWidthOffset;
uniform float texelHeightOffset;
varying mediump vec2 blurCoordinates[GAUSSIAN_SAMPLES];
void main() {
    gl_Position = vec4(attPosition, 1.0);
    
    int multiplier = 0;
    vec2 blurStep;
    vec2 singleStepOffset = 2.7*vec2(texelWidthOffset, texelHeightOffset);
    
    for(int i = 0; i < GAUSSIAN_SAMPLES; i++)
    {
        multiplier = (i - ((GAUSSIAN_SAMPLES - 1)/2));
        blurStep = float(multiplier) * singleStepOffset;
        blurCoordinates[i] = attUV.xy + blurStep;
    }
}

#END_CODE
#END_DEFINE



#SHADER_DEFINE TTGaussianBlurFragment


#SHADER_CODE


precision lowp float;
const int GAUSSIAN_SAMPLES = 9;
uniform float distanceNormalizationFactor;

uniform sampler2D inputImageTexture1;
varying mediump vec2 blurCoordinates[GAUSSIAN_SAMPLES];

void main() {
    lowp vec4 centralColor; lowp float gaussianWeightTotal;
    lowp vec4 sum;
    lowp vec4 sampleColor;
    lowp float distanceFromCentralColor;
    lowp float gaussianWeight;
    
    centralColor = texture2D(inputImageTexture1, blurCoordinates[4]);
    gaussianWeightTotal = 0.18; sum = centralColor * 0.18;
    
    sampleColor = texture2D(inputImageTexture1, blurCoordinates[0]);
    distanceFromCentralColor = min(distance(centralColor.g, sampleColor.g) * distanceNormalizationFactor, 1.0);
    gaussianWeight = 0.05 * (1.0 - distanceFromCentralColor);
    gaussianWeightTotal += gaussianWeight;
    sum += sampleColor * gaussianWeight;
    
    sampleColor = texture2D(inputImageTexture1, blurCoordinates[1]);
    distanceFromCentralColor = min(distance(centralColor.g, sampleColor.g) * distanceNormalizationFactor, 1.0);
    gaussianWeight = 0.09 * (1.0 - distanceFromCentralColor);
    gaussianWeightTotal += gaussianWeight; sum += sampleColor * gaussianWeight;
    
    sampleColor = texture2D(inputImageTexture1, blurCoordinates[2]);
    distanceFromCentralColor = min(distance(centralColor.g, sampleColor.g) * distanceNormalizationFactor, 1.0);
    gaussianWeight = 0.12 * (1.0 - distanceFromCentralColor);
    gaussianWeightTotal += gaussianWeight; sum += sampleColor * gaussianWeight;
    
    sampleColor = texture2D(inputImageTexture1, blurCoordinates[3]);
    distanceFromCentralColor = min(distance(centralColor.g, sampleColor.g) * distanceNormalizationFactor, 1.0);
    gaussianWeight = 0.15 * (1.0 - distanceFromCentralColor);
    gaussianWeightTotal += gaussianWeight; sum += sampleColor * gaussianWeight;
    
    sampleColor = texture2D(inputImageTexture1, blurCoordinates[5]);
    distanceFromCentralColor = min(distance(centralColor.g, sampleColor.g) * distanceNormalizationFactor, 1.0);
    gaussianWeight = 0.15 * (1.0 - distanceFromCentralColor);
    gaussianWeightTotal += gaussianWeight; sum += sampleColor * gaussianWeight;
    
    sampleColor = texture2D(inputImageTexture1, blurCoordinates[6]);
    distanceFromCentralColor = min(distance(centralColor.g, sampleColor.g) * distanceNormalizationFactor, 1.0);
    gaussianWeight = 0.12 * (1.0 - distanceFromCentralColor);
    gaussianWeightTotal += gaussianWeight; sum += sampleColor * gaussianWeight;
    
    sampleColor = texture2D(inputImageTexture1, blurCoordinates[7]);
    distanceFromCentralColor = min(distance(centralColor.g, sampleColor.g) * distanceNormalizationFactor, 1.0);
    gaussianWeight = 0.09 * (1.0 - distanceFromCentralColor);
    gaussianWeightTotal += gaussianWeight; sum += sampleColor * gaussianWeight;
    
    sampleColor = texture2D(inputImageTexture1, blurCoordinates[8]);
    distanceFromCentralColor = min(distance(centralColor.g, sampleColor.g) * distanceNormalizationFactor, 1.0);
    gaussianWeight = 0.05 * (1.0 - distanceFromCentralColor);
    gaussianWeightTotal += gaussianWeight; sum += sampleColor * gaussianWeight;
    
    gl_FragColor = sum / gaussianWeightTotal;
}

#END_CODE
#END_DEFINE
