local libvenuscore = require "libvenuscore"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "window.editor.command.content_manager"
local ParameterPropertyChangeCommand = CommandBase:extend("ParameterPropertyChangeCommand");

function ParameterPropertyChangeCommand:new(uuid, smsId, paramId, keyName, value)
    ParameterPropertyChangeCommand.super.new(self);
    self._uuid = uuid;
    self._smsId = smsId;
    self._paramId = paramId;
    self._keyName = keyName;
    self._value = value;
end

function ParameterPropertyChangeCommand:DoIt()
    if self._uuid then
        local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
        if com then
          local param = com:GetParameterById(self._smsId, self._paramId);
          if param then
            self._preValue = param[self._keyName]; --之前值
            param[self._keyName] = self._value
          end
          
        end
      end
 end

 function ParameterPropertyChangeCommand:Undo()
    if self._uuid then
      local com = self:GetContent(self._uuid);
      if com then
        local param = com:GetParameterById(self._paramId);
        if param then
            param[self._keyName] = self._preValue;
        end
        
      end
    end
end

return ParameterPropertyChangeCommand;