local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local CreateStateMachineCommand = CommandBase:extend("CreateStateMachineCommand");

function CreateStateMachineCommand:new(uuid)
    CreateStateMachineCommand.super.new(self);
    self._uuid = uuid;
    self._smUUID = ContentManager:GenerateUUID();
    self._stateMachine = nil;
end

function CreateStateMachineCommand:DoIt()
    self:BeginCmd();
    local sm = nil;
    if self._uuid then
      local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
      if ani then
        sm = ani:CreateStateMachine();
        sm:SetStaticID(self._smUUID);
        self._stateMachine = sm;
      end
    end
    self:EndCmd();
end

function CreateStateMachineCommand:Undo()
    self:BeginCmd();
    if self._stateMachine then
        local ani = self:GetContent(self._uuid);
        ani:RemoveStateMachine(0, self._stateMachine);
    end
    self:EndCmd();
end

return CreateStateMachineCommand;