local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local saturationfilter = {}
saturationfilter.material = nil;
saturationfilter.renderobject = nil;
saturationfilter.Queue = 112;


function saturationfilter:Initialize(host, size)
    --<!--  set the offsets parameters in vertex shader -->
  self.SATURATION = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"SATURATION");
  self.renderobject = host:CreateRenderObject();
  self.material = host:CreateMaterial("comm:documents/filter/material/saturationfilter.material" );
  self.material:SetParameter(self.SATURATION, mathfunction.vector1( 0.7 ) );
  --self:_SetParam(size);
  return self.Queue;
end

function saturationfilter:Resizeview(size)
  --self:_SetParam(size);
end

function saturationfilter:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.material:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.renderobject, self.material);
  context:EndRenderPass();
end

return saturationfilter;