local BD = require "bluecore.bluedefined"
local BU = require "bluecore.blueutility"
local BR = require "bluecore.core.blue_rtti"
local Types = require "venuscore.rtti.types"
local BlueNode = require "bluecore.bluenode"
local BlueprintSelf = require "bluecore.core.blueprint_self"
local BluePinInfo = require "bluecore.bluepininfo"
local UnBindEventDispatcher = BlueNode:extend();


UnBindEventDispatcher:MemberRegister("_clsId");
UnBindEventDispatcher:MemberRegister("_dispId");
UnBindEventDispatcher:MemberRegister("nodeName");


function UnBindEventDispatcher:new(graph)

  UnBindEventDispatcher.super.new(self, graph)

  self._inputInfoArray = {}  -- 简化版本的 arg_info

end


function UnBindEventDispatcher:_OnBeginCreateEd(clsUid, dispatchId)
  self._clsId = clsUid;
  self._dispId = dispatchId ;
  self:_Setup(self._clsId,  self._dispId)
end

function UnBindEventDispatcher:DynamicRegisterInput(argId, rtti, name, tips, default, delAble, groupName)

  if tips == nil then tips = "["..tostring(argId).."]" end
  if name == nil then name = "["..tostring(argId).."]" end

  local info = BluePinInfo(BD.PIN_DATA_INPUT, argId, rtti, name, tips, default, delAble, groupName);
  self.infoTable[BD.PIN_DATA_INPUT][argId] = info

  return info ;

end

-- 蓝图类相关的 比如 函数调用/事件分发器调用/绑定/取消绑定/取消所有绑定 都是在 _OnDeserializePost 阶段才完成引脚的重建
-- 特化的蓝图节点 是不依赖其他节点的
function UnBindEventDispatcher:_OnDeserializePost()
  self:_Setup(self._clsId,  self._dispId)
end

function UnBindEventDispatcher:_Setup(clsUid, dispatchId)

  local originExecInputsInfo = self.infoTable[BD.PIN_EXEC_INPUT]
  local originExecOutputsInfo = self.infoTable[BD.PIN_EXEC_OUTPUT]

  self.infoTable = {}
  self.infoTable[BD.PIN_DATA_INPUT] = {}  -- 1: Types.BlueprintType 2: Types.EventDelegateType
  self.infoTable[BD.PIN_DATA_OUTPUT] = {} -- no
  self.infoTable[BD.PIN_EXEC_INPUT]  = originExecInputsInfo
  self.infoTable[BD.PIN_EXEC_OUTPUT] = originExecOutputsInfo

  local blueType
  local delegateType
  if _KRATOSEDITOR then
    local clsInfo = BR.GetClassesByIdEd(clsUid);
    local dispatcher
    if clsInfo ~= nil then
      blueType = BR.GetRttiByClsId(clsUid);

      local dispatchers = clsInfo:GetEventDispatchers()
      dispatcher = dispatchers[dispatchId]

      if dispatcher ~= nil then
        self:SetFunctionName("Unbind Event "..dispatcher:GetName())
        local inputInfo = dispatcher:GetInputInfo();
        delegateType = self:_SetupDelegateTypeEd(inputInfo);
      else
        self._failReason = "Dispatcher is deleted"
      end
    else
      self._failReason = "Class is deleted"
    end

    if blueType == nil then
      blueType = Types.BlueprintType.INVALID_BLUEPRINT_TYPE
    end

    if dispatcher == nil then
      self:SetFunctionName("UnBind Event n/a")
      delegateType = self:_SetupDelegateTypeEd({}); -- 已经被删除 直接用空签名
    else
      dispatcher:AddRefactor(self);
    end

  else
    self:SetFunctionName("UnBind Event default")
    blueType = BR.GetRttiByClsId(clsUid);
    delegateType = Types.EventDelegateType.DEFAULT_DELEGATE_TYPE
  end

  local label = "Target"
  self:DynamicRegisterInput(1, blueType, label, label, BlueprintSelf());
  label = "Event"
  self:DynamicRegisterInput(2, delegateType, label, label);

end


function UnBindEventDispatcher:_SetupDelegateTypeEd(_inputInfoArray)
  local newType = Types.EventDelegateType:extend()
  newType:SetArgsInfo(_inputInfoArray)
  return newType
end

function UnBindEventDispatcher:IsAllowDuplicate()
  return false;
end

function UnBindEventDispatcher:EditorPinAdd( )
  -- 直接引用类信息中的事件分发器信息,dispatcher:GetInputInfo
  -- 可以立刻同步,但用户需在编译时候发现错误(签名不一致)
end

function UnBindEventDispatcher:EditorPinDelete( )

end

function UnBindEventDispatcher:InfoChange( )

end

function UnBindEventDispatcher:ToBeDeletedEd()

  local classInfo = BR.GetClassesByIdEd(self._clsId);
  local dispatchers = classInfo:GetEventDispatchers()
  local dispatcherInfo = dispatchers[self._dispId]
  local name = dispatcherInfo:GetName()
  self._failReason = "dispatcher  "..tostring(name).." is deleted"
  -- 蓝图上没有移除节点
end

function UnBindEventDispatcher:NameChanged(oldName, newName)
  self:SetFunctionName("Unbind Event "..newName)
end

function UnBindEventDispatcher:_OnDeleteEd()
  local classInfo = BR.GetClassesByIdEd(self._clsId);
  if classInfo ~= nil then
    local dispatchers = classInfo:GetEventDispatchers()
    local dispatcherInfo = dispatchers[self._dispId]
    if dispatcherInfo ~= nil then
      dispatcherInfo:RemoveRefactor(self)
    else
      WARNING(string.format("Dispatcher deleted before %s %s", tostring(self._clsId), tostring(self._dispId)))
    end
  else
    WARNING(string.format("Class deleted before %s %s", tostring(self._clsId), tostring(self._dispId)))
  end
end

function UnBindEventDispatcher:_OnCompile()
  if self._failReason then
    self.compileResult = self._failReason
    return false
  end
  return true
end

function UnBindEventDispatcher:_OnUpdateByEditor()
  if self._failReason then
    self.compileResult = self._failReason
  end
end

-- override BlueNode's _GetInput
function UnBindEventDispatcher:_GetInput()
  self.inputArgs = {}

  local arg1Input = self.dependInputs[1];
  arg1Input[1]:Update();
  self.inputArgs[1] = arg1Input[1]:GetOutputByIndex(arg1Input[2]);

  local arg2Input = self.dependInputs[2];
  local customEventNode = arg2Input[1] -- 不需要update 直接用自定义事件节点(实例)
  self.inputArgs[2] = customEventNode

  return self.inputArgs
end


function UnBindEventDispatcher:_OnUpdate(args)
  local variation = args[1]
  local customEventNode = args[2]
  if variation.GetTypeName then
    local blueprint = variation
    local dispatcher = blueprint:GetEventDispatcherByUid(self._dispId)
    dispatcher:RemoveDelegate(customEventNode);
  else
    for _, blueprint in pairs(variation) do
      local dispatcher = blueprint:GetEventDispatcherByUid(self._dispId)
      dispatcher:RemoveDelegate(customEventNode);
    end
  end
end

-- override
function UnBindEventDispatcher:IsInputArrayCompatible(pinInfo)
  if pinInfo.argId == 1 and pinInfo.pinType == BD.PIN_DATA_INPUT then
    return true -- 第一个数据引脚是BlueprintType
  end
  return false
end


function UnBindEventDispatcher:ClsIdChgEd(oldClassId, newClassId)

  if oldClassId ==  self._clsId then

    local classInfo = BR.GetClassesByIdEd(self._clsId);
    local dispatchers = classInfo:GetEventDispatchers()
    local dispatcherInfo = dispatchers[self._dispId]
    dispatcherInfo:RemoveRefactor(self)

    self._clsId =  newClassId
    local blueType = BR.GetRttiByClsId(self._clsId);
    local bluePinInfo = self.infoTable[BD.PIN_DATA_INPUT][1]
    bluePinInfo:ChangeRtti(blueType, BlueprintSelf())
  end
end


UnBindEventDispatcher:RegisterExecInput(1, "exec", "Execute");
UnBindEventDispatcher:RegisterExecOutput(1, "exec", "Execute");
UnBindEventDispatcher:SetFunctionName("UnBind Event Dispatcher");
UnBindEventDispatcher:SetFunctionType(BD.EVENT_DISPATCH_NODE);


return UnBindEventDispatcher
