local GetAllBlueprintOfClass = require "bluecore.bluenodes.utility.get_all_blueprint_of_class"
local BR = require "bluecore.core.blue_rtti"
local Types = require "venuscore.rtti.types"

local GetAllNoExec = GetAllBlueprintOfClass:extend();

local INVALID_CLASS_ID = Types.BlueprintType.INVALID_CLASS_ID
local INVALID_BLUEPRINT_TYPE = Types.BlueprintType.INVALID_BLUEPRINT_TYPE

function GetAllNoExec:new(...)
  GetAllNoExec.super.new(self, ...)
  self._classObject = setmetatable({}, { __mode = 'v' })
end

local DynamicComboType = Types.ComboType:extend();
-- override GetComboData
function DynamicComboType:GetComboData()
  local allClassCombo = BR.GetComboDataOfClass()
  return allClassCombo;
end

GetAllNoExec:RegisterInput(1, DynamicComboType , "class", "Select Blueprint Class", INVALID_CLASS_ID);
GetAllNoExec:RegisterOutput(1, INVALID_BLUEPRINT_TYPE, "blueprints", "all blueprint instance of given class")
GetAllNoExec:SetFunctionName("Get All Blueprint Of Class(no exec)");

return GetAllNoExec;

