local BlueNode = require "bluecore.bluenode"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"

local Cos = BlueNode:extend();

---- 游戏运行模式
function Cos:new(...)
  Cos.super.new(self, ...)
end

function Cos:_OnUpdate(args)
  
  return math.cos(args[1]), math.cos(args[2]*math.pi/180.0);
end

---- 编辑器模式

Cos:RegisterInput(1, Types.FloatType, "pi", "[1]", 0);
Cos:RegisterInput(2, Types.FloatType, "angle", "[2]", 0);
Cos:RegisterOutput(1, Types.FloatType, "cos(pi)", "余弦结果(输入弧度)");
Cos:RegisterOutput(2, Types.FloatType, "cos(angle)", "余弦结果(输入角度)");
Cos:SetFunctionName("Cos");
Cos:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return Cos;

