local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local Mod = BlueNode:extend();

---- 游戏运行模式
function Mod:new(...)
  Mod.super.new(self, ...)
end

-- math.fmod(14, 5)   4
-- math.fmod(-14, 5)  -4 与C++一致
function Mod:_OnUpdate(args)
  return math.fmod(args[1],args[2]);
end

---- 编辑器模式
Mod:RegisterInput(1, Types.IntType, "1", "[1]", 1);
Mod:RegisterInput(2, Types.IntType, "2", "[2]", 1);

Mod:RegisterOutput(1, Types.IntType, "mod", "余数,向0靠近");

Mod:SetFunctionName("mod");
Mod:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return Mod;