local BlueNode = require "bluecore.bluenode"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"

local NoLess = BlueNode:extend();

---- 游戏运行模式
function NoLess:new(...)
  NoLess.super.new(self, ...)
  self.result = false ;
end

function NoLess:_OnUpdate(args)
  if args[1] >=  args[2] then
    self.result = true
  else
    self.result = false
  end
  return self.result;
end

---- 编辑器模式
NoLess:RegisterInput(1, Types.IntType, "1", "[1]", 0);
NoLess:RegisterInput(2, Types.IntType, "2", "[2]", 0);
NoLess:RegisterOutput(1, Types.BoolType, ">=", "对比结果");
NoLess:SetFunctionName(">=");
NoLess:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return NoLess ;

