local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local FloatToInt = BlueNode:extend();

---- 游戏运行模式
function FloatToInt:new(...)
  FloatToInt.super.new(self, ...)
  self.result = false ;
end

function FloatToInt:_OnUpdate(args)
  if args[1] == nil then
    return 0
  else
    --  1.2 ->  1
    -- -1.2 -> -1 -- 与C++一致
    return math.modf(args[1])
  end 

end

---- 编辑器模式
FloatToInt:RegisterInput(1, Types.FloatType, "float", "浮点数", 0.0);
FloatToInt:RegisterOutput(1, Types.IntType, "integer", "整数");
FloatToInt:SetFunctionName("float->int");
FloatToInt:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return FloatToInt ;

