
local AE = require "apolloengine"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local BlueRtti = require "bluecore.core.blue_rtti"
local RttiOfTE = AE.TextureEntity:RTTI();
local CreateTex2DDetail = BlueNode:extend();

--Unreal Engine: Import File as Texture 2D

---- 游戏运行模式
function CreateTex2DDetail:new(...)
  CreateTex2DDetail.super.new(self, ...)
end


function CreateTex2DDetail:_OnUpdate(args)

  local filepath = args[1]
  local entity = BlueRtti.Create(RttiOfTE, filepath, AE.TextureEntity.TT_TEXTURE2D,
          args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10])

  return entity;

end


---- 编辑器模式
CreateTex2DDetail:RegisterInput(1, Types.Tex2DPathType, "Tex2D Path", "根据纹理路径创建纹理", "DEVICE_CAPTURE");

CreateTex2DDetail:RegisterInput(2, Types.TexUsageType, "usage", "用法", AE.TextureEntity.TU_STATIC)
CreateTex2DDetail:RegisterInput(3, Types.TexPixelFormatType, "format", "格式", AE.TextureEntity.PF_AUTO)

CreateTex2DDetail:RegisterInput(4, Types.IntType, "anisotropic", "各向异性", 1)
CreateTex2DDetail:RegisterInput(5, Types.BoolType, "use mipmap", "UseMipMap", false);
CreateTex2DDetail:RegisterInput(6, Types.IntType, "mipmap level", "MipMapLevel", 0);
CreateTex2DDetail:RegisterInput(7, Types.TexWrapType, "s warp", "Warp of s", AE.TextureEntity.TW_REPEAT);
CreateTex2DDetail:RegisterInput(8, Types.TexWrapType, "t warp", "Warp of t", AE.TextureEntity.TW_REPEAT);
CreateTex2DDetail:RegisterInput(9, Types.TexFilterType, "mag filter", "Filter of mag", AE.TextureEntity.TF_NEAREST );
CreateTex2DDetail:RegisterInput(10,Types.TexFilterType, "min filter", "Filter of min", AE.TextureEntity.TF_NEAREST );


CreateTex2DDetail:RegisterOutput(1, RttiOfTE, "Tex", "输出纹理");

CreateTex2DDetail:RegisterExecInput(1, "exec", "执行");

CreateTex2DDetail:RegisterExecOutput(1, "exec", "执行");

CreateTex2DDetail:SetFunctionName("CreateTex2D Detail");


return CreateTex2DDetail;

