local BATNode = require "bluecore.base.blue_anytype_node"
local BD = require "bluecore.bluedefined"

local Types = require "venuscore.rtti.types"

local MoveArray = BATNode:extend();

---- 游戏运行模式
function MoveArray:new(...)
  MoveArray.super.new(self, ...)
end

function MoveArray:_OnUpdate(args)
  if args[1] == nil then
    ERROR("[GetArrayLength] input is nil")
    return nil ;
  end
  local array = args[1];
  local array_size = #array;
  local offset = args[2];
  local real_offset = math.abs(offset) > array_size and math.abs(offset) % array_size or math.abs(offset);
  local rm_idx = offset > 0 and array_size or 1;
  local is_idx = offset > 0 and 1 or array_size;
  if real_offset ~= 0 then  --数组长度整数倍  相当于不移动
    for i = 1, real_offset do
      local element = table.remove(array, rm_idx);
      table.insert(array, is_idx, element);
    end
  end
  --for i = 1, array_size do
  --  LOG("idx "..tostring(i).." val is "..array[i]);
  --end
  return array;
end

---- 编辑器模式
function MoveArray:_OnCreateWithEditor()
  MoveArray.super._OnCreateWithEditor(self);
end

MoveArray:RegisterExecInput(1, "Exec", "执行");
MoveArray:RegisterExecOutput(1, "Exec", "执行");

MoveArray:RegisterInput(1, Types.AnyArrayType, "Array", "通配数组", {}, false, BATNode.DEFAULT_GROUP);
MoveArray:RegisterInput(2, Types.IntType, "offset", "偏移量（1表示123->312/-1表示123->231）", 1, false, nil)
MoveArray:RegisterOutput(1, Types.AnyArrayType, "result", "输出数组", Types.AnyArrayType(), false , BATNode.DEFAULT_GROUP);

MoveArray:SetFunctionName("cycle_move");

return MoveArray ;
