local Types = require "venuscore.rtti.types"
local cv = require "computervisionfunction"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"

local GetFace106 = BlueNode:extend();

---- 游戏运行模式
function GetFace106:new(...)
  GetFace106.super.new(self, ...)
end

function GetFace106:_OnUpdate(args)
  local comp = args[1];
  local index = args[2];
  local result = comp:GetFace106(index);
  return result;
end

---- 编辑器模式

GetFace106:RegisterInput(1, cv.RecognitionComponent:RTTI(), "target", "RecognitionComponent组件", BlueSelf());
GetFace106:RegisterInput(2, Types.IntType, "index", "序号(从1开始)", 1);
GetFace106:RegisterOutput(1, Types.Face106Type, "face106", "106人脸点数据");
GetFace106:SetFunctionName("GetFace106");

return GetFace106 ;

