local venuscore = require "libvenuscore"
local AE = require "apollocore"
local Types = require "venuscore.rtti.types"
local BN = require "bluecore.bluenode"
local BS = require "bluecore.blueself"
local EventDispatcher = require "bluecore.eventdispatcher"
local BD = require "bluecore.bluedefined"
local BU = require "bluecore.blueutility"
local OverLayBase = BN:extend();

OverLayBase.BREAK = 0
OverLayBase.TRIGGER = 1

OverLayBase.BlueNodeExtend = BN.extend;

-- sub class: Override Function:  _OnUpdate, _GetType,
-- sub class: call Function : RegisterOutput, SetFunctionName
function OverLayBase:extend(...)
  local clazz = OverLayBase.BlueNodeExtend(self,...)
  for pinType, infos in pairs(OverLayBase.infoTable) do
    -- shallow copy is ok (NOT allow to modify BaseNode pin, but it's ok to add more pin)
    for _, info in pairs(infos) do
      table.insert(clazz.infoTable[pinType], info)
    end
  end
  return clazz
end


function OverLayBase:new(...)
  OverLayBase.super.new(self, ...)
  self:_OnReset();
  self.regexString = ""
end

function OverLayBase:_OnReset()
  self.nextExecIdx = OverLayBase.BREAK
end

function OverLayBase:_OnNextBranch()
  return self.nextExecIdx
end

function OverLayBase:RegisterTriggerFunc(func, bluePrintSelf)

  local args = self:_GetInput()

  -- 调用blueprint reset会导致所有node的inputArgs清空
  local str = args[2]
  self.regexString = str == BD.EMPTY_STRING and "" or str

  EventDispatcher:RegisterCallback(
          args[1]:GetContentPath(),
          self:_GetType(),
          func,
          bluePrintSelf)
end


function OverLayBase:_OnCompile()
  self.compileResult = nil
  if OverLayBase.super._OnCompile(self) then
    if #self.inputs[1].links ~= 0 then
      local bluePinLink = self.inputs[1].links[1]
      local otherNode = self.graph:GetNode(bluePinLink.nodeUid);
      if otherNode:GetFunctionType() == BD.COMPONENT_NODE and otherNode.comp == nil then
        self.compileResult = BD.EHINT.NOT_LINK_TO_COMP
        return false
      end
      if venuscore.isNil(otherNode.comp) then
        self.compileResult = BD.EHINT.COMP_LOST
        return false
      end
    else
      self.compileResult = BD.EHINT.PIN_1_EMPTY;
    end
    return true ;
  end
  return false;
end

function OverLayBase:_OnDeserialize()
  OverLayBase.super._OnDeserialize(self);
  if self.inputs[2].literal == nil then
    ERROR("OverLayBase empty ....... ");
    self.inputs[2].literal = ''
  end
end


if _KRATOSEDITOR then

  function OverLayBase:_OnLink(selfPin, otherNode, otherPin)
    if BU:IsInputPin(selfPin) and selfPin.argId == 1 then
      if otherNode:GetFunctionType() == BD.COMPONENT_NODE and otherNode.comp then
        if venuscore.isNil(otherNode.comp) then
          ERROR(BD.EHINT.COMP_LOST)
        end
      else
        ERROR(BD.EHINT.NOT_LINK_TO_COMP)
      end
    end
  end

  function OverLayBase:_OnUnLink(unlinkPin)
    if unlinkPin.argId == 1 then -- 断开是第一个引脚
      ERROR(BD.EHINT.PIN_1_EMPTY)
    end
  end

  function OverLayBase:_OnCreateWithEditor()
    OverLayBase.super._OnCreateWithEditor(self);
  end

  function OverLayBase:_OnUpdateByEditor()
    OverLayBase.super._OnUpdateByEditor(self);
    self:_OnCompile();
  end

end

OverLayBase:RegisterInput(1, AE.RigidBodyComponent:RTTI(), "component", "刚体组件", BS());
OverLayBase:RegisterInput(2, Types.StringType, "regex", "regex", "");


OverLayBase:RegisterExecOutput(OverLayBase.TRIGGER, "exec", "exec");

OverLayBase:SetFunctionName("End Overlay");
OverLayBase:SetFunctionType(BD.EVENT_FUNCTION_NODE);
OverLayBase:SetEventType(BD.EventType.RegisterCallback);

return OverLayBase;

