local apollocore = require "apollocore"
local EventDispatcher = require "bluecore.eventdispatcher"
local BD = require "bluecore.bluedefined"
local venuscore = require "libvenuscore"



local gLastEvent = {}
local _fNativeDestroy = apollocore.IComponent.Destroy;
rawset(apollocore.RigidBodyComponent, "Destroy", function(self)
  local staticID =  self:GetContentPath();
  --for id, _ in pairs(gLastEvent) do
  --  ERROR(">>>>>>>>>>>>>>>>>>>>>> RigidBody LastEvent staticID: "..tostring(id))
  --end
  gLastEvent[staticID] = nil
  _fNativeDestroy(self);
end);

rawset(apollocore.RigidBodyComponent, "ResetCached", function(self)
  local staticID =  self:GetContentPath();
  gLastEvent[staticID] = nil
end);

local _fNativeUpdate = apollocore.IComponent.Update;
local UpdateFunc = function(self, def)

  _fNativeUpdate(self, def);

  local staticID =  self:GetContentPath() ;

  if EventDispatcher:HasCompListener(staticID) then

    local oldCollisionMap = gLastEvent[staticID] or {}
    local newCollisionMap = {}

    local collisionDatas = self:GetCollisionInfo();
    if next(collisionDatas) then

      local hasBegin = EventDispatcher:HasEventListener(staticID, BD.Event.CollisionEvent.BeginOverlay)
      local hasKeep  = EventDispatcher:HasEventListener(staticID, BD.Event.CollisionEvent.KeepOverlay)


      for k, collisionData in pairs(collisionDatas) do
        local otherComp = collisionData:GetCollisionObject();

        local edge = false
        if oldCollisionMap[otherComp] == nil then
          edge = true -- Begin Overlay
        else
          oldCollisionMap[otherComp] = nil  -- Keep Overlay
        end
        local otherNode = otherComp:GetHostNode();

        local eventParam = {
          otherComp = otherComp,
          otherNode = otherNode,
          otherName = otherNode:GetName(),
          collisionPointInfo =  collisionData:GetCollisionPoints2() ;
        }

        newCollisionMap[otherComp] = eventParam


        -- unreal each overlay begin & end trigger one event
        if hasBegin and edge then
          local event = {
            staticID = staticID,
            eventType = BD.Event.CollisionEvent.BeginOverlay,
            params = eventParam
          };
          EventDispatcher:PushEvent(event);
        end

        if hasKeep then -- keep overlay, useless ?
          -- keep event will send 'overlay begin' info
          local event = {
            staticID = staticID,
            eventType = BD.Event.CollisionEvent.KeepOverlay,
            params = eventParam -- share with BeginOverlay, it's ok because Blue'EventNode do not modify
          };
          EventDispatcher:PushEvent(event);
        end

      end

      -- keep the old version event
      if EventDispatcher:HasEventListener(staticID, BD.Event.CollisionEvent.Enter) then
        local event = {};
        event.staticID = self:GetContentPath();
        event.eventType = BD.Event.CollisionEvent.Enter;
        EventDispatcher:PushEvent(event);
      end
    end

    local hasEnd = EventDispatcher:HasEventListener(staticID, BD.Event.CollisionEvent.EndOverlay)
    if hasEnd then
      for otherComp, eventParam in pairs(oldCollisionMap) do -- End Overlay
        -- maybe other node/comp will destroy?/explode after first overlay
        -- comp is not nil, then i think node is not nil too
        if not venuscore.isNil(otherComp) then
          local event = {
            staticID = staticID,
            eventType = BD.Event.CollisionEvent.EndOverlay,
            params = {
              otherComp = eventParam.otherComp,
              otherNode = eventParam.otherNode,
              otherName = eventParam.otherName
            }
          };
          EventDispatcher:PushEvent(event);
        end
      end
    end

    gLastEvent[staticID] = newCollisionMap

  end
end

rawset(apollocore.RigidBodyComponent,"Update", UpdateFunc)
