

#DEFPARAMS
TEXELSIZE = { "TexelSize", VEC2, "0.0,0.0" },
BLUR_RADIUS = { "BlurRadius", VEC2, "0.0,0.0" },
#END

#DEFTAG
ShaderName = "SuperMeBlurV"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float2 TEXELSIZE;
float2 BLUR_RADIUS;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float2 aroundCoord[5];
    float radius = BLUR_RADIUS.y * TEXELSIZE.y;
    
    aroundCoord[0] = i.uv + float2(0.0, -2.0*radius);
    aroundCoord[1] = i.uv + float2(0.0, -1.0*radius);
    aroundCoord[2] = i.uv;
    aroundCoord[3] = i.uv + float2(0.0, 1.0*radius);
    aroundCoord[4] = i.uv + float2(0.0, 2.0*radius);

    float4 color;
    float4 out_SurfaceColor;
    color = TEXTURE_DIFFUSE.Sample( TEXTURE_DIFFUSE_Sampler, aroundCoord[0] );
    out_SurfaceColor = color * float4(0.089000002, 0.089000002, 0.089000002, 0.089000002);
    color = TEXTURE_DIFFUSE.Sample( TEXTURE_DIFFUSE_Sampler, aroundCoord[1] );
    out_SurfaceColor = color * float4(0.242, 0.242, 0.242, 0.242) + out_SurfaceColor;
    color = TEXTURE_DIFFUSE.Sample( TEXTURE_DIFFUSE_Sampler, aroundCoord[2] );
    out_SurfaceColor = color * float4(0.338, 0.338, 0.338, 0.338) + out_SurfaceColor;
    color = TEXTURE_DIFFUSE.Sample( TEXTURE_DIFFUSE_Sampler, aroundCoord[3] );
    out_SurfaceColor = color * float4(0.242, 0.242, 0.242, 0.242) + out_SurfaceColor;
    color = TEXTURE_DIFFUSE.Sample( TEXTURE_DIFFUSE_Sampler, aroundCoord[4] );
    mainColor = color * float4(0.089000002, 0.089000002, 0.089000002, 0.089000002) + out_SurfaceColor;
}
ENDCG
#END
