#DEFPARAMS
COLOR        = {"COLOR", TEXTURE2D, "COLOR"},
DISPLAY_MASK = {"DISPLAY_MASK", TEXTURE2D, "DISPLAY_MASK"},
MASK_VALID   = {"MASK_VALID", FLOAT, "0.0"},
INVERT_MASK  = {"INVERT_MASK", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName  = "DisplayStep"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "blendfunc.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

Texture2D COLOR;
Texture2D DISPLAY_MASK;
SamplerState COLOR_Sampler;
SamplerState DISPLAY_MASK_Sampler;
float     MASK_VALID;
float     INVERT_MASK;

v2f vert(appdata v)
{
    v2f o;
    o.vertex = UniformNDC(v.vertex);
    o.uv = v.uv.xy;

    return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float4 color = COLOR.Sample(COLOR_Sampler, i.uv);
    float mask_alpha = INVERT_MASK > 0.0 ? 1.0 - DISPLAY_MASK.Sample(DISPLAY_MASK_Sampler, i.uv).a : DISPLAY_MASK.Sample(DISPLAY_MASK_Sampler, i.uv).a;
    if(MASK_VALID > 0.0)
        color.a = min(mask_alpha, color.a);
    mainColor = color;
}
ENDCG
#END