#DEFPARAMS
PRESSURE        = {"PRESSURE", TEXTURE2D, "PRESSURE"},
PRESSURE_CONFIG = {"PRESSURE_CONFIG",  FLOAT, "0.8"},
FLOAT_MIN       = {"FLOAT_MIN", FLOAT, "-100.0"},
FLOAT_MAX       = {"FLOAT_MAX", FLOAT, "100.0"},
#END

#DEFTAG
ShaderName  = "ClearPressureStep"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

Texture2D PRESSURE;
SamplerState PRESSURE_Sampler;
float     PRESSURE_CONFIG;
float     FLOAT_MIN;
float     FLOAT_MAX;

v2f vert(appdata v)
{
    v2f o;
    o.vertex = UniformNDC(v.vertex);
    o.uv = v.uv.xy;

    return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float4 normalized_pressure = PRESSURE.Sample(PRESSURE_Sampler, i.uv);
    float  pressure            = normalized_pressure.r * (FLOAT_MAX - FLOAT_MIN) + FLOAT_MIN;
    pressure                   = PRESSURE_CONFIG * pressure;
    normalized_pressure.r      = (pressure - FLOAT_MIN) / (FLOAT_MAX - FLOAT_MIN);

    mainColor = normalized_pressure;
}
ENDCG
#END