

#DEFPARAMS
_MainTex = { "Main Tex", TEXTURE2D, "white" },
_MaskTex = { "Mask Tex", TEXTURE2D, "white" },
_Alpha = { "Alpha", FLOAT, "1.0"},
_Brightscale = {"BrightScale", FLOAT, "1.0"},
_MaskPos = {"Mask Pos", VEC2, "300.0,708.0"},
_MaskScale = {"Mask Scale", FLOAT, "1.01"},
#END

#DEFTAG
ShaderName = "ComputeHLOfLipStick"
RenderQueue = "Transparent+1"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "lipstick_3layer.inc"
#include "common.inc"

struct appdata   
{
	float4 vertex : POSITION;
	float2 uv0 : TEXCOORD0;
	float2 uv1 : TEXCOORD1;
};

struct v2f
{
	float2 uv0 : TEXCOORD0; 
	float2 uv1 : TEXCOORD1;   
	float4 vertex : SV_POSITION;
};

Texture2D _MainTex;
Texture2D _HighTex;
Texture2D _MaskTex;
SamplerState _MainTexSampler;
SamplerState _HighTexSampler;
SamplerState _MaskTexSampler;
float _Alpha;
float2 _MaskPos;
float _MaskScale;
float _Brightscale;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	float4 facetexpara = float4(1.0/(167.0*_MaskScale),1.0/(122.0*_MaskScale),_MaskPos.x/(-167.0*_MaskScale),_MaskPos.y/(-122.0*_MaskScale));
	o.uv0 = v.uv0*facetexpara.xy+facetexpara.zw;
	o.uv1 = float2(1.0+v.vertex.x,1.0-v.vertex.y)/2.0;
	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
	// sample the texture
	float4 basecolor = _MainTex.Sample(_MainTexSampler, i.uv1);
	float4 blendcolor = _MaskTex.Sample(_MaskTexSampler, i.uv0);
  float3 hightlightcolor = _HighTex.Sample(_HighTexSampler, i.uv1).rgb;//匹配fbo传入的坐标
  float3 newcolor2 = blendOverlaylipsticks(basecolor.rgb, hightlightcolor);//第三次混合
  newcolor2 = newcolor2*blendcolor.a+basecolor.rgb*(1.0-blendcolor.a); //mask过滤
  float atten = 1.0 - _Brightscale*hightlightcolor.b;
  newcolor2 = (float3(1.0,1.0,1.0) - (float3(1.0,1.0,1.0) - newcolor2) * float3(atten,atten,atten));
  newcolor2 = newcolor2*_Alpha + basecolor.rgb*(1.0-_Alpha); //滑动条
  outColor = float4(newcolor2,1.0);
}
ENDCG
#END
